/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseExtra;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseLessonService;
import com.baijia.tianxiao.sal.wx.api.OrgCourseExtraService;
import com.baijia.tianxiao.sal.wx.api.WxBizScheduleService;
import com.baijia.tianxiao.sal.wx.api.WxCommonCounterService;
import com.baijia.tianxiao.sal.wx.api.WxStudentCourseService;
import com.baijia.tianxiao.sal.wx.enums.BizScheduleType;
import com.baijia.tianxiao.sal.wx.model.WxCommonCounterKey;
import com.baijia.tianxiao.sal.wx.model.WxCourseStudentInfo;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wxStudentCourseService")
public class WxStudentCourseServiceImpl
implements WxStudentCourseService {
    private static final Logger log = LoggerFactory.getLogger(WxStudentCourseServiceImpl.class);
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgStudentApiService orgStudentApiService;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private WxBizScheduleService wxBizScheduleService;
    @Resource
    private OrgCourseExtraService orgCourseExtraService;
    @Resource
    private OrgSignupCourseLessonService orgSignupCourseLessonService;
    @Resource
    private WxCommonCounterService wxCommonCounterService;

    @Override
    public List<WxCourseStudentInfo> queryPageStudentsByCourseId(Long orgId, Long courseId, PageDto pageDto) {
        ArrayList<WxCourseStudentInfo> studentInfos = new ArrayList<WxCourseStudentInfo>();
        List list = this.orgStudentCourseDao.getStudentListByCourseId(orgId, courseId, pageDto);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            HashMap mapStudentCourse = Maps.newHashMap();
            for (OrgStudentCourse studentCourse : list) {
                mapStudentCourse.put(studentCourse.getUserId(), studentCourse);
            }
            List students = this.orgStudentDao.getWxListByParam(orgId, null, mapStudentCourse.keySet(), null, null, null, null, null);
            if (CollectionUtils.isNotEmpty((Collection)students)) {
                Map avatarMap = this.orgStudentApiService.batchGetStudentAvatarUrl((Collection)students);
                for (OrgStudent orgStudent : students) {
                    WxCourseStudentInfo dto = new WxCourseStudentInfo();
                    dto.setStudentId(orgStudent.getId());
                    dto.setUserId(orgStudent.getUserId());
                    dto.setName(orgStudent.getName());
                    dto.setMobile(orgStudent.getMobile());
                    dto.setCreateTime(orgStudent.getCreateTime());
                    dto.setCoverId(orgStudent.getAvatar());
                    dto.setCoverUrl((String)avatarMap.get(orgStudent.getId()));
                    OrgStudentCourse studentCourse = (OrgStudentCourse)mapStudentCourse.get(orgStudent.getUserId());
                    dto.setRecordId(studentCourse.getId());
                    dto.setCreateTime(studentCourse.getCreateTime());
                    studentInfos.add(dto);
                }
            }
        }
        return studentInfos;
    }

    @Override
    public List<WxCourseStudentInfo> queryPageStudentsByCourseIdAndMaxId(Long orgId, Long courseId, Integer pageSize, Long maxId) {
        ArrayList<WxCourseStudentInfo> studentInfos = new ArrayList<WxCourseStudentInfo>();
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("courseId", courseId);
        List list = this.orgStudentCourseDao.getPageByCourseIdAndMaxId(orgId, courseId, pageSize, maxId);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            HashMap mapStudentCourse = Maps.newHashMap();
            for (OrgStudentCourse studentCourse : list) {
                mapStudentCourse.put(studentCourse.getUserId(), studentCourse);
            }
            List students = this.orgStudentDao.getWxListByParam(orgId, null, mapStudentCourse.keySet(), null, null, null, null, null);
            if (CollectionUtils.isNotEmpty((Collection)students)) {
                Map avatarMap = this.orgStudentApiService.batchGetStudentAvatarUrl((Collection)students);
                for (OrgStudent orgStudent : students) {
                    WxCourseStudentInfo dto = new WxCourseStudentInfo();
                    dto.setStudentId(orgStudent.getId());
                    dto.setUserId(orgStudent.getUserId());
                    dto.setName(orgStudent.getName());
                    dto.setMobile(orgStudent.getMobile());
                    dto.setStudentCreateTime(orgStudent.getCreateTime());
                    dto.setCoverId(orgStudent.getAvatar());
                    dto.setCoverUrl((String)avatarMap.get(orgStudent.getId()));
                    OrgStudentCourse studentCourse = (OrgStudentCourse)mapStudentCourse.get(orgStudent.getUserId());
                    dto.setRecordId(studentCourse.getId());
                    dto.setCreateTime(studentCourse.getCreateTime());
                    studentInfos.add(dto);
                }
            }
        }
        return studentInfos;
    }

    @Override
    public void doStudentLessonAndSignByOrgStudentCourseId(Long orgStudentCourseId, boolean needSign) {
        OrgStudentCourse studentCourse = (OrgStudentCourse)this.orgStudentCourseDao.getById((Serializable)orgStudentCourseId, new String[0]);
        if (studentCourse == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u73ed\u7ea7\u5b66\u5458\u4e0d\u5b58\u5728");
        }
        if (studentCourse.getStatus() != 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u73ed\u7ea7\u5b66\u5458\u72b6\u6001\u9519\u8bef\uff0c\u5df2\u7ecf\u9000\u73ed");
        }
        if (studentCourse.getDelStatus() != 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u73ed\u7ea7\u5b66\u5458\u5df2\u7ecf\u5220\u9664");
        }
        Long orgId = studentCourse.getOrgId();
        Long courseId = studentCourse.getCourseId();
        Long studentUserId = studentCourse.getUserId();
        OrgStudent orgStudent = this.orgStudentDao.getStudent(orgId, studentUserId, Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[0]);
        if (orgStudent == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u73ed\u7ea7\u5b66\u5458\u5df2\u7ecf\u5220\u9664");
        }
        ArrayList courseIds = Lists.newArrayList();
        courseIds.add(courseId);
        List lessonList = this.orgClassLessonDao.getLessonByCourseIds((Collection)courseIds, Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[0]);
        ArrayList lessonIds = Lists.newArrayList();
        ArrayList saveStudentLessons = Lists.newArrayList();
        OrgStudentLesson po = null;
        for (OrgClassLesson lesson : lessonList) {
            lessonIds.add(lesson.getId());
            po = new OrgStudentLesson();
            po.setLessonId(lesson.getId());
            po.setOrgId(orgId);
            po.setUserId(studentUserId);
            po.setCourseId(courseId);
            po.setStartStatus(Integer.valueOf(1));
            Long mi = (lesson.getEndTime().getTime() - lesson.getStartTime().getTime()) / 60L / 1000L;
            po.setLessonDuration(Integer.valueOf(mi.intValue()));
            saveStudentLessons.add(po);
        }
        log.info("save students :{} to lessonids:{}", (Object)saveStudentLessons, (Object)lessonIds);
        if (CollectionUtils.isNotEmpty((Collection)saveStudentLessons)) {
            this.orgSignupCourseLessonService.saveSignupCourseLessons(orgId, courseId, (Collection)saveStudentLessons);
            this.orgStudentLessonDao.saveAll((List)saveStudentLessons, new String[0]);
        }
        if (!needSign) {
            return;
        }
        ArrayList newSignStudents = Lists.newArrayList();
        for (Long lessonId : lessonIds) {
            OrgLessonSign lessonSign = new OrgLessonSign();
            lessonSign.setCourseId(courseId);
            lessonSign.setCreateTime(new Date());
            lessonSign.setLessonId(lessonId);
            lessonSign.setOrgId(orgId);
            lessonSign.setStatus(Integer.valueOf(1));
            lessonSign.setUserId(studentUserId);
            lessonSign.setUpdateTime(new Date());
            lessonSign.setUserRole(Integer.valueOf(UserRole.STUDENT.getRole()));
            newSignStudents.add(lessonSign);
        }
        this.orgLessonSignDao.saveAll((List)newSignStudents, false, new String[]{"courseId", "createTime", "lessonId", "orgId", "status", "userId", "updateTime", "userRole"});
    }

    @Override
    public void doWxStudentLesson(OrgCourse orgCourse, OrgStudentCourse orgStudentCourse) {
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode()) {
            this.doStudentLessonAndSignByOrgStudentCourseId(orgStudentCourse.getId(), false);
        } else if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode()) {
            ArrayList courseIds = Lists.newArrayList();
            courseIds.add(orgCourse.getId());
            Map<Long, OrgCourseExtra> map = this.orgCourseExtraService.queryMapByCourseIds(courseIds);
            OrgCourseExtra orgCourseExtra = map.get(orgCourse.getId());
            Integer refundDays = null;
            if (orgCourseExtra == null || orgCourseExtra.getRefundDays() == null || orgCourseExtra.getRefundDays() <= 0) {
                log.error("OrgCourseExtra null course id={}", (Object)orgCourse.getId());
                refundDays = 0;
            } else {
                refundDays = orgCourseExtra.getRefundDays();
            }
            Date date = DateUtil.addDay((Date)new Date(), (int)refundDays);
            this.wxBizScheduleService.saveSchedule(BizScheduleType.course_delay_sign, orgStudentCourse.getId(), date);
        }
    }

    @Override
    public void taskProcess(OrgCourse orgCourse, OrgStudentCourse orgStudentCourse) {
        this.courseOrderCounter(orgCourse.getId());
        this.doWxStudentLesson(orgCourse, orgStudentCourse);
    }

    private void courseOrderCounter(Long courseId) {
        WxCommonCounterKey wxCommonCounterKey = new WxCommonCounterKey();
        wxCommonCounterKey.setMainKey(WxCommonCounterKey.MainKeyType.course_order_count.name());
        wxCommonCounterKey.setSecondaryKey(courseId + "");
        this.wxCommonCounterService.addOne(wxCommonCounterKey);
    }
}

