/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.constant.PublishStatus;
import com.baijia.tianxiao.constants.CategoryType;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.dao.WxCategoryDao;
import com.baijia.tianxiao.dal.org.dao.WxContactDao;
import com.baijia.tianxiao.dal.org.dao.WxNewsDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.WxCategory;
import com.baijia.tianxiao.dal.org.po.WxContactInfo;
import com.baijia.tianxiao.dal.org.po.WxNews;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.wx.api.WxNewsService;
import com.baijia.tianxiao.sal.wx.model.WxNewsBaseDto;
import com.baijia.tianxiao.sal.wx.model.WxNewsDto;
import com.baijia.tianxiao.sal.wx.model.WxNewsReqDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WxNewsServiceImpl
implements WxNewsService {
    private static Integer RICH_MAX_LENGTH = 30000;
    private static Integer CONTACT_MAX_LENGTH = 10000;
    private static String DEFAULT_NULL_TIME = "0000-00-00 00:00:00";
    @Autowired
    private WxNewsDao wxNewsDao;
    @Autowired
    private WxCategoryDao wxCategoryDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private WxContactDao wxContactDao;
    @Autowired
    private OrgStorageDao orgStorageDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(Long orgId, WxNewsDto param, Integer cascadeId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        Preconditions.checkArgument((param != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u9519\u8bef");
        if (param.getRichContent().length() > RICH_MAX_LENGTH) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u65b0\u95fb\u5185\u5bb9\u8fc7\u957f");
        }
        WxNews po = null;
        po = param.getId() != null && param.getId() > 0L ? this.wxNewsDao.getById(orgId, param.getId(), null, new String[0]) : new WxNews();
        param.toPo(po, cascadeId, orgId);
        this.wxNewsDao.saveOrUpdateWithDefaultVal((Object)po, new String[0]);
        return po.getId();
    }

    @Override
    public WxNewsDto getDetail(Long orgId, Long id) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        Preconditions.checkArgument((id != null && id > 0L ? 1 : 0) != 0);
        WxNews po = this.wxNewsDao.getById(orgId, id, null, new String[0]);
        if (po == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u65b0\u95fb\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        Map<Long, WxCategory> categoryMap = this.cacheNewsCategory(orgId);
        Map<Long, String> coverMap = new HashMap<Long, String>();
        if (po.getCoverId() != null && po.getCoverId() > 0L) {
            coverMap = this.cacheCoverUrl(Sets.newHashSet((Object[])new Long[]{po.getCoverId()}));
        }
        Map<Integer, String> operatorMap = this.cacheOperator(orgId, Sets.newHashSet((Object[])new Integer[]{po.getOperatorId()}));
        WxNewsDto dto = WxNewsDto.getFromPo(po, categoryMap, coverMap, operatorMap);
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(Long orgId, Long id) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        Preconditions.checkArgument((id != null && id > 0L ? 1 : 0) != 0);
        WxNews po = this.wxNewsDao.getById(orgId, id, null, new String[]{"id"});
        if (po == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u65b0\u95fb\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        po.setIsDel(Integer.valueOf(DeleteStatus.DELETED.getValue()));
        po.setUpdateTime(new Date());
        this.wxNewsDao.updateWithDefaultVal((Object)po, new String[]{"isDel", "updateTime"});
    }

    @Override
    public List<WxNewsBaseDto> getBaseList(Long orgId, WxNewsReqDto param, Boolean descByPublish, PageDto pageDto) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId\u9519\u8bef");
        ArrayList<WxNewsBaseDto> data = new ArrayList<WxNewsBaseDto>();
        List list = this.wxNewsDao.getListByParam(orgId, null, param.getCategoryId(), param.getKey(), param.getStatus(), param.getStart(), param.getEnd(), descByPublish, pageDto, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            HashSet<Long> coverIds = new HashSet<Long>();
            HashSet<Integer> operatorIds = new HashSet<Integer>();
            for (WxNews po : list) {
                if (po.getCoverId() != null && po.getCoverId() > 0L) {
                    coverIds.add(po.getCoverId());
                }
                if (po.getOperatorId() == null || po.getOperatorId() < 0) continue;
                operatorIds.add(po.getOperatorId());
            }
            Map<Long, WxCategory> categoryMap = this.cacheNewsCategory(orgId);
            Map<Long, String> coverMap = null;
            if (CollectionUtils.isNotEmpty(coverIds)) {
                coverMap = this.cacheCoverUrl(coverIds);
            }
            Map<Integer, String> operatorMap = null;
            if (CollectionUtils.isNotEmpty(operatorIds)) {
                operatorMap = this.cacheOperator(orgId, operatorIds);
            }
            for (WxNews po : list) {
                WxNewsDto dto = WxNewsDto.getFromPo(po, categoryMap, coverMap, operatorMap);
                data.add(dto);
            }
        }
        return data;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void switchStatus(Long orgId, Collection<Long> ids, Integer status) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"\u8bf7\u9009\u62e9\u65b0\u95fb");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)PublishStatus.getByCode((Integer)status)), (Object)"\u72b6\u6001\u9519\u8bef");
        List list = this.wxNewsDao.getListByParam(orgId, ids, null, null, null, null, null, null, null, new String[0]);
        if (CollectionUtils.isEmpty((Collection)list) || list.size() != ids.size()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u9519\u8bef");
        }
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("id", ids);
        condition.put("status", status);
        condition.put("updateTime", new Date());
        if (status.intValue() == PublishStatus.PUBLISH.getCode()) {
            condition.put("publishTime", new Date());
        } else {
            condition.put("publishTime", DEFAULT_NULL_TIME);
        }
        int succ = this.wxNewsDao.update(condition, new String[]{"status", "updateTime", "publishTime"});
        if (succ != ids.size()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u9519\u8bef");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveContact(Long orgId, String richContent, Long coverId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        WxContactInfo contactInfo = this.wxContactDao.getByOrgId(orgId);
        if (contactInfo == null) {
            contactInfo = new WxContactInfo();
            contactInfo.setOrgId(orgId);
            contactInfo.setCreateTime(new Date());
        }
        if (coverId == null && richContent == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        if (coverId == null) {
            if (richContent.length() > CONTACT_MAX_LENGTH) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5185\u5bb9\u8f93\u5165\u8fc7\u957f");
            }
            contactInfo.setRichContent(richContent);
        } else if (richContent == null) {
            contactInfo.setCoverId(coverId);
        }
        contactInfo.setUpdateTime(new Date());
        this.wxContactDao.saveOrUpdateWithDefaultVal((Object)contactInfo, new String[0]);
        return contactInfo.getId();
    }

    @Override
    public Map<String, Object> getContact(Long orgId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        WxContactInfo contactInfo = this.wxContactDao.getByOrgId(orgId);
        HashMap<String, Object> data = new HashMap<String, Object>();
        Long coverId = 0L;
        String coverUrl = "https://img.gsxservice.com/0baijiatools/9aaf533511ef579a32b386fae4e7ba9a/Mask1.png";
        String info = "";
        if (contactInfo != null) {
            if (contactInfo.getCoverId() != null && contactInfo.getCoverId() > 0L) {
                coverId = contactInfo.getCoverId();
                Map<Long, String> map = this.cacheCoverUrl(Sets.newHashSet((Object[])new Long[]{contactInfo.getCoverId()}));
                if (map != null && map.containsKey(contactInfo.getCoverId())) {
                    coverUrl = map.get(contactInfo.getCoverId());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)contactInfo.getRichContent())) {
                info = contactInfo.getRichContent();
            }
        }
        data.put("coverId", coverId);
        data.put("coverUrl", coverUrl);
        data.put("info", info);
        return data;
    }

    private Map<Long, WxCategory> cacheNewsCategory(Long orgId) {
        Map<Long, Object> cache = new HashMap<Long, WxCategory>();
        List categoryList = this.wxCategoryDao.getListByParam(orgId, Integer.valueOf(CategoryType.NEWS.getCode()), null);
        if (CollectionUtils.isNotEmpty((Collection)categoryList)) {
            cache = BaseUtils.listToMap((List)categoryList, (String)"id");
        }
        return cache;
    }

    private Map<Long, String> cacheCoverUrl(Collection<Long> ids) {
        Map storageMap;
        HashMap<Long, String> cache = new HashMap<Long, String>();
        if (CollectionUtils.isNotEmpty(ids) && (storageMap = this.orgStorageDao.getOrgStorageMapByIds(ids)) != null && storageMap.size() > 0) {
            for (Long id : ids) {
                if (storageMap.containsKey(id)) {
                    OrgStorage storage = (OrgStorage)storageMap.get(id);
                    cache.put(id, StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType()));
                    continue;
                }
                cache.put(id, "https://img.gsxservice.com/0baijiatools/4d7b6a21d35acc6f57f273e0f9db62b4/news.png");
            }
        }
        return cache;
    }

    private Map<Integer, String> cacheOperator(Long orgId, Collection<Integer> ids) {
        Map map;
        HashMap<Integer, String> cache = new HashMap<Integer, String>();
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[]{"id", "contacts"});
        if (orgInfo == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        cache.put(0, orgInfo.getContacts());
        if (CollectionUtils.isNotEmpty(ids) && (map = this.txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds(ids)) != null && map.size() > 0) {
            for (Long id : map.keySet()) {
                cache.put(id.intValue(), (String)map.get(id));
            }
        }
        return cache;
    }

    @Override
    public List<WxNewsBaseDto> getBaseListByIds(Long orgId, Collection<Long> newsIds) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("id", newsIds);
        condition.put("status", 1);
        condition.put("isDel", 0);
        List list = this.wxNewsDao.queryByCondition((Map)condition, null, new String[0]);
        ArrayList data = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            HashSet<Long> coverIds = new HashSet<Long>();
            HashSet<Integer> operatorIds = new HashSet<Integer>();
            for (WxNews po : list) {
                if (po.getCoverId() != null && po.getCoverId() > 0L) {
                    coverIds.add(po.getCoverId());
                }
                if (po.getOperatorId() == null || po.getOperatorId() < 0) continue;
                operatorIds.add(po.getOperatorId());
            }
            Map<Long, WxCategory> categoryMap = this.cacheNewsCategory(orgId);
            Map<Long, String> coverMap = null;
            if (CollectionUtils.isNotEmpty(coverIds)) {
                coverMap = this.cacheCoverUrl(coverIds);
            }
            Map<Integer, String> operatorMap = null;
            if (CollectionUtils.isNotEmpty(operatorIds)) {
                operatorMap = this.cacheOperator(orgId, operatorIds);
            }
            for (WxNews po : list) {
                WxNewsDto dto = WxNewsDto.getFromPo(po, categoryMap, coverMap, operatorMap);
                data.add(dto);
            }
        }
        return data;
    }

    @Override
    public Map<Long, WxNewsBaseDto> getBaseMapByIds(Long orgId, Collection<Long> newsIds) {
        List<WxNewsBaseDto> list = this.getBaseListByIds(orgId, newsIds);
        HashMap map = Maps.newHashMap();
        for (WxNewsBaseDto dto : list) {
            map.put(dto.getId(), dto);
        }
        return map;
    }

    @Override
    public List<WxNewsBaseDto> getBaseListOrderByIds(Long orgId, Collection<Long> newsIds) {
        Map<Long, WxNewsBaseDto> maps = this.getBaseMapByIds(orgId, newsIds);
        ArrayList list = Lists.newArrayList();
        for (Long newsId : newsIds) {
            WxNewsBaseDto dto = maps.get(newsId);
            if (dto == null) continue;
            list.add(dto);
        }
        return list;
    }
}

