/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.WxLiveRoomDao;
import com.baijia.tianxiao.dal.org.dto.WxLiveRoomQueryDto;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.WxLiveRoom;
import com.baijia.tianxiao.dal.org.po.WxLiveRoomRecord;
import com.baijia.tianxiao.sal.cloud.api.LiveRoomApi;
import com.baijia.tianxiao.sal.course.dto.OrgCourseQueryResponseDto;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.teacher.api.OrgTeacherService;
import com.baijia.tianxiao.sal.teacher.api.TeacherService;
import com.baijia.tianxiao.sal.teacher.dto.OrgTeacherResponseDto;
import com.baijia.tianxiao.sal.wx.api.WxCourseService;
import com.baijia.tianxiao.sal.wx.api.WxLiveRoomRecordService;
import com.baijia.tianxiao.sal.wx.api.WxLiveRoomService;
import com.baijia.tianxiao.sal.wx.api.WxRoomUserCountService;
import com.baijia.tianxiao.sal.wx.model.WxLiveLessonView;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="wxLiveRoomService")
public class WxLiveRoomServiceImpl
implements WxLiveRoomService {
    @Resource
    private WxLiveRoomDao wxLiveRoomDao;
    @Resource
    private WxCourseService wxCourseService;
    @Resource
    private LiveRoomApi liveRoomApi;
    @Resource
    private WxLiveRoomRecordService wxLiveRoomRecordService;
    @Resource
    private WxRoomUserCountService wxRoomUserCountService;
    @Resource
    private OrgStudentCourseService orgStudentCourseService;
    @Resource
    private OrgTeacherService orgTeacherService;
    @Resource
    private TeacherService teacherService;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;

    @Override
    public Long getLessonRoomId(Long orgId, Long lessonId) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonId);
        List list = this.wxLiveRoomDao.queryByCondition((Map)condition, null, new String[0]);
        if (list.size() == 0) {
            return null;
        }
        return ((WxLiveRoom)list.get(0)).getRoomId();
    }

    @Override
    public WxLiveRoom getByRoomId(Long roomId) {
        return this.wxLiveRoomDao.getByRoomId(roomId);
    }

    @Override
    public WxLiveRoom getLessonRoom(Long orgId, Long lessonId) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonId);
        List list = this.wxLiveRoomDao.queryByCondition((Map)condition, null, new String[0]);
        if (list.size() == 0) {
            return null;
        }
        return (WxLiveRoom)list.get(0);
    }

    @Override
    public Map<Long, WxLiveRoom> queryMapByOrgLessonIds(Long orgId, Collection<Long> lessonIds) {
        List<WxLiveRoom> list = this.queryListByOrgLessonIds(orgId, lessonIds);
        HashMap map = Maps.newHashMap();
        for (WxLiveRoom room : list) {
            map.put(room.getLessonId(), room);
        }
        return map;
    }

    @Override
    public List<WxLiveRoom> queryListByOrgLessonIds(Long orgId, Collection<Long> lessonIds) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonIds);
        List list = this.wxLiveRoomDao.queryByCondition((Map)condition, null, new String[0]);
        return list;
    }

    @Override
    public void save(WxLiveRoom wxLiveRoom) {
        this.wxLiveRoomDao.save((Object)wxLiveRoom, new String[0]);
    }

    @Override
    public void update(WxLiveRoom wxLiveRoom) {
        this.wxLiveRoomDao.update((Object)wxLiveRoom, new String[0]);
    }

    @Override
    public void delete(Long orgId, Long lessonId) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonId);
        this.wxLiveRoomDao.delByCondition((Map)condition);
    }

    @Override
    public List<WxLiveRoom> queryByConditon(WxLiveRoomQueryDto dto, PageDto pageDto) {
        List list = this.wxLiveRoomDao.queryByConditon(dto, pageDto);
        return list;
    }

    @Override
    public List<WxLiveLessonView> buildLessonLiveView(Long orgId, List<WxLiveRoom> list) {
        ArrayList viewList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return viewList;
        }
        HashSet courseIds = Sets.newHashSet();
        HashSet userIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        for (WxLiveRoom room : list) {
            courseIds.add(room.getCourseId());
            lessonIds.add(room.getLessonId());
            if (room.getAdminId() != null && room.getAdminId() > 0L) {
                userIds.add(room.getAdminId());
            }
            if (room.getTeacherId() == null || room.getTeacherId() <= 0L) continue;
            userIds.add(room.getTeacherId());
        }
        List lessonList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)lessonIds)) {
            HashMap condition = Maps.newHashMap();
            condition.put("orgId", orgId);
            condition.put("id", lessonIds);
            condition.put("dalStatus", 0);
            lessonList = this.orgClassLessonDao.queryByCondition((Map)condition, null, new String[0]);
        }
        HashMap lessonMap = Maps.newHashMap();
        for (OrgClassLesson lesson : lessonList) {
            lessonMap.put(lesson.getId(), lesson);
        }
        Map teacherMaps = this.teacherService.getOrgTeacherMap(orgId, (Collection)userIds);
        List<OrgCourseQueryResponseDto> courseList = this.wxCourseService.buildOrgCourseByCourseIds(orgId, Lists.newArrayList((Iterable)courseIds));
        HashMap courseMap = Maps.newHashMap();
        for (OrgCourseQueryResponseDto dto : courseList) {
            courseMap.put(dto.getOrgCourseId(), dto);
        }
        ArrayListMultimap courseStudentIdMap = this.orgStudentCourseService.getClassStudentIdMap(orgId, (List)Lists.newArrayList(courseMap.keySet()));
        Date now = new Date();
        for (WxLiveRoom room : list) {
            Long courseId = room.getCourseId();
            OrgCourseQueryResponseDto orgCourse = (OrgCourseQueryResponseDto)courseMap.get(courseId);
            Long lessonId = room.getLessonId();
            OrgClassLesson lesson = (OrgClassLesson)lessonMap.get(lessonId);
            if (lesson == null || orgCourse == null) {
                this.delete(orgId, lessonId);
                continue;
            }
            WxLiveLessonView view = this.buildWxLiveLessonView(room, lesson, orgCourse, teacherMaps, (ArrayListMultimap<Long, Long>)courseStudentIdMap);
            boolean result = view.getStartTime().before(now);
            if (!result) {
                view.setRoomStatus(1);
            } else if (view.getEndTime().before(now)) {
                view.setRoomStatus(3);
            } else {
                view.setRoomStatus(2);
            }
            viewList.add(view);
        }
        return viewList;
    }

    private WxLiveLessonView buildWxLiveLessonView(WxLiveRoom liveRoom, OrgClassLesson lesson, OrgCourseQueryResponseDto course, Map<Long, OrgTeacherResponseDto> teacherMaps, ArrayListMultimap<Long, Long> courseStudentIdMap) {
        List studengIds;
        Integer effectDays;
        WxLiveLessonView view = new WxLiveLessonView();
        view.setCourseId(liveRoom.getCourseId());
        view.setLessonId(liveRoom.getLessonId());
        view.setName(liveRoom.getTitle());
        view.setOrgId(liveRoom.getOrgId());
        view.setRoomId(liveRoom.getRoomId());
        view.setStartTime(liveRoom.getStartTime());
        view.setEndTime(liveRoom.getEndTime());
        view.setPlayBack(liveRoom.getPlayBack());
        view.setBackLength(liveRoom.getBackLength());
        view.setBackSize(liveRoom.getBackSize());
        view.setBackCreateTime(liveRoom.getBackTime());
        if (view.getBackCreateTime() != null && (effectDays = course.getEffectDays()) != null) {
            view.setBackEndTime(DateUtil.addDay((Date)view.getBackCreateTime(), (int)effectDays));
        }
        view.setCourseName(course.getCourseName());
        view.setCoverUrl(course.getCoverUrl());
        view.setTeacherCode(liveRoom.getTeacherCode());
        view.setAdminCode(liveRoom.getAdminCode());
        view.setTeacherId(liveRoom.getTeacherId());
        OrgTeacherResponseDto teacher = teacherMaps.get(liveRoom.getTeacherId());
        view.setTeacher(teacher);
        if (teacher != null) {
            view.setTeacherName(teacher.getTeacherName());
        }
        view.setAdminId(liveRoom.getAdminId());
        OrgTeacherResponseDto admin = teacherMaps.get(liveRoom.getAdminId());
        view.setAdmin(admin);
        if (admin != null) {
            view.setAdminName(admin.getTeacherName());
        }
        if (CollectionUtils.isEmpty((Collection)(studengIds = courseStudentIdMap.get((Object)liveRoom.getCourseId())))) {
            view.setStudentCount(0);
        } else {
            view.setStudentCount(studengIds.size());
        }
        return view;
    }

    @Override
    public void updateByLessonId(WxLiveRoom wxLiveRoom) {
        Long orgId = wxLiveRoom.getOrgId();
        Long lessonId = wxLiveRoom.getLessonId();
        ArrayList lessonIds = Lists.newArrayList();
        lessonIds.add(lessonId);
        Map<Long, WxLiveRoom> map = this.queryMapByOrgLessonIds(orgId, lessonIds);
        WxLiveRoom oldRoom = map.get(lessonId);
        wxLiveRoom.setId(oldRoom.getId());
        this.wxLiveRoomDao.update((Object)wxLiveRoom, new String[0]);
    }

    @Override
    public List<WxLiveRoom> queryActiveLiveRoomList() {
        return this.wxLiveRoomDao.queryActiveLiveRoomList();
    }

    @Override
    public void refreshRoomUser() {
        List<WxLiveRoom> activeList = this.queryActiveLiveRoomList();
        HashMap roomIdOrgMaps = Maps.newHashMap();
        for (WxLiveRoom room : activeList) {
            roomIdOrgMaps.put(room.getRoomId(), room.getOrgId());
        }
        if (roomIdOrgMaps.size() == 0) {
            return;
        }
        Map<String, Integer> result = this.liveRoomApi.getRoomsUserCount(roomIdOrgMaps.keySet());
        Date now = new Date();
        ArrayList recordList = Lists.newArrayList();
        for (Map.Entry roomIdOrgEntry : roomIdOrgMaps.entrySet()) {
            Long roomId = (Long)roomIdOrgEntry.getKey();
            Long orgId = (Long)roomIdOrgEntry.getValue();
            String roomIdStr = String.valueOf(roomId);
            Integer count = result.get(roomIdStr);
            if (count == null) continue;
            WxLiveRoomRecord record = new WxLiveRoomRecord();
            record.setOrgId(orgId);
            record.setRoomId(roomId);
            record.setNum(count);
            record.setQueryTime(now);
            recordList.add(record);
        }
        for (WxLiveRoomRecord record : recordList) {
            this.wxRoomUserCountService.updateCurrentUserCount(record.getOrgId(), record.getRoomId(), record.getNum().longValue());
        }
        this.wxLiveRoomRecordService.batchSaveAyn(recordList);
    }

    @Override
    public void updatePlaybackStatus(WxLiveRoom wxLiveRoom) {
        HashMap condition = Maps.newHashMap();
        condition.put("roomId", wxLiveRoom.getRoomId());
        condition.put("playBack", wxLiveRoom.getPlayBack());
        condition.put("backLength", wxLiveRoom.getBackLength());
        condition.put("backSize", wxLiveRoom.getBackSize());
        condition.put("backTime", wxLiveRoom.getBackTime());
        this.wxLiveRoomDao.update((Map)condition, new String[]{"playBack", "backLength", "backSize", "backTime"});
    }
}

