/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.WxLiveRoomRecordDao;
import com.baijia.tianxiao.dal.org.po.WxLiveRoomRecord;
import com.baijia.tianxiao.sal.wx.api.WxLiveRoomRecordService;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="wxLiveRoomRecordService")
public class WxLiveRoomRecordServiceImpl
implements WxLiveRoomRecordService {
    @Resource
    private WxLiveRoomRecordDao wxLiveRoomRecordDao;

    @Override
    public void batchSave(List<WxLiveRoomRecord> list) {
        this.wxLiveRoomRecordDao.saveAll(list, false, new String[0]);
    }

    @Override
    @Async
    public void batchSaveAyn(List<WxLiveRoomRecord> list) {
        this.batchSave(list);
    }

    @Override
    public void calculateDailyRecord(Date date) {
        Date startTime = DateUtil.getStartOfDay((Date)date);
        Date endTime = DateUtil.getEndOfDay((Date)date);
        this.wxLiveRoomRecordDao.delOrgMaxRecordByTime(startTime, endTime);
        List list = this.wxLiveRoomRecordDao.querySumGroupByOrg(startTime, endTime);
        HashMap maxNumRecordMap = Maps.newHashMap();
        for (WxLiveRoomRecord record : list) {
            WxLiveRoomRecord tempRecord = (WxLiveRoomRecord)maxNumRecordMap.get(record.getOrgId());
            if (tempRecord == null) {
                maxNumRecordMap.put(record.getOrgId(), record);
                continue;
            }
            if (tempRecord.getNum() <= tempRecord.getNum()) continue;
            maxNumRecordMap.put(record.getOrgId(), record);
        }
        for (WxLiveRoomRecord record : maxNumRecordMap.values()) {
            record.setId(null);
            record.setRoomId(Long.valueOf(0L));
            record.setCreateTime(null);
            this.wxLiveRoomRecordDao.save((Object)record, new String[0]);
        }
    }

    @Override
    public List<WxLiveRoomRecord> queryByOrgAndDateRange(Long orgId, Date startDate, Date endDate) {
        return this.wxLiveRoomRecordDao.queryDailyOrgNum(orgId, DateUtil.getStartOfDay((Date)startDate), DateUtil.getEndOfDay((Date)endDate));
    }

    @Override
    public WxLiveRoomRecord getOrgTodayMaxNumRecord(Long orgId) {
        return this.wxLiveRoomRecordDao.getOrgTodayMaxNumRecord(orgId);
    }

    @Override
    public Integer getOrgTodayMaxNum(Long orgId) {
        WxLiveRoomRecord record = this.wxLiveRoomRecordDao.getOrgTodayMaxNumRecord(orgId);
        if (record == null) {
            return 0;
        }
        return record.getNum();
    }

    @Override
    public Integer getOrgMonthMaxNum(Long orgId) {
        WxLiveRoomRecord record = this.wxLiveRoomRecordDao.getOrgMonthMaxNumRecord(orgId);
        if (record == null) {
            return 0;
        }
        return record.getNum();
    }
}

