/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.WxLiveRoom;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.cloud.api.LiveRoomApi;
import com.baijia.tianxiao.sal.cloud.model.request.LiveRoomCreate;
import com.baijia.tianxiao.sal.cloud.model.request.LiveRoomDelete;
import com.baijia.tianxiao.sal.cloud.model.request.LiveRoomUpdate;
import com.baijia.tianxiao.sal.cloud.model.response.DefaultApiResult;
import com.baijia.tianxiao.sal.wx.api.WxLiveRoomLessonService;
import com.baijia.tianxiao.sal.wx.api.WxLiveRoomService;
import com.baijia.tianxiao.sal.wx.model.WxCourseLessonDto;
import com.baijia.tianxiao.util.date.DateUtil;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="wxLiveRoomLessonService")
public class WxLiveRoomLessonServiceImpl
implements WxLiveRoomLessonService {
    private static final Logger log = LoggerFactory.getLogger(WxLiveRoomLessonServiceImpl.class);
    @Resource
    private LiveRoomApi liveRoomApi;
    @Resource
    private WxLiveRoomService wxLiveRoomService;

    @Override
    public DefaultApiResult create(OrgClassLesson lesson, Integer maxStudent, WxCourseLessonDto courseLessonDto) {
        DefaultApiResult result;
        LiveRoomCreate liveRoom = new LiveRoomCreate();
        liveRoom.setTitle(lesson.getName());
        liveRoom.setMax_users(maxStudent);
        liveRoom.setStart_time(DateUtil.date2UnixTimestamp((Date)lesson.getStartTime()));
        liveRoom.setEnd_time(DateUtil.date2UnixTimestamp((Date)lesson.getEndTime()));
        try {
            result = this.liveRoomApi.create(liveRoom);
        }
        catch (Exception e) {
            log.error("liveRoomApi.create exception:{}", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u76f4\u64ad\u95f4api\u8c03\u7528\u5f02\u5e38");
        }
        if (result == null) {
            log.error("liveRoomApi.create fail orgId={},lessonId={},code={},msg={}", new Object[]{lesson.getOrgId(), lesson.getId(), result.getCode(), result.getMsg()});
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u76f4\u64ad\u95f4api\u8c03\u7528\u5f02\u5e38");
        }
        if (result.getCode() != 0) {
            log.error("liveRoomApi.create fail orgId={},lessonId={},code={},msg={}", new Object[]{lesson.getOrgId(), lesson.getId(), result.getCode(), result.getMsg()});
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, result.getMsg());
        }
        lesson.setRoomId(Long.valueOf(result.getData().get("room_id").toString()));
        WxLiveRoom wxLiveRoom = this.lesson2LiveRoomCreate(lesson, liveRoom, result, courseLessonDto);
        this.wxLiveRoomService.save(wxLiveRoom);
        return result;
    }

    private WxLiveRoom lesson2LiveRoomCreate(OrgClassLesson lesson, LiveRoomCreate liveRoom, DefaultApiResult result, WxCourseLessonDto courseLessonDto) {
        WxLiveRoom wxLiveRoom = new WxLiveRoom();
        wxLiveRoom.setOrgId(lesson.getOrgId());
        wxLiveRoom.setLessonId(lesson.getId());
        wxLiveRoom.setCourseId(lesson.getCourseId());
        wxLiveRoom.setRoomId(lesson.getRoomId());
        wxLiveRoom.setTitle(lesson.getName());
        wxLiveRoom.setType(Integer.valueOf(2));
        wxLiveRoom.setStatus(Integer.valueOf(0));
        wxLiveRoom.setDelStatus(Integer.valueOf(0));
        wxLiveRoom.setStartTime(lesson.getStartTime());
        wxLiveRoom.setEndTime(lesson.getEndTime());
        wxLiveRoom.setEnterTime(new Date(lesson.getStartTime().getTime() - (long)liveRoom.getPre_enter_time().intValue() * 1000L));
        wxLiveRoom.setAdminCode(result.getData().get("admin_code").toString());
        wxLiveRoom.setTeacherCode(result.getData().get("teacher_code").toString());
        wxLiveRoom.setTeacherId(courseLessonDto.getTeacherId());
        wxLiveRoom.setAdminId(courseLessonDto.getAdminId());
        return wxLiveRoom;
    }

    private WxLiveRoom lesson2LiveRoomUpdate(OrgClassLesson lesson, LiveRoomCreate liveRoom, DefaultApiResult result, WxCourseLessonDto courseLessonDto) {
        WxLiveRoom wxLiveRoom = new WxLiveRoom();
        wxLiveRoom.setOrgId(lesson.getOrgId());
        wxLiveRoom.setLessonId(lesson.getId());
        wxLiveRoom.setCourseId(lesson.getCourseId());
        wxLiveRoom.setRoomId(lesson.getRoomId());
        wxLiveRoom.setTitle(lesson.getName());
        wxLiveRoom.setType(Integer.valueOf(2));
        wxLiveRoom.setStartTime(lesson.getStartTime());
        wxLiveRoom.setEndTime(lesson.getEndTime());
        wxLiveRoom.setEnterTime(new Date(lesson.getStartTime().getTime() - (long)liveRoom.getPre_enter_time().intValue() * 1000L));
        wxLiveRoom.setTeacherId(courseLessonDto.getTeacherId());
        wxLiveRoom.setAdminId(courseLessonDto.getAdminId());
        return wxLiveRoom;
    }

    @Override
    public DefaultApiResult update(OrgClassLesson lesson, Integer maxStudent, WxCourseLessonDto courseLessonDto) {
        DefaultApiResult result;
        LiveRoomUpdate liveRoom = new LiveRoomUpdate();
        liveRoom.setRoom_id(lesson.getRoomId().toString());
        liveRoom.setTitle(lesson.getName());
        liveRoom.setMax_users(maxStudent);
        liveRoom.setStart_time(DateUtil.date2UnixTimestamp((Date)lesson.getStartTime()));
        liveRoom.setEnd_time(DateUtil.date2UnixTimestamp((Date)lesson.getEndTime()));
        try {
            result = this.liveRoomApi.update(liveRoom);
        }
        catch (Exception e) {
            log.error("liveRoomApi.create exception:{}", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u76f4\u64ad\u95f4api\u8c03\u7528\u5f02\u5e38");
        }
        if (result == null) {
            log.error("liveRoomApi.create fail orgId={},lessonId={},code={},msg={}", new Object[]{lesson.getOrgId(), lesson.getId(), result.getCode(), result.getMsg()});
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u76f4\u64ad\u95f4api\u8c03\u7528\u5f02\u5e38");
        }
        if (result.getCode() != 0) {
            log.error("liveRoomApi.create fail orgId={},lessonId={},code={},msg={}", new Object[]{lesson.getOrgId(), lesson.getId(), result.getCode(), result.getMsg()});
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, result.getMsg());
        }
        WxLiveRoom wxLiveRoom = this.lesson2LiveRoomUpdate(lesson, liveRoom, result, courseLessonDto);
        this.wxLiveRoomService.updateByLessonId(wxLiveRoom);
        return result;
    }

    @Override
    public DefaultApiResult delete(OrgClassLesson lesson) {
        DefaultApiResult result;
        LiveRoomDelete liveRoom = new LiveRoomDelete();
        liveRoom.setRoom_id(lesson.getRoomId().toString());
        try {
            result = this.liveRoomApi.delete(liveRoom);
        }
        catch (Exception e) {
            log.error("liveRoomApi.create exception:{}", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u76f4\u64ad\u95f4api\u8c03\u7528\u5f02\u5e38");
        }
        if (result == null) {
            log.error("liveRoomApi.create fail orgId={},lessonId={},code={},msg={}", new Object[]{lesson.getOrgId(), lesson.getId(), result.getCode(), result.getMsg()});
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u76f4\u64ad\u95f4api\u8c03\u7528\u5f02\u5e38");
        }
        if (result.getCode() != 0) {
            log.error("liveRoomApi.create fail orgId={},lessonId={},code={},msg={}", new Object[]{lesson.getOrgId(), lesson.getId(), result.getCode(), result.getMsg()});
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, result.getMsg());
        }
        this.wxLiveRoomService.delete(lesson.getOrgId(), lesson.getId());
        return result;
    }

    @Override
    @Async
    public void asynCreate(OrgClassLesson lesson, Integer maxStudent, WxCourseLessonDto courseLessonDto) {
        this.asynCreate(lesson, maxStudent, courseLessonDto);
    }

    @Override
    @Async
    public void asynUpdate(OrgClassLesson lesson, Integer maxStudent, WxCourseLessonDto courseLessonDto) {
        this.update(lesson, maxStudent, courseLessonDto);
    }

    @Override
    @Async
    public void asynDelete(OrgClassLesson lesson) {
        this.delete(lesson);
    }
}

