/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgLessonConflict;
import com.baijia.tianxiao.dal.org.po.WxCloudSource;
import com.baijia.tianxiao.dal.org.po.WxLiveRoom;
import com.baijia.tianxiao.dal.org.po.WxVideoLesson;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.comment.constant.CommentErrorCode;
import com.baijia.tianxiao.sal.course.constant.ArrangeStatus;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgLessonConflictService;
import com.baijia.tianxiao.sal.wx.api.WxCloudSourceService;
import com.baijia.tianxiao.sal.wx.api.WxLessonService;
import com.baijia.tianxiao.sal.wx.api.WxLiveRoomLessonService;
import com.baijia.tianxiao.sal.wx.api.WxLiveRoomService;
import com.baijia.tianxiao.sal.wx.api.WxVideoLessonService;
import com.baijia.tianxiao.sal.wx.enums.RoomStatus;
import com.baijia.tianxiao.sal.wx.model.WxCourseLessonDto;
import com.baijia.tianxiao.sal.wx.model.WxLiveLessonView;
import com.baijia.tianxiao.sal.wx.model.WxVideoLessonView;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="wxLessonService")
public class WxLessonServiceImpl
implements WxLessonService {
    private static final Logger log = LoggerFactory.getLogger(WxLessonServiceImpl.class);
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private WxLiveRoomLessonService wxLiveRoomLessonService;
    @Resource
    private WxVideoLessonService wxVideoLessonService;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Resource
    private OrgLessonConflictService orgLessonConflictService;
    @Resource
    private OrgLessonCommentDao orgLessonCommentDao;
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private CourseStudentService courseStudentService;
    @Resource
    private WxLiveRoomService wxLiveRoomService;
    @Resource
    private WxCloudSourceService wxCloudSourceService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addLiveClassLesson(Long orgId, WxCourseLessonDto dto) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((dto != null ? 1 : 0) != 0, (Object)"class lessons param is illegal");
        Preconditions.checkArgument((dto.getCourseId() != null && dto.getCourseId() > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        Preconditions.checkArgument((dto.getTeacherId() != null && dto.getTeacherId() > 0L ? 1 : 0) != 0, (Object)"teacherId is illegal");
        Preconditions.checkArgument((dto.getLessonName() != null && dto.getLessonName().length() < 21 ? 1 : 0) != 0, (Object)"the lesson name is null or too long");
        Preconditions.checkArgument((dto.getStartTime() != null && dto.getEndTime() != null ? 1 : 0) != 0, (Object)"time is null");
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(dto.getCourseId(), new String[0]);
        if (orgCourse == null || orgCourse.getCourseType() != CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u8282\u7c7b\u578b\u53c2\u6570\u9519\u8bef");
        }
        if (orgCourse.getFreq() == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0b\u672a\u8bbe\u8bfe\u8282\u6570");
        }
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("courseId", orgCourse.getId());
        List allLessons = this.orgClassLessonDao.queryByCondition((Map)condition, null, new String[0]);
        if (allLessons.size() >= orgCourse.getFreq()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6392\u8bfe\u8bfe\u8282\u8d85\u8fc7\u8bfe\u7a0b\u8bbe\u7f6e");
        }
        OrgClassLesson lesson = new OrgClassLesson();
        lesson.setStartTime(dto.getStartTime());
        lesson.setEndTime(dto.getEndTime());
        lesson.setCourseId(dto.getCourseId());
        lesson.setCreateTime(new Date());
        lesson.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        lesson.setLayoutId(Long.valueOf(0L));
        lesson.setRoomId(Long.valueOf(0L));
        lesson.setUpdateTime(new Date());
        lesson.setNumber(Integer.valueOf(0));
        lesson.setName(dto.getLessonName());
        lesson.setOrgId(orgId);
        this.orgClassLessonDao.save((Object)lesson, new String[]{"startTime", "endTime", "courseId", "createTime", "delStatus", "layoutId", "roomId", "updateTime", "orgId", "name"});
        HashSet teacherIds = Sets.newHashSet();
        HashSet tempTeacherIds = Sets.newHashSet();
        if (dto.getTeacherId() != null && dto.getTeacherId() > 0L) {
            teacherIds.add(dto.getTeacherId());
            tempTeacherIds.addAll(teacherIds);
            this.courseTeacherService.addTeacherToCourse(orgId, lesson.getCourseId(), (Collection)teacherIds);
            this.courseTeacherService.addTeacherToLesson(orgId, lesson.getCourseId(), lesson.getId(), (Collection)tempTeacherIds);
        }
        if (orgCourse.getArrangeLesson().intValue() == ArrangeStatus.UNARRANGE.getCode()) {
            orgCourse.setArrangeLesson(Integer.valueOf(ArrangeStatus.ARRANGEED.getCode()));
            this.orgCourseDao.update((Object)orgCourse, new String[]{"arrangeLesson"});
        }
        this.wxLiveRoomLessonService.create(lesson, orgCourse.getMaxStudent(), dto);
        this.orgClassLessonDao.update((Object)lesson, new String[]{"roomId"});
        OrgLessonConflict conflict = new OrgLessonConflict();
        conflict.setOrgId(orgId);
        conflict.setTeacherId(dto.getTeacherId());
        conflict.setRoomId(lesson.getRoomId());
        conflict.setLessonId(lesson.getId());
        conflict.setStartTime(lesson.getStartTime());
        conflict.setEndTime(lesson.getEndTime());
        conflict.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        this.orgLessonConflictService.updateOrgLessonConflictsForce(conflict);
        this.resetLessonNumber(orgId, lesson.getCourseId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editLiveClassLesson(Long orgId, WxCourseLessonDto dto) {
        Preconditions.checkArgument((dto.getLessonId() != null && dto.getLessonId() > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        Preconditions.checkArgument((dto.getTeacherId() != null && dto.getTeacherId() > 0L ? 1 : 0) != 0, (Object)"teacherId is illegal");
        Preconditions.checkArgument((dto.getLessonName() != null && dto.getLessonName().length() < 21 ? 1 : 0) != 0, (Object)"the lesson name is null or too long");
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)dto.getLessonId(), new String[0]);
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(lesson.getCourseId(), new String[0]);
        if (orgCourse == null || orgCourse.getCourseType() != CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u8282\u7c7b\u578b\u53c2\u6570\u9519\u8bef");
        }
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", (Object)dto.getLessonId(), (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        }
        lesson.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        boolean needRearrange = false;
        if (!dto.getEndTime().equals(lesson.getEndTime()) || !dto.getStartTime().equals(lesson.getStartTime())) {
            lesson.setEndTime(dto.getEndTime());
            lesson.setStartTime(dto.getStartTime());
            needRearrange = true;
        }
        ArrayList teacherIds = Lists.newArrayList();
        if (dto.getTeacherId() == null) {
            dto.setTeacherId(0L);
        } else {
            teacherIds.add(dto.getTeacherId());
        }
        lesson.setUpdateTime(new Date());
        lesson.setName(dto.getLessonName());
        this.orgClassLessonDao.update((Object)lesson, new String[0]);
        if (needRearrange) {
            this.resetLessonNumber(orgId, lesson.getCourseId());
        }
        this.courseTeacherService.resetLessonTeacher(orgId, lesson.getCourseId(), lesson.getId(), (Collection)teacherIds);
        OrgLessonConflict conflict = new OrgLessonConflict();
        conflict.setOrgId(orgId);
        conflict.setTeacherId(dto.getTeacherId());
        conflict.setRoomId(lesson.getRoomId());
        conflict.setLessonId(dto.getLessonId());
        conflict.setStartTime(lesson.getStartTime());
        conflict.setEndTime(lesson.getEndTime());
        conflict.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        this.orgLessonConflictService.updateOrgLessonConflictsForce(conflict);
        WxLiveRoom room = this.wxLiveRoomService.getLessonRoom(lesson.getOrgId(), lesson.getId());
        if (room == null) {
            this.wxLiveRoomLessonService.create(lesson, orgCourse.getMaxStudent(), dto);
        } else {
            lesson.setRoomId(room.getRoomId());
            this.wxLiveRoomLessonService.update(lesson, orgCourse.getMaxStudent(), dto);
        }
        if (needRearrange) {
            this.resetLessonNumber(orgId, lesson.getCourseId());
        }
    }

    private void resetLessonNumber(Long orgId, Long courseId) {
        List lessons = this.orgClassLessonDao.queryLessons(orgId, (Collection)Lists.newArrayList((Object[])new Long[]{courseId}), null, null, null, null, null, null, new String[]{"id"});
        if (CollectionUtils.isNotEmpty((Collection)lessons)) {
            int index = 1;
            Map[] params = new Map[lessons.size()];
            for (OrgClassLesson lesson : lessons) {
                HashMap<String, Number> param = new HashMap<String, Number>();
                param.put("id", lesson.getId());
                param.put("number", index);
                params[index - 1] = param;
                ++index;
            }
            this.orgClassLessonDao.batchUpdateLessonNumber(params);
        }
    }

    @Override
    @Transactional
    public void deleteLiveClassLesson(Long orgId, Long lessonId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", (Object)lessonId, (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (CollectionUtils.isNotEmpty((Collection)this.orgLessonCommentDao.getLessonComments(lessonId, null, null, new String[]{"id"}))) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.LESSON_WITH_COMMENT);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.orgLessonSignDao.getLessonSignList(orgId, null, lessonId, null, null, null, true, null, null, new String[]{"id"}))) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.LESSON_WITH_SIGN);
        }
        this.courseStudentService.deleteStudentFromLesson(orgId, lessonId, null);
        this.courseTeacherService.delTeacherFromLesson(orgId, lessonId, null);
        ArrayList lessonIds = Lists.newArrayList();
        lessonIds.add(lessonId);
        this.orgClassLessonDao.updateDelByLessonIds(orgId, (Collection)lessonIds);
        this.resetLessonNumber(orgId, lesson.getCourseId());
        this.orgLessonConflictService.delByLessonIds(orgId, (List)lessonIds);
        this.wxLiveRoomLessonService.delete(lesson);
    }

    @Override
    @Transactional
    public void addVideoClassLesson(Long orgId, WxCourseLessonDto dto) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((dto != null ? 1 : 0) != 0, (Object)"class lessons param is illegal");
        Preconditions.checkArgument((dto.getCourseId() != null && dto.getCourseId() > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        Preconditions.checkArgument((dto.getLessonName() != null && dto.getLessonName().length() < 21 ? 1 : 0) != 0, (Object)"the lesson name is null or too long");
        Preconditions.checkArgument((dto.getSourceId() != null ? 1 : 0) != 0, (Object)"sourcdId not exit");
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(dto.getCourseId(), new String[0]);
        Preconditions.checkArgument((orgCourse != null ? 1 : 0) != 0, (Object)"course not exit");
        if (orgCourse.getCourseType() != CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u8282\u7c7b\u578b\u53c2\u6570\u9519\u8bef");
        }
        if (orgCourse.getFreq() == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0b\u672a\u8bbe\u8bfe\u8282\u6570");
        }
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("courseId", orgCourse.getId());
        List allLessons = this.orgClassLessonDao.queryByCondition((Map)condition, null, new String[0]);
        if (allLessons.size() >= orgCourse.getFreq()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6392\u8bfe\u8bfe\u8282\u8d85\u8fc7\u8bfe\u7a0b\u8bbe\u7f6e");
        }
        OrgClassLesson lesson = new OrgClassLesson();
        Date now = new Date();
        lesson.setStartTime(now);
        lesson.setEndTime(now);
        lesson.setCourseId(dto.getCourseId());
        lesson.setCreateTime(now);
        lesson.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        lesson.setLayoutId(Long.valueOf(0L));
        lesson.setRoomId(Long.valueOf(0L));
        lesson.setUpdateTime(now);
        lesson.setNumber(Integer.valueOf(0));
        lesson.setName(dto.getLessonName());
        lesson.setOrgId(orgId);
        this.orgClassLessonDao.save((Object)lesson, new String[]{"startTime", "endTime", "courseId", "createTime", "delStatus", "layoutId", "roomId", "updateTime", "orgId", "name"});
        dto.setLessonId(lesson.getId());
        dto.setOrgId(orgId);
        this.wxVideoLessonService.saveByWxCourseLessonDto(dto);
    }

    @Override
    @Transactional
    public void editVideoClassLesson(Long orgId, WxCourseLessonDto dto) {
        dto.setOrgId(orgId);
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)dto.getLessonId(), new String[0]);
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(dto.getCourseId(), new String[0]);
        Preconditions.checkArgument((orgCourse != null ? 1 : 0) != 0, (Object)"course not exit");
        if (orgCourse.getCourseType() != CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u8282\u7c7b\u578b\u53c2\u6570\u9519\u8bef");
        }
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", (Object)dto.getLessonId(), (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        }
        lesson.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        ArrayList teacherIds = Lists.newArrayList();
        if (dto.getTeacherId() == null) {
            dto.setTeacherId(0L);
        } else {
            teacherIds.add(dto.getTeacherId());
        }
        lesson.setUpdateTime(new Date());
        lesson.setName(dto.getLessonName());
        this.orgClassLessonDao.update((Object)lesson, new String[0]);
        dto.setLessonId(lesson.getId());
        this.wxVideoLessonService.updateByWxCourseLessonDto(dto);
    }

    @Override
    @Transactional
    public void deleteVideoClassLesson(Long orgId, Long lessonId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", (Object)lessonId, (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (CollectionUtils.isNotEmpty((Collection)this.orgLessonCommentDao.getLessonComments(lessonId, null, null, new String[]{"id"}))) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.LESSON_WITH_COMMENT);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.orgLessonSignDao.getLessonSignList(orgId, null, lessonId, null, null, null, true, null, null, new String[]{"id"}))) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.LESSON_WITH_SIGN);
        }
        this.courseStudentService.deleteStudentFromLesson(orgId, lessonId, null);
        this.courseTeacherService.delTeacherFromLesson(orgId, lessonId, null);
        ArrayList lessonIds = Lists.newArrayList();
        lessonIds.add(lessonId);
        this.orgClassLessonDao.updateDelByLessonIds(orgId, (Collection)lessonIds);
        this.wxVideoLessonService.delByLessonId(orgId, lessonId);
    }

    @Override
    public List<WxLiveLessonView> listLiveClassLesson(Long orgId, Long courseId, PageDto pageDto) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        if (courseId != null) {
            condition.put("courseId", courseId);
        }
        condition.put("delStatus", 0);
        List lessonList = this.orgClassLessonDao.queryByCondition((Map)condition, Order.asc((String[])new String[]{"startTime"}), pageDto, new String[0]);
        ArrayList lessonIds = Lists.newArrayList();
        for (OrgClassLesson lesosn : lessonList) {
            lessonIds.add(lesosn.getId());
        }
        ArrayList wxLiveList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)lessonIds)) {
            return wxLiveList;
        }
        Map<Long, WxLiveRoom> liveRoomMap = this.wxLiveRoomService.queryMapByOrgLessonIds(orgId, lessonIds);
        Date now = new Date();
        for (OrgClassLesson lesson : lessonList) {
            WxLiveRoom liveLesson = liveRoomMap.get(lesson.getId());
            WxLiveLessonView view = this.buildWxLiveLessonView(lesson, liveLesson, now);
            wxLiveList.add(view);
        }
        return wxLiveList;
    }

    @Override
    public List<WxVideoLessonView> listVideoClassLesson(Long orgId, Long courseId) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("courseId", courseId);
        condition.put("delStatus", 0);
        List lessonList = this.orgClassLessonDao.queryByCondition((Map)condition, Order.asc((String[])new String[]{"id"}), null, new String[0]);
        ArrayList lessonIds = Lists.newArrayList();
        for (OrgClassLesson lesosn : lessonList) {
            lessonIds.add(lesosn.getId());
        }
        Map<Long, WxVideoLesson> wxVideoMap = this.wxVideoLessonService.queryMapByOrgLessonId(orgId, lessonIds);
        ArrayList sourceIds = Lists.newArrayList();
        for (WxVideoLesson videoLesson : wxVideoMap.values()) {
            sourceIds.add(videoLesson.getSourceId());
        }
        Map<Long, WxCloudSource> cloudSourceMap = this.wxCloudSourceService.getMapByIds(orgId, sourceIds);
        ArrayList wxVideoList = Lists.newArrayList();
        for (OrgClassLesson lesson : lessonList) {
            WxVideoLesson videoLesson = wxVideoMap.get(lesson.getId());
            WxCloudSource cloudSource = null;
            if (videoLesson != null) {
                cloudSource = cloudSourceMap.get(videoLesson.getSourceId());
            }
            WxVideoLessonView view = this.buildWxVideoLessonView(lesson, videoLesson, cloudSource);
            wxVideoList.add(view);
        }
        return wxVideoList;
    }

    private WxVideoLessonView buildWxVideoLessonView(OrgClassLesson lesson, WxVideoLesson video, WxCloudSource cloudSource) {
        WxVideoLessonView view = new WxVideoLessonView();
        view.setCourseId(lesson.getCourseId());
        view.setLessonId(lesson.getId());
        view.setName(lesson.getName());
        view.setNumber(lesson.getNumber());
        view.setOrgId(lesson.getOrgId());
        view.setCreateTime(lesson.getCreateTime());
        view.setUpdateTime(lesson.getUpdateTime());
        if (video != null) {
            view.setIsFree(video.getIsFree());
            view.setSourceId(video.getSourceId());
        }
        if (cloudSource != null) {
            view.setLength(cloudSource.getLength());
            view.setSourceName(cloudSource.getName());
            if (view.getLength() != null) {
                view.setLengthStr(DateUtil.secToTime((int)view.getLength()));
            }
        }
        return view;
    }

    private WxLiveLessonView buildWxLiveLessonView(OrgClassLesson lesson, WxLiveRoom liveRoom, Date now) {
        WxLiveLessonView view = new WxLiveLessonView();
        view.setCourseId(lesson.getCourseId());
        view.setLessonId(lesson.getId());
        view.setName(lesson.getName());
        view.setNumber(lesson.getNumber());
        view.setOrgId(lesson.getOrgId());
        view.setCreateTime(lesson.getCreateTime());
        view.setUpdateTime(lesson.getUpdateTime());
        if (liveRoom != null) {
            view.setRoomId(liveRoom.getRoomId());
            view.setStartTime(liveRoom.getStartTime());
            view.setEndTime(liveRoom.getEndTime());
            view.setAdminId(liveRoom.getAdminId());
            view.setTeacherId(liveRoom.getTeacherId());
            boolean result = view.getStartTime().before(now);
            if (!result) {
                view.setRoomStatus(RoomStatus.NOT_BEGIN.getCode());
            } else if (view.getEndTime().before(now)) {
                view.setRoomStatus(RoomStatus.END.getCode());
            } else {
                view.setRoomStatus(RoomStatus.ON_GOING.getCode());
            }
            view.setPlayBack(liveRoom.getPlayBack());
        }
        return view;
    }

    @Override
    public WxLiveLessonView getLiveClassLesson(Long orgId, Long lessonId) {
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        if (lesson == null || lesson.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u8282id\u9519\u8bef");
        }
        WxLiveRoom liveLesson = this.wxLiveRoomService.getLessonRoom(orgId, lessonId);
        Date now = new Date();
        WxLiveLessonView view = this.buildWxLiveLessonView(lesson, liveLesson, now);
        return view;
    }

    @Override
    public WxVideoLessonView getVideoClassLesson(Long orgId, Long lessonId) {
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        if (lesson == null || lesson.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u8282id\u9519\u8bef");
        }
        WxVideoLesson videoLesson = this.wxVideoLessonService.getByLessonId(orgId, lessonId);
        WxCloudSource cloudSource = null;
        if (videoLesson != null) {
            cloudSource = this.wxCloudSourceService.getById(orgId, videoLesson.getSourceId());
        }
        WxVideoLessonView view = this.buildWxVideoLessonView(lesson, videoLesson, cloudSource);
        return view;
    }

    @Override
    public List<WxVideoLessonView> getVideoClassList(Long orgId, Collection<Long> courseIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyList();
        }
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("courseId", courseIds);
        condition.put("delStatus", 0);
        List lessonList = this.orgClassLessonDao.queryByCondition((Map)condition, Order.desc((String[])new String[]{"number"}), null, new String[0]);
        ArrayList lessonIds = Lists.newArrayList();
        for (OrgClassLesson lesosn : lessonList) {
            lessonIds.add(lesosn.getId());
        }
        Map<Long, WxVideoLesson> wxVideoMap = this.wxVideoLessonService.queryMapByOrgLessonId(orgId, lessonIds);
        ArrayList sourceIds = Lists.newArrayList();
        for (WxVideoLesson videoLesson : wxVideoMap.values()) {
            sourceIds.add(videoLesson.getSourceId());
        }
        Map<Long, WxCloudSource> cloudSourceMap = this.wxCloudSourceService.getMapByIds(orgId, sourceIds);
        ArrayList wxVideoList = Lists.newArrayList();
        for (OrgClassLesson lesson : lessonList) {
            WxVideoLesson videoLesson = wxVideoMap.get(lesson.getId());
            WxCloudSource cloudSource = null;
            if (videoLesson != null) {
                cloudSource = cloudSourceMap.get(videoLesson.getSourceId());
            }
            WxVideoLessonView view = this.buildWxVideoLessonView(lesson, videoLesson, cloudSource);
            wxVideoList.add(view);
        }
        return wxVideoList;
    }

    @Override
    public List<WxVideoLessonView> getVideoLessonViewList(Long orgId, List<OrgClassLesson> lessons) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(lessons)) {
            return Collections.emptyList();
        }
        Set lessonIds = BaseUtils.getPropertiesList(lessons, (String)"id");
        Map<Long, WxVideoLesson> wxVideoMap = this.wxVideoLessonService.queryMapByOrgLessonId(orgId, lessonIds);
        ArrayList sourceIds = Lists.newArrayList();
        for (WxVideoLesson videoLesson : wxVideoMap.values()) {
            sourceIds.add(videoLesson.getSourceId());
        }
        Map<Long, WxCloudSource> cloudSourceMap = this.wxCloudSourceService.getMapByIds(orgId, sourceIds);
        ArrayList wxVideoList = Lists.newArrayList();
        for (OrgClassLesson lesson : lessons) {
            WxVideoLesson videoLesson = wxVideoMap.get(lesson.getId());
            WxCloudSource cloudSource = null;
            if (videoLesson != null) {
                cloudSource = cloudSourceMap.get(videoLesson.getSourceId());
            }
            WxVideoLessonView view = this.buildWxVideoLessonView(lesson, videoLesson, cloudSource);
            wxVideoList.add(view);
        }
        return wxVideoList;
    }
}

