/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseExtraDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.WxStudentExtDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseExtra;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.WxCloudSource;
import com.baijia.tianxiao.dal.org.po.WxLiveRoom;
import com.baijia.tianxiao.dal.org.po.WxVideoLesson;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.cloud.api.LiveRoomApi;
import com.baijia.tianxiao.sal.cloud.api.VideoApi;
import com.baijia.tianxiao.sal.cloud.model.response.DefaultApiResult;
import com.baijia.tianxiao.sal.cloud.utils.ClouldApiUtil;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.teacher.api.OrgTeacherService;
import com.baijia.tianxiao.sal.wx.api.WxCloudSourceService;
import com.baijia.tianxiao.sal.wx.api.WxConfigCacheService;
import com.baijia.tianxiao.sal.wx.api.WxLessonAccessRecordService;
import com.baijia.tianxiao.sal.wx.api.WxLessonAccessService;
import com.baijia.tianxiao.sal.wx.api.WxLiveRoomLessonService;
import com.baijia.tianxiao.sal.wx.api.WxLiveRoomService;
import com.baijia.tianxiao.sal.wx.api.WxRoomUserCountService;
import com.baijia.tianxiao.sal.wx.api.WxVideoLessonService;
import com.baijia.tianxiao.sal.wx.constant.WangxiaoConstant;
import com.baijia.tianxiao.sal.wx.model.WxLiveLessonView;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="wxLessonAccessService")
public class WxLessonAccessServiceImpl
implements WxLessonAccessService {
    private static final Logger log = LoggerFactory.getLogger(WxLessonAccessServiceImpl.class);
    private String liveRoomEnterUrl = null;
    private String playBackUrl = null;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgStudentService orgStudentService;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private WxLiveRoomLessonService wxLiveRoomLessonService;
    @Resource
    private WxVideoLessonService wxVideoLessonService;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgStudentApiService orgStudentApiService;
    @Resource
    private WxLiveRoomService wxLiveRoomService;
    @Resource
    private VideoApi videoApi;
    @Resource
    private WxCloudSourceService wxCloudSourceService;
    @Resource
    private WxLessonAccessRecordService wxLessonAccessRecordService;
    @Resource
    private WxConfigCacheService wxConfigCacheService;
    @Resource
    private WxRoomUserCountService wxRoomUserCountService;
    @Resource
    private OrgStudentCourseService orgStudentCourceService;
    @Resource
    private WxStudentExtDao wxStudentExtDao;
    @Resource
    private OrgTeacherService orgTeacherService;
    @Resource
    private OrgCourseExtraDao orgCourseExtraDao;

    @PostConstruct
    public void init() {
        String baijiaCloudDomain = LiveRoomApi.baijiaCloudDomain;
        this.liveRoomEnterUrl = baijiaCloudDomain + "/web/room/enter?";
        this.playBackUrl = baijiaCloudDomain + "/web/playback/index?classid=";
    }

    @Override
    public String checkEnterClassLiveRoom(Long orgId, Long studentUserId, Long lessonId) {
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        this.checkStudentLessonExit(orgId, studentUserId, lesson);
        OrgStudent orgStudent = this.orgStudentDao.getStudentByUserId(orgId, studentUserId, new String[0]);
        Long roomId = this.wxLiveRoomService.getLessonRoomId(orgId, lessonId);
        Integer maxCount = null;
        TXAccount txAccount = this.wxConfigCacheService.getTXAccountFromLocalCache(orgId.intValue());
        maxCount = txAccount == null || txAccount.getConcurrentNumber() == null ? WangxiaoConstant.wx_contract_concurrency : txAccount.getConcurrentNumber();
        boolean canAdd = this.wxRoomUserCountService.addOneCurrentUserCount(orgId, roomId, maxCount.longValue());
        if (!canAdd) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u4eba\u6570\u8f83\u591a\uff0c\u5df2\u5230\u5e76\u53d1\u4e0a\u9650\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        String enterUrl = null;
        try {
            enterUrl = this.createLiveRoomEnterUrl(orgStudent, roomId);
            this.wxLessonAccessRecordService.asyncCreate(orgId, lesson.getCourseId(), lessonId, orgStudent.getId());
        }
        catch (Exception e) {
            log.error("wx createLiveRoomEnterUrl error:{}", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u623f\u95f4\u8fdb\u5165\u94fe\u63a5\u5f02\u5e38");
        }
        return enterUrl;
    }

    @Override
    public String createLiveRoomPlayBackEnterUrl(Long orgId, Long studentUserId, Long lessonId) {
        Integer effectDays;
        Date effectDate;
        Date effectEndTime;
        Date now;
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        this.checkStudentLessonExit(orgId, studentUserId, lesson);
        OrgStudent orgStudent = this.orgStudentDao.getStudentByUserId(orgId, studentUserId, new String[0]);
        WxLiveRoom wxLiveRoom = this.wxLiveRoomService.getLessonRoom(orgId, lessonId);
        if (wxLiveRoom == null || wxLiveRoom.getDelStatus() == 1 || wxLiveRoom.getPlayBack() == 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u56de\u653e\u65e0\u6548");
        }
        Date playBackTime = wxLiveRoom.getBackTime();
        OrgCourseExtra orgCourseExtra = this.orgCourseExtraDao.getByOrgCourseId(orgId, wxLiveRoom.getCourseId());
        if (orgCourseExtra != null && orgCourseExtra.getEffectDays() != null && (now = new Date()).after(effectEndTime = DateUtil.getEndOfDay((Date)(effectDate = DateUtil.addDay((Date)playBackTime, (int)(effectDays = orgCourseExtra.getEffectDays())))))) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u60a8\u7684\u8bfe\u7a0b\u5df2\u8fc7\u6709\u6548\u671f");
        }
        String url = null;
        try {
            url = this.playBackUrl + wxLiveRoom.getRoomId();
            this.wxLessonAccessRecordService.asyncCreate(orgId, lesson.getCourseId(), lessonId, orgStudent.getId());
        }
        catch (Exception e) {
            log.error("wx createLiveRoomEnterUrl error:{}", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u623f\u95f4\u8fdb\u5165\u94fe\u63a5\u5f02\u5e38");
        }
        return url;
    }

    private void checkStudentLessonExit(Long orgId, Long studentUserId, OrgClassLesson lesson) {
        Integer effectDays;
        Date studentCreateTime;
        Date effectDate;
        Date effectEndTime;
        Date now;
        OrgCourseExtra orgCourseExtra;
        boolean lessonCheckResult;
        boolean classCheckResult;
        if (lesson == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u8282\u53c2\u6570\u65e0\u6548");
        }
        OrgCourse orgCourse = (OrgCourse)this.orgCourseDao.getById((Serializable)lesson.getCourseId(), new String[0]);
        boolean bl = classCheckResult = orgCourse != null && orgCourse.getIsClass().intValue() == CourseTypeEnum.IS_CLASS_TRUE.getCode().intValue();
        if (!classCheckResult) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u73ed\u7ea7\u53c2\u6570\u65e0\u6548");
        }
        boolean bl2 = lessonCheckResult = lesson.getOrgId().longValue() == orgId.longValue() && lesson.getDelStatus() == 0;
        if (!lessonCheckResult) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0b\u53c2\u6570\u65e0\u6548");
        }
        OrgStudentCourse studentCourse = this.orgStudentCourceService.getBySidAndCid(orgId, studentUserId, lesson.getCourseId());
        if (studentCourse == null || studentCourse.getDelStatus() != 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u83b7\u5f97\u8bfe\u7a0b\u8d44\u6e90\u6743\u9650");
        }
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode() && (orgCourseExtra = this.orgCourseExtraDao.getByOrgCourseId(orgId, orgCourse.getId())) != null && orgCourseExtra.getEffectDays() != null && (now = new Date()).after(effectEndTime = DateUtil.getEndOfDay((Date)(effectDate = DateUtil.addDay((Date)(studentCreateTime = studentCourse.getCreateTime()), (int)(effectDays = orgCourseExtra.getEffectDays())))))) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u60a8\u7684\u8bfe\u7a0b\u5df2\u8fc7\u6709\u6548\u671f");
        }
    }

    @Override
    public String createLiveRoomEnterUrl(OrgStudent orgStudent, Long roomId) throws UnsupportedEncodingException {
        ArrayList students = Lists.newArrayList();
        students.add(orgStudent);
        Map studentsAvatarMap = this.orgStudentApiService.batchGetStudentAvatarUrl((Collection)students);
        String avatar = (String)studentsAvatarMap.get(orgStudent.getId());
        HashMap params = Maps.newHashMap();
        params.put("room_id", roomId.toString());
        params.put("user_name", orgStudent.getName());
        params.put("user_number", orgStudent.getId().toString());
        params.put("user_role", "0");
        params.put("user_avatar", avatar);
        ClouldApiUtil.buidlSign(params);
        String paramsUrl = ClouldApiUtil.buildUrl(params);
        String allUrl = this.liveRoomEnterUrl + paramsUrl;
        return allUrl;
    }

    @Override
    public String createLiveRoomEnterUrl(Long orgId, String mobile, Long roomId, boolean isAdmin) throws UnsupportedEncodingException {
        String avatar;
        OrgTeacher teacher;
        Long userId;
        WxLiveRoom liveRoom = this.wxLiveRoomService.getByRoomId(roomId);
        if (liveRoom == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u76f4\u64ad\u623f\u95f4\u4e0d\u5b58\u5728");
        }
        ArrayList liveRoomList = Lists.newArrayList();
        liveRoomList.add(liveRoom);
        List<WxLiveLessonView> viewlist = this.wxLiveRoomService.buildLessonLiveView(orgId, liveRoomList);
        if (viewlist.size() == 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u76f4\u64ad\u623f\u95f4\u4e0d\u5b58\u5728");
        }
        WxLiveLessonView view = viewlist.get(0);
        if (view.getTeacher() != null) {
            userId = view.getTeacher().getUserId();
            String avatar2 = view.getTeacher().getAvatar();
            OrgTeacher teacher2 = this.orgTeacherService.getByUserId(userId.longValue());
            if (teacher2 != null && teacher2.getMobile() != null && StringUtils.equals((CharSequence)teacher2.getMobile(), (CharSequence)mobile)) {
                HashMap params = Maps.newHashMap();
                params.put("room_id", roomId.toString());
                params.put("user_name", view.getTeacher().getTeacherName());
                params.put("user_number", teacher2.getId().toString());
                params.put("user_role", "1");
                params.put("user_avatar", avatar2);
                ClouldApiUtil.buidlSign(params);
                String paramsUrl = ClouldApiUtil.buildUrl(params);
                String allUrl = this.liveRoomEnterUrl + paramsUrl;
                return allUrl;
            }
        }
        if (isAdmin) {
            userId = view.getAdmin().getUserId();
            teacher = this.orgTeacherService.getByUserId(userId.longValue());
            avatar = view.getTeacher().getAvatar();
            HashMap params = Maps.newHashMap();
            params.put("room_id", roomId.toString());
            params.put("user_name", view.getAdmin().getTeacherName());
            params.put("user_number", teacher.getId().toString());
            params.put("user_role", "2");
            params.put("user_avatar", avatar);
            ClouldApiUtil.buidlSign(params);
            String paramsUrl = ClouldApiUtil.buildUrl(params);
            String allUrl = this.liveRoomEnterUrl + paramsUrl;
            return allUrl;
        }
        if (view.getAdmin() != null) {
            userId = view.getAdmin().getUserId();
            teacher = this.orgTeacherService.getByUserId(userId.longValue());
            avatar = view.getTeacher().getAvatar();
            if (teacher != null && teacher.getMobile() != null && StringUtils.equals((CharSequence)teacher.getMobile(), (CharSequence)mobile)) {
                HashMap params = Maps.newHashMap();
                params.put("room_id", roomId.toString());
                params.put("user_name", view.getAdmin().getTeacherName());
                params.put("user_number", teacher.getId().toString());
                params.put("user_role", "2");
                params.put("user_avatar", avatar);
                ClouldApiUtil.buidlSign(params);
                String paramsUrl = ClouldApiUtil.buildUrl(params);
                String allUrl = this.liveRoomEnterUrl + paramsUrl;
                return allUrl;
            }
        }
        throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u4e0d\u662f\u5f53\u524d\u8bfe\u7a0b\u7684\u4e3b\u8bb2\u8001\u5e08\u6216\u8005\u52a9\u6559\uff0c\u65e0\u6743\u8fdb\u5165");
    }

    @Override
    public Map<String, Object> checkClassVideo(Long orgId, Long studentUserId, Long lessonId) {
        WxCloudSource cloudSource;
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        WxVideoLesson wxVideoLesson = this.wxVideoLessonService.getByLessonId(orgId, lessonId);
        if (wxVideoLesson == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0b\u4e0d\u5b58\u5728");
        }
        if (wxVideoLesson.getIsFree() == 0) {
            this.checkStudentLessonExit(orgId, studentUserId, lesson);
        }
        if ((cloudSource = this.wxCloudSourceService.getById(orgId, wxVideoLesson.getSourceId())) == null || cloudSource.getStatus() != 3 || cloudSource.getCloudId() == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u64ad\u653e\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
        if (cloudSource.getIsForbidden() == 1) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u64ad\u653e\u8d44\u6e90\u88ab\u7981\u6b62\u64ad\u653e");
        }
        String token = null;
        DefaultApiResult result = this.videoApi.videoPlaySign(cloudSource.getCloudId(), 180L);
        if (result.getCode() != 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u83b7\u53d6\u6587\u4ef6\u4e0a\u4f20\u5730\u5740\u5f02\u5e38");
        }
        OrgStudent orgStudent = this.orgStudentDao.getStudentByUserId(orgId, studentUserId, new String[0]);
        this.wxLessonAccessRecordService.asyncCreate(orgId, lesson.getCourseId(), lessonId, orgStudent.getId());
        token = result.getData().get("token").toString();
        HashMap map = Maps.newHashMap();
        map.put("token", token);
        map.put("cloudId", cloudSource.getCloudId());
        return map;
    }
}

