/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.WxLessonAccessRecordDao;
import com.baijia.tianxiao.dal.org.dto.WxLessonAccessRecordVo;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.WxLessonAccessRecord;
import com.baijia.tianxiao.sal.wx.api.WxLessonAccessRecordService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="wxLessonAccessRecordService")
public class WxLessonAccessRecordServiceImpl
implements WxLessonAccessRecordService {
    @Resource
    private WxLessonAccessRecordDao wxLessonAccessRecordDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgStudentDao orgStudentDao;

    @Override
    public void create(WxLessonAccessRecord record) {
        this.wxLessonAccessRecordDao.save((Object)record, new String[0]);
    }

    @Override
    public void create(Long orgId, Long courseId, Long lessonId, Long studentId) {
        WxLessonAccessRecord record = new WxLessonAccessRecord();
        record.setOrgId(orgId);
        record.setCourseId(courseId);
        record.setLessonId(lessonId);
        record.setStudentId(studentId);
        this.create(record);
    }

    @Override
    @Async
    public void asyncCreate(Long orgId, Long courseId, Long lessonId, Long studentId) {
        this.create(orgId, courseId, lessonId, studentId);
    }

    @Override
    public List<WxLessonAccessRecord> queryByOrgCondition(WxLessonAccessRecord record) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", record.getOrgId());
        if (record.getLessonId() != null) {
            condition.put("lessonId", record.getLessonId());
        }
        if (record.getStudentId() != null) {
            condition.put("studentId", record.getStudentId());
        }
        return this.wxLessonAccessRecordDao.queryByCondition((Map)condition, null, new String[0]);
    }

    @Override
    public Map<Long, Integer> queryCountByConditon(WxLessonAccessRecord record, String groupField, String countField) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", record.getOrgId());
        if (record.getLessonId() != null) {
            condition.put("lessonId", record.getLessonId());
        }
        if (record.getStudentId() != null) {
            condition.put("studentId", record.getStudentId());
        }
        return this.wxLessonAccessRecordDao.groupCount((Map)condition, countField, groupField, true, Long.class);
    }

    @Override
    public List<WxLessonAccessRecord> queryStudentLastAccessLesson(Long orgId, Long studentId, Long courseId) {
        return this.wxLessonAccessRecordDao.queryStudentLastAccessLesson(orgId, studentId, courseId);
    }

    @Override
    public List<WxLessonAccessRecord> queryLessonLastAccess(Long orgId, Long lessonId) {
        return this.wxLessonAccessRecordDao.queryLessonLastAccess(orgId, lessonId);
    }

    @Override
    public List<WxLessonAccessRecord> queryStudentLesson(Long orgId, Long studentId, Long lessonId) {
        return this.wxLessonAccessRecordDao.queryStudentLesson(orgId, studentId, lessonId);
    }

    @Override
    public List<WxLessonAccessRecordVo> converPoList2VoList(Long orgId, List<WxLessonAccessRecord> list) {
        HashSet courseIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        HashSet studentIds = Sets.newHashSet();
        for (WxLessonAccessRecord record : list) {
            courseIds.add(record.getCourseId());
            lessonIds.add(record.getLessonId());
            studentIds.add(record.getStudentId());
        }
        Map lessonMap = this.orgClassLessonDao.getClassLessonMap(orgId, (Collection)lessonIds, Integer.valueOf(0), new String[0]);
        Map courseMap = this.orgCourseDao.getOrgCourseMap((Collection)courseIds, new String[0]);
        Map studentNameMap = this.orgStudentDao.getStudentNameMap((Collection)studentIds);
        ArrayList voList = Lists.newArrayList();
        for (WxLessonAccessRecord record : list) {
            OrgCourse orgCourse = (OrgCourse)courseMap.get(record.getCourseId());
            OrgClassLesson lesson = (OrgClassLesson)lessonMap.get(record.getLessonId());
            String studentName = (String)studentNameMap.get(record.getStudentId());
            voList.add(this.converPo2Vo(record, orgCourse, lesson, studentName));
        }
        return voList;
    }

    private WxLessonAccessRecordVo converPo2Vo(WxLessonAccessRecord po, OrgCourse course, OrgClassLesson lesson, String studentName) {
        WxLessonAccessRecordVo vo = new WxLessonAccessRecordVo();
        vo.setCourseId(po.getCourseId());
        if (course != null) {
            vo.setCourseName(course.getName());
            vo.setCourseType(course.getCourseType());
        }
        vo.setLessonId(po.getLessonId());
        if (lesson != null) {
            vo.setLessonName(lesson.getName());
        }
        vo.setStudentId(po.getStudentId());
        vo.setStudentName(studentName);
        vo.setOrgId(po.getOrgId());
        vo.setCreateTime(po.getCreateTime());
        return vo;
    }
}

