/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baijia.tianxiao.dal.org.dao.WxCloudSourceDao;
import com.baijia.tianxiao.dal.org.dao.WxFlowRecordDao;
import com.baijia.tianxiao.dal.org.po.WxCloudSource;
import com.baijia.tianxiao.dal.org.po.WxFlowRecord;
import com.baijia.tianxiao.sal.cloud.api.VideoApi;
import com.baijia.tianxiao.sal.wx.api.WxCloudSourceService;
import com.baijia.tianxiao.sal.wx.api.WxFlowRecordService;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="WxFlowRecordService")
public class WxFlowRecordServiceImpl
implements WxFlowRecordService {
    private static final Logger log = LoggerFactory.getLogger(WxFlowRecordServiceImpl.class);
    @Resource
    private WxFlowRecordDao wxFlowRecordDao;
    @Resource
    private VideoApi videoApi;
    @Resource
    private WxCloudSourceService wxCloudSourceService;
    @Resource
    private WxCloudSourceDao wxCloudSourceDao;

    @Override
    public void batchSave(List<WxFlowRecord> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.wxFlowRecordDao.saveAll(list, false, new String[0]);
    }

    @Override
    public Long sumByOrgSourceAndDate(Long orgId, Long sourceId, Integer sourceType, String date) {
        return this.wxFlowRecordDao.sumByOrgSourceAndDate(orgId, sourceId, sourceType, date);
    }

    @Override
    public Long sumByOrgSourceAndDatePrefix(Long orgId, Long sourceId, Integer sourceType, String datePrefix) {
        Long flow = this.wxFlowRecordDao.sumByOrgSourceAndDatePrefix(orgId, sourceId, sourceType, datePrefix);
        if (flow == null) {
            flow = 0L;
        }
        return flow;
    }

    @Override
    public Map<Long, Long> groupsumByOrgSourceAndDate(Long orgId, Long sourceId, Integer sourceType, String date, String groupField) {
        return this.wxFlowRecordDao.groupsumByOrgSourceAndDate(orgId, sourceId, sourceType, date, groupField);
    }

    @Override
    public Map<Long, Long> groupsumByOrgSourceAndDatePrefix(Long orgId, Long sourceId, Integer sourceType, String datePrefix, String groupField) {
        return this.wxFlowRecordDao.groupsumByOrgSourceAndDatePrefix(orgId, sourceId, sourceType, datePrefix, groupField);
    }

    @Override
    public void synDailyVideoFlow() {
        int page = 1;
        int pageSize = 100;
        boolean hasMore = true;
        Date now = new Date();
        Date yesToday = DateUtil.addDay((Date)now, (int)-1);
        String dateStr = DateUtil.getStrByDate((Date)yesToday);
        HashMap condition = Maps.newHashMap();
        condition.put("date", dateStr);
        this.wxFlowRecordDao.delByCondition((Map)condition);
        HashMap orgTotalFlowMap = Maps.newHashMap();
        while (hasMore) {
            JSONObject apiResult = this.videoApi.batchQueryVideoInfo(page, pageSize, dateStr);
            log.info("videoApi.batchQueryVideoInfo result={}", (Object)apiResult);
            int code = apiResult.getInteger("code");
            if (code != 0) {
                log.error("videoApi.batchQueryVideoInfo error, result={}", (Object)apiResult);
            }
            JSONArray list = apiResult.getJSONObject("data").getJSONArray("list");
            this.batchSynSave(list, orgTotalFlowMap);
            int total = apiResult.getIntValue("total");
            if (page * pageSize >= total) {
                hasMore = false;
                continue;
            }
            ++page;
        }
        log.info("wx batchSynSave params,orgTotalFlowMap={}", (Object)orgTotalFlowMap);
        this.batchSave(Lists.newArrayList(orgTotalFlowMap.values()));
    }

    public void batchSynSave(JSONArray list, Map<Long, WxFlowRecord> orgTotalFlowMap) {
        log.info("wx batchSynSave params,list={},orgTotalFlowMap={}", (Object)list, orgTotalFlowMap);
        Iterator it = list.iterator();
        ArrayList cloudIds = Lists.newArrayList();
        while (it.hasNext()) {
            JSONObject ob = (JSONObject)it.next();
            Long video_id = ob.getLong("video_id");
            cloudIds.add(video_id);
        }
        if (CollectionUtils.isEmpty((Collection)cloudIds)) {
            return;
        }
        HashMap condition = Maps.newHashMap();
        condition.put("cloudId", cloudIds);
        List wxCloudSourceList = this.wxCloudSourceDao.queryByCondition((Map)condition, null, new String[0]);
        HashMap cloudIdMap = Maps.newHashMap();
        for (WxCloudSource cloudSource : wxCloudSourceList) {
            cloudIdMap.put(cloudSource.getCloudId(), cloudSource);
        }
        log.info("wx batchSynSave params,cloudIdMap={}", (Object)cloudIdMap);
        ArrayList flowRecordSaveList = Lists.newArrayList();
        for (JSONObject ob : list) {
            Long video_id = ob.getLong("video_id");
            String date = ob.getString("date");
            Long payCount = ob.getLong("play_count");
            Long complete_count = ob.getLong("complete_count");
            Long play_length = ob.getLong("play_length");
            Long flow = ob.getLong("flow");
            cloudIds.add(video_id);
            WxCloudSource cloudSource = (WxCloudSource)cloudIdMap.get(video_id);
            if (cloudSource == null) {
                log.info("wx batchSynSave params,cloudSource null,video_id={}", (Object)video_id);
                continue;
            }
            WxFlowRecord record = new WxFlowRecord();
            record.setOrgId(cloudSource.getOrgId());
            record.setSourceId(cloudSource.getId());
            record.setFlow(flow);
            record.setSourceType(Integer.valueOf(1));
            record.setDate(date);
            record.setPlayCount(payCount);
            record.setCompleteCount(complete_count);
            record.setPlayLength(play_length);
            flowRecordSaveList.add(record);
            WxFlowRecord totalFlow = orgTotalFlowMap.get(cloudSource.getOrgId());
            if (totalFlow == null) {
                totalFlow = new WxFlowRecord();
                totalFlow.setOrgId(cloudSource.getOrgId());
                totalFlow.setSourceType(Integer.valueOf(2));
                totalFlow.setSourceId(cloudSource.getOrgId());
                totalFlow.setDate(date);
                totalFlow.setFlow(Long.valueOf(0L));
                totalFlow.setPlayCount(Long.valueOf(0L));
                totalFlow.setCompleteCount(Long.valueOf(0L));
                totalFlow.setPlayLength(Long.valueOf(0L));
                orgTotalFlowMap.put(cloudSource.getOrgId(), totalFlow);
            }
            totalFlow.setFlow(Long.valueOf(totalFlow.getFlow() + flow));
            totalFlow.setPlayCount(Long.valueOf(totalFlow.getPlayCount() + payCount));
            totalFlow.setCompleteCount(Long.valueOf(totalFlow.getCompleteCount() + complete_count));
            totalFlow.setPlayLength(Long.valueOf(totalFlow.getPlayLength() + play_length));
        }
        log.info("wx batchSynSave params,flowRecordSaveList={}", (Object)flowRecordSaveList);
        this.batchSave(flowRecordSaveList);
    }
}

