/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.OrgCourseStatus;
import com.baijia.tianxiao.dal.constant.ChargeType;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.course.dao.OrgCoursePhotoDao;
import com.baijia.tianxiao.dal.course.po.OrgCoursePhoto;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseExtraDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.WxCoursewareDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseExtra;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.util.SerialNumberUtil;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.course.constant.LessonWay;
import com.baijia.tianxiao.sal.course.dto.OrgCourseInfoDto;
import com.baijia.tianxiao.sal.course.dto.OrgCourseQueryResponseDto;
import com.baijia.tianxiao.sal.course.dto.request.OrgRecommendCourseRequestDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgCourseGroupDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseConsumeRuleService;
import com.baijia.tianxiao.sal.course.service.OrgCourseGroupRelateService;
import com.baijia.tianxiao.sal.course.service.OrgCourseGroupService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.wx.api.WxCommonCounterService;
import com.baijia.tianxiao.sal.wx.api.WxCourseService;
import com.baijia.tianxiao.sal.wx.model.WxCommonCounterKey;
import com.baijia.tianxiao.sal.wx.model.WxCourseInfoDto;
import com.baijia.tianxiao.sal.wx.model.WxCourseQueryDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="wxCourseService")
public class WxCourseServiceImpl
implements WxCourseService {
    private static final Logger log = LoggerFactory.getLogger(WxCourseServiceImpl.class);
    @Autowired
    private OrgStudentApiService orgStudentApiService;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgCourseListService orgCourseListService;
    @Autowired
    private OrgCourseGroupRelateDao orgCourseGroupRelateDao;
    @Autowired
    private WxCoursewareDao wxCoursewareDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgCourseExtraDao orgCourseExtraDao;
    @Resource
    private OrgCourseConsumeRuleService orgCourseConsumeRuleService;
    @Autowired
    private OrgCourseGroupDao orgCourseGroupDao;
    @Autowired
    private OrgCourseGroupRelateService orgCourseGroupRelateService;
    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Autowired
    private CourseTeacherService courseTeacherService;
    @Autowired
    private OrgCoursePhotoDao orgCoursePhotoDao;
    @Autowired
    private StorageDao storageDao;
    @Autowired
    private OrgCourseGroupService orgCourseGroupService;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private WxCommonCounterService wxCommonCounterService;

    @Override
    public List<OrgCourseQueryResponseDto> queryOrgCourses(WxCourseQueryDto courseQueryDto, PageDto pageDto) {
        List orgCourses;
        List<OrgCourseQueryResponseDto> queryDtoList = new ArrayList<OrgCourseQueryResponseDto>();
        Long orgNumber = this.getOrgNumber(courseQueryDto.getOrgId());
        OrgCourseDao.OrgCourseListParam param = new OrgCourseDao.OrgCourseListParam();
        ArrayList types = Lists.newArrayList();
        List<Integer> allWxCourseTypes = this.getAllWxCourseType();
        if (courseQueryDto.getCourseType() != null) {
            if (allWxCourseTypes.contains(courseQueryDto.getCourseType())) {
                types.add(courseQueryDto.getCourseType());
            } else {
                types.addAll(allWxCourseTypes);
            }
        } else {
            types.addAll(allWxCourseTypes);
        }
        param.setCourseTypes((List)types);
        param.setPage(pageDto);
        param.setKey(courseQueryDto.getKey());
        param.setOrderField("createTime");
        param.setOrderType("DESC");
        param.setStatus(courseQueryDto.getCourseStatus());
        if (courseQueryDto.getIsFree().booleanValue()) {
            param.setCoursePrice(Double.valueOf(0.0));
        }
        Collection courseIds = null;
        if (courseQueryDto.getCourseCategory() != null && courseQueryDto.getCourseCategory() > 0) {
            courseIds = this.orgCourseGroupRelateDao.getCourseIdsByGroups((Collection)Sets.newHashSet((Object[])new Integer[]{courseQueryDto.getCourseCategory()}), Integer.valueOf(CourseType.ORG_COURSE.getCode()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(orgCourses = this.orgCourseDao.getCourseList(orgNumber, courseIds, param, new String[0])))) {
            queryDtoList = this.buildOrgCourseByCourseList(courseQueryDto.getOrgId(), orgCourses);
        }
        return queryDtoList;
    }

    private List<OrgCourseQueryResponseDto> buildResponseDtoList(List<CourseListReponseDto> courseDtoList, Map<Long, OrgCourseExtra> courseExtraMap) {
        ArrayList list = Lists.newArrayList();
        for (CourseListReponseDto course : courseDtoList) {
            OrgCourseExtra extra = courseExtraMap.get(course.getOrgCourseId());
            OrgCourseQueryResponseDto queryDto = this.buildQueryDto(course, extra);
            list.add(queryDto);
        }
        return list;
    }

    private OrgCourseQueryResponseDto buildQueryDto(CourseListReponseDto course, OrgCourseExtra extra) {
        OrgCourseQueryResponseDto dto = new OrgCourseQueryResponseDto();
        dto.setOrgCourseId(course.getOrgCourseId());
        dto.setCourseName(course.getCourseName());
        dto.setCoverUrl(course.getCoverUrl());
        dto.setOriginPrice(course.getPrice());
        dto.setCourseType(course.getCourseType());
        dto.setCourseStatus(course.getStatus());
        if (extra != null) {
            dto.setRefundDays(extra.getRefundDays());
            dto.setEffectDays(extra.getEffectDays());
        }
        return dto;
    }

    private List<Integer> getAllWxCourseType() {
        ArrayList allWxType = Lists.newArrayList();
        allWxType.add(CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode());
        allWxType.add(CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode());
        return allWxType;
    }

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784\u4e0d\u5b58\u5728");
        }
        Integer number = account.getNumber();
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    @Override
    public List<OrgCourseQueryResponseDto> buildOrgCourseByCourseIds(Long orgId, List<Long> courseIds) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Lists.newArrayList();
        }
        Long orgNumber = this.getOrgNumber(orgId);
        OrgCourseDao.OrgCourseListParam param = new OrgCourseDao.OrgCourseListParam();
        ArrayList types = Lists.newArrayList();
        List<Integer> allWxCourseTypes = this.getAllWxCourseType();
        types.addAll(allWxCourseTypes);
        param.setCourseTypes((List)types);
        param.setPage(null);
        List list = this.orgCourseDao.getCourseList(orgNumber, courseIds, param, new String[0]);
        return this.buildOrgCourseByCourseList(orgId, list);
    }

    @Override
    public Map<Long, OrgCourseQueryResponseDto> buildOrgCourseMapByCourseIds(Long orgId, List<Long> courseIds) {
        List<OrgCourseQueryResponseDto> list = this.buildOrgCourseByCourseIds(orgId, courseIds);
        HashMap maps = Maps.newHashMap();
        for (OrgCourseQueryResponseDto dto : list) {
            maps.put(dto.getOrgCourseId(), dto);
        }
        return maps;
    }

    @Override
    public List<OrgCourseQueryResponseDto> buildOrgCourseListMapByCourseIds(Long orgId, List<Long> courseIds) {
        Map<Long, OrgCourseQueryResponseDto> map = this.buildOrgCourseMapByCourseIds(orgId, courseIds);
        ArrayList list = Lists.newArrayList();
        for (Long courseId : courseIds) {
            OrgCourseQueryResponseDto dto = map.get(courseId);
            if (dto == null) continue;
            list.add(dto);
        }
        return list;
    }

    public Map<Integer, String> getCoverMap(List<OrgCourse> courses) {
        Collection coverList = CollectorUtil.collect(courses, (Function)new Function<OrgCourse, Integer>(){

            public Integer apply(OrgCourse arg0) {
                return arg0.getCover();
            }
        });
        List storages = this.storageDao.getByIds(coverList, new String[0]);
        return CollectorUtil.collectMap((Collection)storages, (Function)new Function<Storage, Integer>(){

            public Integer apply(Storage arg0) {
                return arg0.getId().intValue();
            }
        }, (Function)new Function<Storage, String>(){

            public String apply(Storage arg0) {
                if (StringUtils.isNotBlank((String)arg0.getAttach_url())) {
                    return arg0.getAttach_url();
                }
                return StorageUtil.constructUrl((Long)arg0.getFid(), (String)arg0.getMimetype(), (String)arg0.getSn());
            }
        });
    }

    @Override
    public List<OrgCourseQueryResponseDto> buildOrgCourseByCourseList(Long orgId, List<OrgCourse> courseList) {
        List<Object> queryDtoList = Lists.newArrayList();
        OrgCourseListService.CourseListParam courseListParam = new OrgCourseListService.CourseListParam();
        courseListParam.setCourses(courseList).setNeedCover(true).setNeedUrl(false).setOrgId(orgId);
        if (CollectionUtils.isEmpty(courseList)) {
            return queryDtoList;
        }
        List courseDtoList = this.orgCourseListService.getCourseList(courseListParam);
        HashSet courseIds = Sets.newHashSet();
        for (CourseListReponseDto dto : courseDtoList) {
            courseIds.add(dto.getOrgCourseId());
        }
        if (CollectionUtils.isEmpty((Collection)courseIds)) {
            return queryDtoList;
        }
        Map courseExtraMap = this.orgCourseExtraDao.queryMapByCourseIds((Collection)courseIds);
        queryDtoList = this.buildResponseDtoList(courseDtoList, courseExtraMap);
        return queryDtoList;
    }

    @Override
    public WxCourseInfoDto getCourseInfo(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784\u4fe1\u606f\u9519\u8bef");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"\u73ed\u7ea7\u4fe1\u606f\u9519\u8bef");
        WxCourseInfoDto data = new WxCourseInfoDto();
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(courseId, new String[0]);
        if (orgCourse == null || orgCourse.getIsDel().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u7a0b\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (orgCourse.getCourseType().equals(CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode())) {
            Map map;
            Integer rangeCount = this.orgClassLessonDao.getLessonCount(orgId, courseId, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
            if (rangeCount != null) {
                data.setRangeCount(rangeCount);
            }
            if ((map = this.orgClassLessonDao.getWxFinishLessonCount(orgId, (Collection)Lists.newArrayList((Object[])new Long[]{courseId}), Integer.valueOf(DeleteStatus.NORMAL.getValue()))) != null && map.containsKey(courseId)) {
                data.setFinishCount((Integer)map.get(courseId));
            }
        }
        WxCommonCounterKey wxCommonCounterKey = new WxCommonCounterKey();
        wxCommonCounterKey.setMainKey(WxCommonCounterKey.MainKeyType.course_order_count.name());
        wxCommonCounterKey.setSecondaryKey(orgCourse.getId().toString());
        Long studentNum = this.wxCommonCounterService.getCurrentCountByKey(wxCommonCounterKey);
        data.setStudentNum(studentNum != null ? studentNum.intValue() : 0);
        ArrayList courses = Lists.newArrayList();
        courses.add(orgCourse);
        Map<Integer, String> coverUrlMap = this.getCoverMap(courses);
        data.setCoverUrl(coverUrlMap.get(orgCourse.getCover()));
        data.setCoverStorageId(orgCourse.getCover());
        int count = this.wxCoursewareDao.getCourseWareCount(orgId, courseId);
        data.setCourseId(courseId);
        data.setCourseName(orgCourse.getName());
        data.setCourseType(orgCourse.getCourseType());
        data.setWareCount(count);
        data.setMaxStudent(orgCourse.getMaxStudent());
        data.setCoursePrice(orgCourse.getPrice());
        data.setFreq(orgCourse.getFreq());
        data.setStatus(orgCourse.getStatus());
        Blob source = orgCourse.getIntroduction();
        if (source != null) {
            String introduction = BaseUtils.blobToString((Blob)source, (String)"UTF-8");
            data.setIntroduction(introduction);
        }
        List teacherResponseDtos = this.courseTeacherService.listCourseTeacher(orgId, courseId);
        ArrayList teacherIds = Lists.newArrayList();
        ArrayList teacherNames = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)teacherResponseDtos)) {
            for (TeacherResponseDto teacher : teacherResponseDtos) {
                teacherIds.add(teacher.getTeacherId());
                teacherNames.add(teacher.getTeacherName());
            }
        }
        data.setTeacherIds(teacherIds);
        data.setTeacherNames(teacherNames);
        data.setTeacherResponseDtos(teacherResponseDtos);
        List groups = this.orgCourseGroupService.getByCourseId(orgId, courseId);
        ArrayList groupIds = Lists.newArrayList();
        ArrayList groupNames = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)groups)) {
            for (OrgCourseGroupDto dto : groups) {
                groupIds.add(dto.getGroupId());
                groupNames.add(dto.getGroupName());
            }
        }
        data.setGroupIds(groupIds);
        data.setGroupNames(groupNames);
        OrgCourseExtra orgCourseExtra = this.orgCourseExtraDao.getByOrgCourseId(orgId, courseId);
        if (orgCourseExtra != null) {
            data.setRefundDays(orgCourseExtra.getRefundDays());
            data.setEffectDays(orgCourseExtra.getEffectDays());
        }
        return data;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OrgCourse saveOrUpdateCourseWxBase(Long orgId, OrgCourseInfoDto course) {
        Integer courseType;
        boolean isUpdate;
        log.info("orgId={}, course={}", (Object)orgId, (Object)course);
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId illegal.");
        Preconditions.checkArgument((course != null ? 1 : 0) != 0, (Object)"course == null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)course.getCourseName()), (Object)"\u8bfe\u7a0b\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        Preconditions.checkArgument((course.getCoursePrice() != null && course.getCoursePrice() >= 0.0 ? 1 : 0) != 0, (Object)"\u8bfe\u7a0b\u4ef7\u683c\u4e0d\u5408\u6cd5");
        boolean bl = isUpdate = course.getCourseId() != null && course.getCourseId() > 0L;
        if (isUpdate) {
            // empty if block
        }
        OrgCourse orgCourse = new OrgCourse();
        orgCourse.setOrgNumber(this.getOrgNumber(orgId));
        orgCourse.setId(isUpdate ? course.getCourseId() : null);
        orgCourse.setBeginTime(course.getStartTime());
        orgCourse.setEndTime(course.getEndTime());
        orgCourse.setFreq(course.getFreq());
        orgCourse.setName(course.getCourseName());
        orgCourse.setMaxStudent(course.getMaxStudent());
        orgCourse.setNumber(Long.valueOf(System.nanoTime()));
        orgCourse.setIsDel(course.getIsDel());
        orgCourse.setSubjectId(Integer.valueOf(0));
        if (!isUpdate && course.getStatus() == null) {
            orgCourse.setStatus(Integer.valueOf(OrgCourseStatus.OFFLINE.getCode()));
        } else {
            orgCourse.setStatus(course.getStatus());
        }
        orgCourse.setVerifyStatus(Integer.valueOf(AuditStatus.PASS.getValue()));
        orgCourse.setAddress(course.getAddress());
        orgCourse.setLessonWay(LessonWay.STU_ACTIVE.getValue());
        Double lng = course.getLng();
        Double lat = course.getLat();
        if (lng != null && lat != null) {
            orgCourse.setOfflinePoi(lng + "," + lat);
        }
        orgCourse.setBranchId(Long.valueOf(-1L));
        orgCourse.setClsfyId(Long.valueOf(-1L));
        orgCourse.setRoomId(Long.valueOf(-1L));
        orgCourse.setLayoutId(Long.valueOf(-1L));
        orgCourse.setPrice(course.getCoursePrice());
        orgCourse.setLessonSummary(course.getLessonSummary());
        orgCourse.setChargeType(ChargeType.BY_PERIODS.getCode());
        if (isUpdate) {
            orgCourse.setCourseType(null);
        } else {
            Integer courseType2 = course.getCourseType();
            if (courseType2 != CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode() && courseType2 != CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode()) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u7a0b\u7c7b\u578b\u53c2\u6570\u9519\u8bef");
            }
            Integer isCourse = null;
            Integer isClass = null;
            isCourse = CourseTypeEnum.IS_COURSE_TRUE.getCode();
            isClass = CourseTypeEnum.IS_CLASS_TRUE.getCode();
            orgCourse.setCourseType(courseType2);
            orgCourse.setIsCourse(isCourse);
            orgCourse.setIsClass(isClass);
        }
        log.debug("orgCourse={}", (Object)orgCourse);
        if (isUpdate) {
            this.orgCourseDao.update((Object)orgCourse, Boolean.valueOf(false), new String[0]);
        } else {
            this.orgCourseDao.save((Object)orgCourse, new String[0]);
        }
        OrgCourseExtra orgCourseExtra = new OrgCourseExtra();
        orgCourseExtra.setCourseId(orgCourse.getId());
        orgCourseExtra.setOrgId(orgId);
        orgCourseExtra.setEffectDays(course.getEffectDays());
        orgCourseExtra.setRefundDays(course.getRefundDays());
        if (isUpdate) {
            courseType = course.getCourseType();
            if (CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode().intValue() == courseType.intValue()) {
                orgCourseExtra.setEffectDays(null);
            }
            this.orgCourseExtraDao.updateByOrgCourseId(orgCourseExtra);
        } else {
            courseType = course.getCourseType();
            if (CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode().intValue() == courseType.intValue()) {
                orgCourseExtra.setEffectDays(Integer.valueOf(90));
            }
            this.orgCourseExtraDao.save((Object)orgCourseExtra, new String[0]);
        }
        OrgCourse newCourse = (OrgCourse)this.orgCourseDao.getById((Serializable)orgCourse.getId(), new String[0]);
        Integer courseType3 = newCourse.getCourseType();
        if (!isUpdate) {
            Integer courseConsumeRuleValue = course.getConsumeRule();
            if (courseType3 == CourseTypeEnum.COURSE_TYPE_CLASS_LIVE.getCode()) {
                courseConsumeRuleValue = CourseConsumeRuleEnum.TIME_0.getValue();
            } else if (courseType3 == CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode()) {
                courseConsumeRuleValue = CourseConsumeRuleEnum.SIGNIN_7.getValue();
            }
            if (orgCourse.getId() != null && orgCourse.getId() > 0L) {
                this.orgCourseConsumeRuleService.create(orgId, orgCourse.getId(), courseConsumeRuleValue);
            }
        }
        if (orgCourse.getId() != null && orgCourse.getId() > 0L) {
            if (!isUpdate) {
                long number = SerialNumberUtil.generateNumber((int)orgCourse.getId().intValue(), (int)99999999, (int)4);
                orgCourse.setNumber(Long.valueOf(number));
                this.orgCourseDao.saveOrUpdate((Object)orgCourse, new String[]{"number"});
            }
        } else {
            log.error("orgCourse={}", (Object)orgCourse);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "courseId illegal.");
        }
        if (StringUtils.isNotBlank((String)course.getGroup())) {
            try {
                List grpIds = JacksonUtil.str2List((String)course.getGroup(), Integer.class);
                this.editGroupsOfCourse(orgId, orgCourse.getId(), grpIds);
            }
            catch (IOException e) {
                e.printStackTrace();
                log.warn("{}", (Throwable)e);
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "group json format error!");
            }
        }
        return orgCourse;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateCourseWxOthers(Long orgId, OrgCourseInfoDto course) {
        OrgCourse orgCourse = (OrgCourse)this.orgCourseDao.getById((Serializable)course.getCourseId(), new String[0]);
        if (orgCourse == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u7a0b\u4e0d\u5b58\u5728");
        }
        Integer courseType = orgCourse.getCourseType();
        if (orgCourse != null && courseType == CourseTypeEnum.COURSE_TYPE_CLASS_VIDEO.getCode()) {
            course.setStartTime(null);
            course.setEndTime(null);
            course.setMaxStudent(null);
            course.setFreq(null);
        }
        orgCourse.setCover(course.getCoverStorageId());
        if (orgCourse.getCover() != null) {
            this.orgCourseDao.update((Object)orgCourse, Boolean.valueOf(false), new String[]{"cover"});
        }
        if (course.getIntroduction() != null) {
            Blob intro = BaseUtils.strToBlob((String)course.getIntroduction(), (String)"UTF-8");
            orgCourse.setIntroduction(intro);
        } else {
            orgCourse.setIntroduction(null);
        }
        this.orgCourseDao.update((Object)orgCourse, Boolean.valueOf(true), new String[]{"introduction"});
        if (StringUtils.isNotBlank((String)course.getTeacherIds())) {
            int delResult;
            List<Long> toDelTeacherIds;
            List teacherIds = null;
            try {
                teacherIds = JacksonUtil.str2List((String)course.getTeacherIds(), Long.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "teacherIds \u53c2\u6570\u9519\u8bef\uff01");
            }
            log.debug("{},{}", (Object)teacherIds, (Object)course.getTeacherIds());
            List courseTeachers = this.orgCourseTeacherDao.getTeacherIdsByCourseId(orgCourse.getId());
            if (CollectionUtils.isNotEmpty((Collection)courseTeachers) && (toDelTeacherIds = this.findNeedDelTeacher(teacherIds, courseTeachers)).size() > 0 && (delResult = this.courseTeacherService.delTeacherFromCourseForLessonCheck(orgId, orgCourse.getId(), toDelTeacherIds)) == 0) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5df2\u7ecf\u6392\u8bfe\u7684\u8001\u5e08\u65e0\u6cd5\u5220\u9664");
            }
            teacherIds.removeAll(courseTeachers);
            this.courseTeacherService.addTeacherToCourse(orgId, orgCourse.getId(), (Collection)teacherIds);
        }
        if (course.getCoverStorageId() != null) {
            this.editCoursePhoto(orgCourse.getId(), course.getCoverStorageId().longValue());
        }
        return orgCourse.getId();
    }

    @Override
    public OrgCourseInfoDto getOrgCourseInfo(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"illegal courseId");
        OrgCourseInfoDto orgCourseInfoDto = new OrgCourseInfoDto();
        OrgCourse course = null;
        if (courseId != null && courseId > 0L && (course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0])) != null) {
            log.debug("---------------getNumber={},getCourseType={}", (Object)course.getNumber(), (Object)course.getCourseType());
            if (course.getCourseType() != CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
                List studentIds = this.orgStudentCourseDao.getStudents(orgId, courseId, Integer.valueOf(0));
                orgCourseInfoDto.setStudentNum(Integer.valueOf(studentIds.size()));
            } else {
                List classIds = this.orgCourseDao.getClassIdsByParentId(courseId);
                List list = this.orgStudentCourseDao.getStudentIdsByCourseIds(orgId, (Collection)classIds);
                orgCourseInfoDto.setStudentNum(Integer.valueOf(list.size()));
            }
            orgCourseInfoDto.setCourseType(course.getCourseType());
            orgCourseInfoDto.setCourseNumber(course.getNumber());
            orgCourseInfoDto.setCourseId(courseId);
            orgCourseInfoDto.setCourseName(course.getName());
            orgCourseInfoDto.setCoursePrice(course.getPrice());
            orgCourseInfoDto.setCoursePriceStr(NumberUtil.get2FromDouble((double)course.getPrice()));
            orgCourseInfoDto.setLessonSummary(course.getLessonSummary());
            orgCourseInfoDto.setMaxStudent(course.getMaxStudent());
            orgCourseInfoDto.setCoverStorageId(course.getCover());
            orgCourseInfoDto.setAddress(course.getAddress());
            orgCourseInfoDto.setStartTime(course.getBeginTime());
            orgCourseInfoDto.setEndTime(course.getEndTime());
            orgCourseInfoDto.setFreq(course.getFreq());
            String intro = BaseUtils.blobToString((Blob)course.getIntroduction(), (String)"UTF-8");
            orgCourseInfoDto.setIntroduction(intro);
            orgCourseInfoDto.setStatus(course.getStatus());
            orgCourseInfoDto.setIsDel(course.getIsDel());
            Integer consumeRule = this.orgCourseConsumeRuleService.getRuleValueByCourseId(orgId, course);
            orgCourseInfoDto.setConsumeRule(consumeRule);
            orgCourseInfoDto.setConsumeRuleStr(CourseConsumeRuleEnum.getRuleDescByValue((Integer)consumeRule));
            if (StringUtils.isNotBlank((String)course.getOfflinePoi())) {
                String[] lnglat = course.getOfflinePoi().split(",");
                log.debug("latlng={},len={}", (Object)lnglat, (Object)lnglat.length);
                if (lnglat != null && lnglat.length >= 2) {
                    String lng = lnglat[0];
                    String lat = lnglat[1];
                    try {
                        orgCourseInfoDto.setLat(Double.valueOf(Double.parseDouble(lat)));
                        orgCourseInfoDto.setLng(Double.valueOf(Double.parseDouble(lng)));
                    }
                    catch (NumberFormatException e) {
                        log.warn("lat={},lng={}", (Object)lat, (Object)lng);
                    }
                }
            }
            orgCourseInfoDto.setCoverUrl(this.getCoverUrl(course));
            orgCourseInfoDto.setTeachers(this.courseTeacherService.listCourseTeacher(orgId, courseId));
            List groups = this.orgCourseGroupService.getByCourseId(orgId, courseId);
            if (CollectionUtils.isNotEmpty((Collection)groups)) {
                orgCourseInfoDto.setGroups(groups);
            }
            List teacherIds = this.orgCourseTeacherDao.getTeacherIdsByCourseId(courseId);
            log.debug("------------------teacherIds={}", (Object)teacherIds);
            List teachers = this.teacherDao.getByUserIds((Collection)teacherIds, new String[0]);
            Map teacherMap = Maps.newHashMap();
            if (teacherIds != null && teacherIds.size() > 0) {
                teacherMap = CollectorUtil.collectMap((Collection)teachers, (Function)new Function<Teacher, Long>(){

                    public Long apply(Teacher input) {
                        return input.getUserId();
                    }
                });
            }
            ArrayList userIds = Lists.newArrayList();
            for (Teacher t : teachers) {
                userIds.add(t.getUserId());
            }
            Map storageIds = CollectorUtil.collectMap((Collection)teachers, (Function)new Function<Teacher, Long>(){

                public Long apply(Teacher teacher) {
                    return teacher.getAvatar();
                }
            });
            List storages = this.storageDao.getByIds(storageIds.keySet(), new String[0]);
            Map storageMap = CollectorUtil.collectMap((Collection)storages, (Function)new Function<Storage, Long>(){

                public Long apply(Storage storage) {
                    return storage.getId();
                }
            });
            ArrayList list = Lists.newArrayList();
            for (Long l : teacherIds) {
                Storage storage;
                TeacherResponseDto dto = new TeacherResponseDto();
                Teacher teacher = (Teacher)teacherMap.get(l);
                if (teacher.getOrgId() == null || teacher.getOrgId().longValue() != orgId.longValue()) continue;
                if (teacher.getAvatar() != null && (storage = (Storage)storageMap.get(teacher.getAvatar())) != null) {
                    String avatarUrl = StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn());
                    dto.setAvatar(avatarUrl);
                }
                dto.setBranchId(teacher.getBranchId());
                dto.setMobile(teacher.getMobile());
                dto.setSchoolAge(teacher.getSchoolAge());
                dto.setTeacherId(teacher.getUserId());
                dto.setTeacherName(teacher.getRealName());
                dto.setIntroduce(teacher.getIntroduce());
                list.add(dto);
            }
            orgCourseInfoDto.setTeachers((List)list);
            HashSet set = Sets.newHashSet();
            set.add(courseId);
            Map map = this.orgClassLessonDao.getLessonCount(orgId, (Collection)set, Integer.valueOf(0));
            int hasPlan = 0;
            if (map.get(courseId) != null) {
                hasPlan = (Integer)map.get(courseId);
            }
            orgCourseInfoDto.setHasPlan(Integer.valueOf(hasPlan));
            Date date = course.getBeginTime();
            if (date != null) {
                orgCourseInfoDto.setStartDay(DateUtil.getStrByDateFormate((Date)date, (String)"yyyy\u5e74MM\u6708dd\u65e5"));
                orgCourseInfoDto.setStartWeek("\u661f\u671f" + DateUtil.getChineseWeekDay((Date)date));
            } else {
                List ll = this.orgClassLessonDao.getLessons((Collection)set, null, orgId, Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[0]);
                if (ll != null && ll.size() > 0) {
                    OrgClassLesson o = (OrgClassLesson)ll.get(0);
                    orgCourseInfoDto.setStartDay(DateUtil.getStrByDateFormate((Date)o.getStartTime(), (String)"yyyy\u5e74MM\u6708dd\u65e5"));
                    orgCourseInfoDto.setStartWeek("\u661f\u671f" + DateUtil.getChineseWeekDay((Date)o.getStartTime()));
                } else {
                    orgCourseInfoDto.setStartDay("");
                    orgCourseInfoDto.setStartWeek("");
                }
            }
            orgCourseInfoDto.setIsCourse(course.getIsCourse());
            orgCourseInfoDto.setChargeType(course.getChargeType());
            OrgCourseExtra orgCourseExtra = this.orgCourseExtraDao.getByOrgCourseId(orgId, courseId);
            if (orgCourseExtra != null) {
                orgCourseInfoDto.setRefundDays(orgCourseExtra.getRefundDays());
                orgCourseInfoDto.setEffectDays(orgCourseExtra.getEffectDays());
            }
        }
        return orgCourseInfoDto;
    }

    private void editGroupsOfCourse(Long orgId, Long courseId, List<Integer> grpIds) {
        List orgGrpIds = this.orgCourseGroupDao.getOrgCourseGroupIdList(Integer.valueOf(orgId.intValue()));
        if (CollectionUtils.isEmpty((Collection)orgGrpIds) || grpIds == null || courseId == null) {
            return;
        }
        grpIds.retainAll(orgGrpIds);
        List existGrpIds = this.orgCourseGroupRelateDao.getGroupIdByCourseId(courseId, Integer.valueOf(CourseType.ORG_COURSE.getCode()));
        if (CollectionUtils.isNotEmpty((Collection)existGrpIds)) {
            ArrayList toDelGrpIds = Lists.newArrayList((Iterable)existGrpIds);
            toDelGrpIds.removeAll(grpIds);
            this.orgCourseGroupRelateDao.deleteGroupOfCourse(courseId, (Collection)toDelGrpIds, Integer.valueOf(CourseType.ORG_COURSE.getCode()));
        }
        for (Integer gid : grpIds) {
            OrgRecommendCourseRequestDto hotCourse = new OrgRecommendCourseRequestDto();
            hotCourse.setCourseId(courseId);
            hotCourse.setCourseType(Integer.valueOf(CourseType.ORG_COURSE.getCode()));
            this.orgCourseGroupRelateService.addCourse(gid.intValue(), hotCourse, 0);
        }
    }

    private List<Long> findNeedDelTeacher(List<Long> newTeacherList, List<Long> existingTeacherList) {
        ArrayList toDelTeacherIds = Lists.newArrayList(existingTeacherList);
        toDelTeacherIds.removeAll(newTeacherList);
        return toDelTeacherIds;
    }

    private void editCoursePhoto(Long courseId, Long storageId) {
        Preconditions.checkNotNull((Object)courseId);
        Preconditions.checkNotNull((Object)storageId);
        String coverUrl = this.getCoverUrl(storageId);
        OrgCoursePhoto photo = this.orgCoursePhotoDao.getLastAddPhoto(courseId);
        if (photo == null) {
            photo = new OrgCoursePhoto();
        }
        photo.setCreateTime(new Date());
        photo.setOrgCourseId(courseId);
        photo.setStorageId(storageId);
        photo.setUrl(coverUrl);
        photo.setCreateTime(new Date());
        this.orgCoursePhotoDao.saveOrUpdate((Object)photo, new String[0]);
    }

    private String getCoverUrl(Long storageId) {
        if (storageId == null) {
            return "https://imgs.genshuixue.com/24489340_jifl3uig.png";
        }
        Storage storage = (Storage)this.storageDao.getById((Serializable)storageId, new String[0]);
        if (storage == null) {
            return "https://imgs.genshuixue.com/24489340_jifl3uig.png";
        }
        if (StringUtils.isNotBlank((String)storage.getAttach_url())) {
            return storage.getAttach_url();
        }
        return StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn());
    }

    private String getCoverUrl(OrgCourse course) {
        if (course == null || course.getCover() == null) {
            return "https://imgs.genshuixue.com/24489340_jifl3uig.png";
        }
        return this.getCoverUrl(course.getCover().longValue());
    }

    @Override
    public void editEffectDays(Long orgId, Long courseId, Integer days) {
        OrgCourseExtra orgCourseExtra = new OrgCourseExtra();
        orgCourseExtra.setCourseId(courseId);
        orgCourseExtra.setOrgId(orgId);
        orgCourseExtra.setEffectDays(days);
        this.orgCourseExtraDao.updateByOrgCourseId(orgCourseExtra);
    }
}

