/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.WxConfigDao;
import com.baijia.tianxiao.dal.org.po.WxConfig;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.wx.api.WxConfigService;
import com.baijia.tianxiao.sal.wx.enums.ConfigKeyEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="wxConfigService")
public class WxConfigServiceImpl
implements WxConfigService {
    @Resource
    private WxConfigDao orgWxConfigDao;

    @Override
    public List<WxConfig> queryAllByOrgId(Long orgId) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        return this.orgWxConfigDao.queryByCondition((Map)condition, null, new String[0]);
    }

    @Override
    public List<WxConfig> queryAllByConfigKey(ConfigKeyEnum configKey) {
        HashMap condition = Maps.newHashMap();
        condition.put("bizKey", configKey.name());
        return this.orgWxConfigDao.queryByCondition((Map)condition, null, new String[0]);
    }

    private List<String> getConfigKeyNames(List<ConfigKeyEnum> configKeyList) {
        ArrayList nameList = Lists.newArrayList();
        for (ConfigKeyEnum key : configKeyList) {
            nameList.add(key.name());
        }
        return nameList;
    }

    @Override
    public WxConfig getByKey(Long orgId, ConfigKeyEnum configKey) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("bizKey", configKey.name());
        List list = this.orgWxConfigDao.queryByCondition((Map)condition, null, new String[0]);
        if (list.size() == 1) {
            return (WxConfig)list.get(0);
        }
        return null;
    }

    @Override
    public String getValueByKey(Long orgId, ConfigKeyEnum configKey) {
        WxConfig config = this.getByKey(orgId, configKey);
        if (config == null || config.getValue() == null) {
            return "";
        }
        return config.getValue();
    }

    @Override
    public void save(WxConfig sysConfig) {
        ConfigKeyEnum keyEnum;
        Long orgId = sysConfig.getOrgId();
        if (this.getByKey(orgId, keyEnum = ConfigKeyEnum.getByName(sysConfig.getBizKey())) != null) {
            this.orgWxConfigDao.update((Object)sysConfig, new String[0]);
        }
        this.orgWxConfigDao.save((Object)sysConfig, new String[0]);
    }

    @Override
    public List<WxConfig> queryByKeys(Long orgId, Collection<String> keys) {
        if (!ConfigKeyEnum.batchCheckNames(keys)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0d\u5b58\u5728\u7684\u914d\u7f6e\u7c7b\u578b");
        }
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("bizKey", keys);
        return this.orgWxConfigDao.queryByCondition((Map)condition, null, new String[0]);
    }

    @Override
    public List<WxConfig> batchQueryByConfigKeyList(Long orgId, List<ConfigKeyEnum> configKeyList) {
        HashMap condition = Maps.newHashMap();
        List<String> names = this.getConfigKeyNames(configKeyList);
        condition.put("orgId", orgId);
        condition.put("bizKey", names);
        List list = this.orgWxConfigDao.queryByCondition((Map)condition, null, new String[0]);
        return list;
    }

    @Override
    public Map<String, String> batchQueryMapByConfigKeyList(Long orgId, List<ConfigKeyEnum> configKeyList) {
        List<String> names = this.getConfigKeyNames(configKeyList);
        List<WxConfig> wxconfigList = this.batchQueryByConfigKeyList(orgId, configKeyList);
        return this.wxConfigList2Map(wxconfigList, names);
    }

    @Override
    public List<WxConfig> queryByKeyPrefix(Long orgId, String namePrefix) {
        List<String> names = ConfigKeyEnum.listNameByNamePrefix(namePrefix);
        if (CollectionUtils.isEmpty(names)) {
            return Lists.newArrayList();
        }
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("bizKey", names);
        return this.orgWxConfigDao.queryByCondition((Map)condition, null, new String[0]);
    }

    @Override
    public void batchSave(Long orgId, Map<String, String> configMap) {
        if (!ConfigKeyEnum.batchCheckNames(configMap.keySet())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0d\u5b58\u5728\u7684\u914d\u7f6e\u7c7b\u578b");
        }
        List<WxConfig> list = this.queryByKeys(orgId, configMap.keySet());
        HashSet updateKeys = Sets.newHashSet();
        for (WxConfig wxConfig : list) {
            String key = wxConfig.getBizKey();
            updateKeys.add(key);
        }
        for (Map.Entry entry : configMap.entrySet()) {
            String tempKey = (String)entry.getKey();
            if (updateKeys.contains(tempKey)) {
                HashMap updateCondtion = Maps.newHashMap();
                updateCondtion.put("orgId", orgId);
                updateCondtion.put("bizKey", tempKey);
                updateCondtion.put("value", entry.getValue());
                this.orgWxConfigDao.update((Map)updateCondtion, new String[]{"value"});
                continue;
            }
            WxConfig config = new WxConfig();
            config.setOrgId(orgId);
            config.setBizKey(tempKey);
            config.setValue((String)entry.getValue());
            try {
                this.orgWxConfigDao.save((Object)config, new String[0]);
            }
            catch (Exception e) {
                HashMap updateCondtion = Maps.newHashMap();
                updateCondtion.put("orgId", orgId);
                updateCondtion.put("bizKey", tempKey);
                updateCondtion.put("value", entry.getValue());
                this.orgWxConfigDao.update((Map)updateCondtion, new String[]{"value"});
            }
        }
    }

    @Override
    public Map<String, String> wxConfigList2Map(List<WxConfig> wxconfigList) {
        HashMap map = Maps.newHashMap();
        for (WxConfig config : wxconfigList) {
            map.put(config.getBizKey(), config.getValue());
        }
        return map;
    }

    @Override
    public Map<String, String> wxConfigList2Map(List<WxConfig> wxconfigList, Collection<String> keys) {
        HashMap map = Maps.newHashMap();
        for (WxConfig config : wxconfigList) {
            map.put(config.getBizKey(), config.getValue());
        }
        keys.removeAll(map.keySet());
        Map<String, String> defaultValueMap = ConfigKeyEnum.getDefaultValue(keys);
        map.putAll(defaultValueMap);
        return map;
    }
}

