/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.WxConfig;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.wx.api.WxConfigCacheService;
import com.baijia.tianxiao.sal.wx.api.WxConfigService;
import com.baijia.tianxiao.sal.wx.enums.ConfigKeyEnum;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service(value="wxConfigCacheService")
public class WxConfigCacheServiceImpl
implements WxConfigCacheService {
    private static final Logger log = LoggerFactory.getLogger(WxConfigCacheServiceImpl.class);
    @Resource
    private WxConfigService wxConfigService;
    @Resource
    private TXAccountService txAccountService;
    @Resource
    private OrgAccountService orgAccountService;
    @Resource
    private OrgSubAccountDao orgSubAccountDao;
    private Cache<Long, Map<String, String>> orgWxConfigCacheFormCallable = null;
    private Cache<Integer, TXAccount> txAccountCacheFormCallable = null;
    private Cache<Integer, Integer> orgNumberCacheMapFormCallable = null;
    private Cache<Integer, OrgSubAccount> orgSubAccountCacheFormCallable = null;
    Map<String, Long> allAliasOrgMap = null;

    @PostConstruct
    public void init() throws Exception {
        this.orgWxConfigCacheFormCallable = WxConfigCacheServiceImpl.callableCached();
        this.txAccountCacheFormCallable = WxConfigCacheServiceImpl.callableCached();
        this.orgNumberCacheMapFormCallable = WxConfigCacheServiceImpl.callableCached();
        this.orgSubAccountCacheFormCallable = WxConfigCacheServiceImpl.callableCached();
    }

    public static <K, V> Cache<K, V> callableCached() throws Exception {
        Cache cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
        return cache;
    }

    private Map<String, String> getWxConfigCallableCache(final Long orgId) {
        try {
            return (Map)this.orgWxConfigCacheFormCallable.get((Object)orgId, (Callable)new Callable<Map<String, String>>(){

                @Override
                public Map<String, String> call() throws Exception {
                    return WxConfigCacheServiceImpl.this.listAllOrgConfig(orgId);
                }
            });
        }
        catch (ExecutionException e) {
            log.error("", (Throwable)e);
            return null;
        }
        catch (Throwable e) {
            log.warn("", e);
            return null;
        }
    }

    private OrgSubAccount orgSubAccountCacheFormCallable(final Integer orgId) {
        try {
            return (OrgSubAccount)this.orgSubAccountCacheFormCallable.get((Object)orgId, (Callable)new Callable<OrgSubAccount>(){

                @Override
                public OrgSubAccount call() throws Exception {
                    return WxConfigCacheServiceImpl.this.getSubAccount(orgId);
                }
            });
        }
        catch (ExecutionException e) {
            log.error("", (Throwable)e);
            return null;
        }
        catch (Throwable e) {
            log.warn("", e);
            return null;
        }
    }

    private TXAccount getTxAccountCallableCache(final Integer orgId) {
        try {
            return (TXAccount)this.txAccountCacheFormCallable.get((Object)orgId, (Callable)new Callable<TXAccount>(){

                @Override
                public TXAccount call() throws Exception {
                    return WxConfigCacheServiceImpl.this.getTxAccout(orgId);
                }
            });
        }
        catch (ExecutionException e) {
            log.error("", (Throwable)e);
            return null;
        }
        catch (Throwable e) {
            log.warn("", e);
            return null;
        }
    }

    private Integer getOrgIdByNumberCallableCache(final Integer number) {
        try {
            return (Integer)this.orgNumberCacheMapFormCallable.get((Object)number, (Callable)new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return WxConfigCacheServiceImpl.this.getOrgAccount(number);
                }
            });
        }
        catch (ExecutionException e) {
            log.error("", (Throwable)e);
            return null;
        }
        catch (Throwable e) {
            log.warn("", e);
            return null;
        }
    }

    private Integer getOrgAccount(Integer number) {
        OrgAccount account = this.orgAccountService.getOrgAccountByNumber(Integer.valueOf(number));
        if (account == null) {
            return null;
        }
        return account.getId();
    }

    private TXAccount getTxAccout(Integer orgId) {
        return this.txAccountService.getTXAccountByOrgId(orgId, new String[0]);
    }

    private OrgSubAccount getSubAccount(Integer orgId) {
        OrgSubAccount subAcc = this.orgSubAccountDao.getByOrgId(orgId, new String[0]);
        return subAcc;
    }

    private List<WxConfig> listAllAlias() {
        List<WxConfig> allOrgAliasList = this.wxConfigService.queryAllByConfigKey(ConfigKeyEnum.wx_alias);
        return allOrgAliasList;
    }

    private Map<String, String> listAllOrgConfig(Long orgId) {
        List<WxConfig> wxconfigList = this.wxConfigService.queryAllByOrgId(orgId);
        return this.wxConfigService.wxConfigList2Map(wxconfigList, ConfigKeyEnum.getAllNames());
    }

    @Scheduled(cron="0 0/1 * * * ?")
    public void refresh() {
        List<WxConfig> allOrgAliasList = this.listAllAlias();
        HashMap tempAliasOrgMap = Maps.newHashMap();
        for (WxConfig config : allOrgAliasList) {
            tempAliasOrgMap.put(config.getValue(), config.getOrgId());
        }
        this.allAliasOrgMap = tempAliasOrgMap;
    }

    @Override
    public Long getOrgIdByAliasFromLocalCache(String name) {
        if (this.allAliasOrgMap == null) {
            this.refresh();
        }
        return this.allAliasOrgMap.get(name);
    }

    @Override
    public Map<String, String> getAllOrgConfigFromLocalCache(Long orgId) {
        return this.getWxConfigCallableCache(orgId);
    }

    @Override
    public TXAccount getTXAccountFromLocalCache(Integer orgId) {
        return this.getTxAccountCallableCache(orgId);
    }

    @Override
    public OrgSubAccount getOrgSubAccountFromLocalCache(Integer orgId) {
        return this.orgSubAccountCacheFormCallable(orgId);
    }

    @Override
    public Integer getTxOrgIdByNumberFromLocalCache(Integer orgNum) {
        return this.getOrgIdByNumberCallableCache(orgNum);
    }
}

