/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.WxCommonCounterDao;
import com.baijia.tianxiao.dal.org.po.WxCommonCounter;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.wx.api.WxCommonCounterService;
import com.baijia.tianxiao.sal.wx.model.WxCommonCounterKey;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="wxCommonCounterService")
public class WxCommonCounterServiceImpl
implements WxCommonCounterService {
    @Resource
    private WxCommonCounterDao wxCommonCounterDao;

    @Override
    public boolean create(WxCommonCounter record) {
        boolean bool = this.checkKeyAvailable(record.getMainKey(), record.getSecondaryKey());
        if (!bool) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8ba1\u6570\u5668\u7684key\u4e0d\u5408\u6cd5");
        }
        try {
            this.wxCommonCounterDao.save((Object)record, new String[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean addOne(WxCommonCounterKey commonCounterKey) {
        if (0 != this.wxCommonCounterDao.addOne(commonCounterKey.getMainKey(), commonCounterKey.getSecondaryKey())) {
            return true;
        }
        WxCommonCounter commonCounter = new WxCommonCounter();
        commonCounter.setMainKey(commonCounterKey.getMainKey());
        commonCounter.setSecondaryKey(commonCounterKey.getSecondaryKey());
        commonCounter.setValue(Long.valueOf(0L));
        this.create(commonCounter);
        return 1 == this.wxCommonCounterDao.addOne(commonCounterKey.getMainKey(), commonCounterKey.getSecondaryKey());
    }

    @Override
    public boolean subOne(WxCommonCounterKey commonCounterKey) {
        return 1 == this.wxCommonCounterDao.subOne(commonCounterKey.getMainKey(), commonCounterKey.getSecondaryKey());
    }

    @Override
    public boolean addOneForMaxValue(WxCommonCounterKey commonCounterKey, Long maxValue) {
        return 1 == this.wxCommonCounterDao.addOneForMaxValue(commonCounterKey.getMainKey(), commonCounterKey.getSecondaryKey(), maxValue);
    }

    @Override
    public boolean exist(WxCommonCounterKey commonCounterKey) {
        WxCommonCounter commonCounter = this.wxCommonCounterDao.getByKey(commonCounterKey.getMainKey(), commonCounterKey.getSecondaryKey());
        return commonCounter != null;
    }

    @Override
    public Long getCurrentCountByKey(WxCommonCounterKey commonCounterKey) {
        WxCommonCounter commonCounter = this.wxCommonCounterDao.getByKey(commonCounterKey.getMainKey(), commonCounterKey.getSecondaryKey());
        if (commonCounter == null) {
            return 0L;
        }
        return commonCounter.getValue();
    }

    @Override
    public List<WxCommonCounter> getListByKeys(String mainKey, Collection<String> secondaryKeys) {
        return this.wxCommonCounterDao.getListBySecondekeys(mainKey, secondaryKeys);
    }

    @Override
    public Map<String, Long> getMapByKeys(String mainKey, Collection<String> secondaryKeys) {
        return this.wxCommonCounterDao.getMapBySecondekeys(mainKey, secondaryKeys);
    }

    private boolean checkKeyAvailable(String mainKey, String secondaryKey) {
        return !StringUtils.isBlank((CharSequence)mainKey) && !StringUtils.isBlank((CharSequence)secondaryKey);
    }

    @Override
    public Map<String, Long> getListByMainKey(String mainKey) {
        HashMap map = Maps.newHashMap();
        List list = this.wxCommonCounterDao.getListByMainKey(mainKey);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (WxCommonCounter counter : list) {
                map.put(counter.getSecondaryKey(), counter.getValue());
            }
        }
        return map;
    }
}

