/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.dao.WxCloudSourceDao;
import com.baijia.tianxiao.dal.org.dto.WxCloudSourceDto;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.WxCloudSource;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.cloud.api.VideoApi;
import com.baijia.tianxiao.sal.cloud.model.request.VideoUploadUrlCreate;
import com.baijia.tianxiao.sal.cloud.model.response.DefaultApiResult;
import com.baijia.tianxiao.sal.wx.api.WxCloudSourceService;
import com.baijia.tianxiao.sal.wx.enums.WxErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="wxCloudSourceService")
public class WxCloudSourceServiceImpl
implements WxCloudSourceService {
    private static final Logger log = LoggerFactory.getLogger(WxCloudSourceServiceImpl.class);
    @Resource
    private WxCloudSourceDao wxCloudSourceDao;
    @Resource
    private VideoApi videoApi;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private TXCascadeCredentialDao txCascadeCredentialDao;

    @Override
    public void create(WxCloudSource wxCloudSource) {
        this.wxCloudSourceDao.save((Object)wxCloudSource, new String[0]);
    }

    @Override
    public boolean updateById(WxCloudSource wxCloudSource) {
        return 1 == this.wxCloudSourceDao.update((Object)wxCloudSource, new String[0]);
    }

    @Override
    public boolean deleteById(Long orgId, Long id) {
        HashMap condition = Maps.newHashMap();
        condition.put("id", id);
        condition.put("orgId", orgId);
        WxCloudSource cloudSource = this.wxCloudSourceDao.getByCondition((Map)condition);
        if (cloudSource == null) {
            return false;
        }
        DefaultApiResult result = this.videoApi.delete(cloudSource.getCloudId());
        if (result.getCode() != 5002 && result.getCode() != 0) {
            log.warn("videoApi.getUploadUrl fail ,video_id={},result ={}", (Object)cloudSource.getCloudId(), (Object)result);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8d44\u6e90\u5220\u9664\u5f02\u5e38");
        }
        HashMap updateCondtion = Maps.newHashMap();
        updateCondtion.put("id", id);
        updateCondtion.put("orgId", orgId);
        updateCondtion.put("delStatus", 1);
        this.wxCloudSourceDao.update((Map)updateCondtion, new String[]{"delStatus"});
        return true;
    }

    @Override
    public boolean updateStatusAndSize(WxCloudSource wxCloudSource) {
        HashMap updateCondition = Maps.newHashMap();
        updateCondition.put("id", wxCloudSource.getId());
        updateCondition.put("orgId", wxCloudSource.getOrgId());
        updateCondition.put("status", wxCloudSource.getStatus());
        updateCondition.put("size", wxCloudSource.getSize());
        return 1 == this.wxCloudSourceDao.update((Map)updateCondition, new String[]{"status", "size"});
    }

    @Override
    public boolean updateCustomInfo(WxCloudSource wxCloudSource) {
        return 1 == this.wxCloudSourceDao.update((Object)wxCloudSource, new String[]{"name", "tags", "info"});
    }

    @Override
    public Map<String, Object> createVideoSourceUploadUrl(Long orgId, Integer operatorId, String name, String tags, String info) {
        WxCloudSource source = new WxCloudSource();
        source.setOrgId(orgId);
        source.setName(name);
        source.setTags("#" + tags + "#");
        source.setInfo(info);
        source.setIsForbidden(Integer.valueOf(0));
        source.setBizType(Integer.valueOf(1));
        source.setStatus(Integer.valueOf(1));
        source.setVisible(Integer.valueOf(0));
        source.setDelStatus(Integer.valueOf(0));
        source.setCreateUserId(operatorId);
        this.wxCloudSourceDao.save((Object)source, new String[0]);
        VideoUploadUrlCreate videoUpload = new VideoUploadUrlCreate();
        videoUpload.setFile_name(name);
        DefaultApiResult result = this.videoApi.getUploadUrl(videoUpload);
        if (result.getCode() != 0) {
            log.warn("videoApi.getUploadUrl fail ,params={},result ={}", (Object)videoUpload, (Object)result);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u83b7\u53d6\u6587\u4ef6\u4e0a\u4f20\u5730\u5740\u5f02\u5e38");
        }
        String videoId = result.getData().get("video_id").toString();
        WxCloudSource updateSource = new WxCloudSource();
        updateSource.setId(source.getId());
        updateSource.setCloudId(Long.valueOf(videoId));
        this.updateById(updateSource);
        HashMap data = Maps.newHashMap();
        data.put("upload_url", result.getData().get("upload_url").toString());
        data.put("id", source.getId());
        return data;
    }

    @Override
    public WxCloudSource getByCloudId(Integer bizType, Long cloudId) {
        HashMap condition = Maps.newHashMap();
        condition.put("bizType", bizType);
        condition.put("cloudId", cloudId);
        List list = this.wxCloudSourceDao.queryByCondition((Map)condition, null, new String[0]);
        if (list.size() == 0) {
            return null;
        }
        return (WxCloudSource)list.get(0);
    }

    @Override
    public boolean updateStatusAndSizeByCloudId(WxCloudSource wxCloudSource) {
        HashMap updateCondition = Maps.newHashMap();
        updateCondition.put("cloudId", wxCloudSource.getCloudId());
        updateCondition.put("bizType", wxCloudSource.getBizType());
        updateCondition.put("status", wxCloudSource.getStatus());
        updateCondition.put("size", wxCloudSource.getSize());
        return 1 == this.wxCloudSourceDao.update((Map)updateCondition, new String[]{"status", "size"});
    }

    @Override
    public Map<String, Object> getResumeVideoSourceUploadUrl(Long orgId, Long id) {
        WxCloudSource wxCloudSource = this.getById(orgId, id);
        if (wxCloudSource == null || wxCloudSource.getCloudId() == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u83b7\u53d6\u6587\u4ef6\u4e0a\u4f20\u5730\u5740\u5f02\u5e38");
        }
        DefaultApiResult result = this.videoApi.getResumeUploadUrl(wxCloudSource.getCloudId());
        if (result.getCode() != 0) {
            log.warn("videoApi.getUploadUrl fail ,params={},result ={}", (Object)wxCloudSource.getCloudId(), (Object)result);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u83b7\u53d6\u6587\u4ef6\u4e0a\u4f20\u5730\u5740\u5f02\u5e38");
        }
        String upload_size = result.getData().get("upload_size").toString();
        WxCloudSource updateSource = new WxCloudSource();
        updateSource.setId(wxCloudSource.getId());
        updateSource.setSize(Long.valueOf(upload_size));
        this.updateById(updateSource);
        return result.getData();
    }

    @Override
    public WxCloudSource getById(Long orgId, Long id) {
        HashMap condition = Maps.newHashMap();
        condition.put("id", id);
        condition.put("orgId", orgId);
        List list = this.wxCloudSourceDao.queryByCondition((Map)condition, null, new String[0]);
        if (list.size() == 0) {
            return null;
        }
        return (WxCloudSource)list.get(0);
    }

    @Override
    public List<WxCloudSource> listByDtoCondition(WxCloudSourceDto queryDto, PageDto pageDto) {
        if (StringUtils.isNotBlank((CharSequence)queryDto.getKey())) {
            queryDto.setNameKey(queryDto.getKey());
            queryDto.setTag(queryDto.getKey());
        }
        if (queryDto.getEndDate() != null) {
            Date realEndDate = DateUtil.addDay((Date)queryDto.getEndDate(), (int)1);
            queryDto.setEndDate(realEndDate);
        }
        List list = this.wxCloudSourceDao.listByDtoConditon(queryDto, pageDto);
        this.buildCreateUserName(queryDto.getOrgId(), list);
        return list;
    }

    @Override
    public boolean updateCloudInfoByCloudId(WxCloudSource orgCloudSource) {
        WxCloudSource exitCloudSource = this.getByCloudId(orgCloudSource.getBizType(), orgCloudSource.getCloudId());
        if (exitCloudSource == null) {
            throw new BussinessException((UniverseErrorCode)WxErrorCode.UNKNOW, "\u89c6\u9891id\u4e0d\u5b58\u5728");
        }
        orgCloudSource.setId(exitCloudSource.getId());
        int cloudStatus = orgCloudSource.getCloudStatus();
        if (cloudStatus == 20) {
            orgCloudSource.setStatus(Integer.valueOf(2));
        } else if (cloudStatus == 30) {
            orgCloudSource.setStatus(Integer.valueOf(4));
        } else if (cloudStatus == 100) {
            orgCloudSource.setStatus(Integer.valueOf(3));
        }
        orgCloudSource.setVisible(Integer.valueOf(1));
        return 1 == this.wxCloudSourceDao.update((Object)orgCloudSource, Boolean.valueOf(true), new String[]{"status", "visible", "cloudStatus", "size", "length", "prefaceUrl"});
    }

    @Override
    public String getVideoSign(Long orgId, Long id) {
        WxCloudSource cloudSource = this.getById(orgId, id);
        if (cloudSource.getBizType() == 2) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u76f4\u64ad\u56de\u653e\u4e0d\u80fd\u5728\u8d44\u6e90\u7ba1\u7406\u4e2d\u64ad\u653e\uff0c\u8bf7\u5728\u76f4\u64ad\u56de\u653e\u4e2d\u67e5\u770b");
        }
        Long cloudId = cloudSource.getCloudId();
        DefaultApiResult result = this.videoApi.videoPlaySign(cloudId, 180L);
        if (result.getCode() != 0) {
            log.warn("videoApi.getUploadUrl fail ,params={},result ={}", (Object)cloudId, (Object)result);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u83b7\u53d6\u6587\u4ef6\u4e0a\u4f20\u5730\u5740\u5f02\u5e38");
        }
        return result.getData().get("token").toString();
    }

    @Override
    public boolean updateForbidden(Long orgId, Long id, Integer isForbidden) {
        HashMap condition = Maps.newHashMap();
        condition.put("id", id);
        condition.put("orgId", orgId);
        condition.put("isForbidden", isForbidden);
        return 1 == this.wxCloudSourceDao.update((Map)condition, new String[]{"isForbidden"});
    }

    @Override
    public boolean updateVisible(Long orgId, Long id, Integer visible) {
        HashMap condition = Maps.newHashMap();
        condition.put("id", id);
        condition.put("orgId", orgId);
        condition.put("status", 2);
        condition.put("visible", visible);
        return 1 == this.wxCloudSourceDao.update((Map)condition, new String[]{"status", "visible"});
    }

    @Override
    public Long getOrgTotalSize(Long orgId) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        Long orgTotalSize = this.wxCloudSourceDao.sumByCondition((Map)condition);
        return orgTotalSize;
    }

    @Override
    public Map<Long, WxCloudSource> getMapByIds(Long orgId, Collection<Long> ids) {
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isEmpty(ids)) {
            return map;
        }
        List list = this.wxCloudSourceDao.getByIds(ids, new String[0]);
        for (WxCloudSource cloudSource : list) {
            map.put(cloudSource.getId(), cloudSource);
        }
        return map;
    }

    private void buildCreateUserName(Long orgId, List<WxCloudSource> list) {
        HashSet ids = Sets.newHashSet();
        for (WxCloudSource wxCloudSource : list) {
            Integer userId = wxCloudSource.getCreateUserId();
            if (userId == null) continue;
            ids.add(userId);
        }
        Map<Integer, String> map = this.cacheOperator(orgId, ids);
        for (WxCloudSource wxCloudSource : list) {
            Integer userId = wxCloudSource.getCreateUserId();
            if (userId == null) continue;
            String name = map.get(userId);
            wxCloudSource.setCreateUserName(name);
        }
    }

    private Map<Integer, String> cacheOperator(Long orgId, Collection<Integer> ids) {
        Map map;
        HashMap<Integer, String> cache = new HashMap<Integer, String>();
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[]{"id", "contacts"});
        if (orgInfo == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        cache.put(0, orgInfo.getContacts());
        if (CollectionUtils.isNotEmpty(ids) && (map = this.txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds(ids)) != null && map.size() > 0) {
            for (Long id : map.keySet()) {
                cache.put(id.intValue(), (String)map.get(id));
            }
        }
        return cache;
    }
}

