/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.constants.CategoryType;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.WxCategoryDao;
import com.baijia.tianxiao.dal.org.po.WxCategory;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.wx.api.WxCategoryService;
import com.baijia.tianxiao.sal.wx.enums.WxErrorCode;
import com.baijia.tianxiao.sal.wx.model.WxCategoryDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WxCategoryServiceImpl
implements WxCategoryService {
    @Autowired
    private WxCategoryDao wxCategoryDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(Long orgId, WxCategoryDto param) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId \u9519\u8bef");
        Preconditions.checkArgument((param != null && StringUtils.isNotBlank((CharSequence)param.getName()) ? 1 : 0) != 0, (Object)"\u5206\u7c7b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((CategoryType.getBycode((Integer)param.getType()) != null ? 1 : 0) != 0, (Object)"\u7c7b\u578b\u53c2\u6570\u9519\u8bef");
        int count = this.wxCategoryDao.checkExist(orgId, param.getType(), param.getName());
        if (count > 0) {
            throw new BussinessException((UniverseErrorCode)WxErrorCode.CATEGORY_NAME_EXIST);
        }
        List list = this.wxCategoryDao.getListByParam(orgId, param.getType(), null);
        int size = CollectionUtils.isNotEmpty((Collection)list) ? list.size() : 0;
        WxCategory po = new WxCategory();
        po.setName(param.getName());
        po.setDisplayOrder(Integer.valueOf(size + 1));
        po.setOrgId(orgId);
        po.setType(param.getType());
        po.setIsDel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        po.setCreateTime(new Date());
        po.setUpdateTime(new Date());
        this.wxCategoryDao.save((Object)po, new String[0]);
        return po.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void delete(Long orgId, Long id) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId \u9519\u8bef");
        Preconditions.checkArgument((id != null && id > 0L ? 1 : 0) != 0, (Object)"\u5206\u7c7bid\u9519\u8bef");
        WxCategory po = (WxCategory)this.wxCategoryDao.getById((Serializable)id, new String[0]);
        if (po == null || po.getIsDel().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5206\u7c7b\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (po.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5206\u7c7b\u4e0d\u5c5e\u4e8e\u8be5\u673a\u6784");
        }
        po.setIsDel(Integer.valueOf(DeleteStatus.DELETED.getValue()));
        po.setUpdateTime(new Date());
        this.wxCategoryDao.update((Object)po, new String[]{"isDel", "updateTime"});
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void mod(Long orgId, Long id, String name) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId \u9519\u8bef");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)name) && id != null && id > 0L ? 1 : 0) != 0, (Object)"\u5206\u7c7b\u53c2\u6570\u9519\u8bef");
        WxCategory po = (WxCategory)this.wxCategoryDao.getById((Serializable)id, new String[0]);
        if (po == null || po.getIsDel().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5206\u7c7b\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (po.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5206\u7c7b\u4e0d\u5c5e\u4e8e\u8be5\u673a\u6784");
        }
        int count = this.wxCategoryDao.checkExist(orgId, po.getType(), name);
        if (count > 0 && !po.getName().equals(name)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5206\u7c7b\u540d\u5df2\u5b58\u5728");
        }
        if (!po.getName().equals(name)) {
            po.setName(name);
            po.setUpdateTime(new Date());
            this.wxCategoryDao.update((Object)po, new String[]{"name", "updateTime"});
        }
    }

    @Override
    public List<WxCategoryDto> getCategoryList(Long orgId, Integer type) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId \u9519\u8bef");
        Preconditions.checkArgument((CategoryType.getBycode((Integer)type) != null ? 1 : 0) != 0, (Object)"\u5206\u7c7b\u7c7b\u578b\u9519\u8bef");
        ArrayList<WxCategoryDto> data = new ArrayList<WxCategoryDto>();
        List list = this.wxCategoryDao.getListByParam(orgId, type, null);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (WxCategory po : list) {
                WxCategoryDto dto = new WxCategoryDto();
                dto.setId(po.getId());
                dto.setName(po.getName());
                dto.setType(type);
                data.add(dto);
            }
        }
        return data;
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void order(Long orgId, Integer type, List<Long> ids) {
        List list;
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId \u9519\u8bef");
        Preconditions.checkArgument((CategoryType.getBycode((Integer)type) != null ? 1 : 0) != 0, (Object)"\u5206\u7c7b\u7c7b\u578b\u9519\u8bef");
        if (CollectionUtils.isNotEmpty(ids) && CollectionUtils.isNotEmpty((Collection)(list = this.wxCategoryDao.getListByParam(orgId, type, ids)))) {
            Map map = BaseUtils.listToMap((List)list, (String)"id");
            int size = list.size();
            for (Long id : ids) {
                WxCategory po = (WxCategory)map.get(id);
                if (po == null) continue;
                po.setDisplayOrder(Integer.valueOf(size--));
                po.setUpdateTime(new Date());
                this.wxCategoryDao.update((Object)po, new String[]{"displayOrder", "updateTime"});
            }
        }
    }
}

