/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.WxBannerDao;
import com.baijia.tianxiao.dal.org.po.WxBanner;
import com.baijia.tianxiao.sal.wx.api.WxBannerService;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.beust.jcommander.internal.Maps;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="wxBannerService")
public class WxBannerServiceImpl
implements WxBannerService {
    @Resource
    private WxBannerDao wxBannerDao;

    @Override
    public void save(WxBanner orgBanner) {
        Preconditions.checkArgument((orgBanner.getPic() != null && orgBanner.getUrl() != null ? 1 : 0) != 0, (Object)"banner\u4fe1\u606f\u4e0d\u5168");
        orgBanner.setSortNum(Integer.valueOf(0));
        orgBanner.setStatus(Integer.valueOf(0));
        this.wxBannerDao.save((Object)orgBanner, new String[0]);
    }

    @Override
    public void updateBannerInfo(WxBanner orgBanner) {
        this.wxBannerDao.update((Object)orgBanner, new String[0]);
    }

    @Override
    public void updateStatusAndSort(WxBanner orgBanner) {
        this.wxBannerDao.update((Object)orgBanner, new String[]{"status", "sort"});
    }

    @Override
    public List<WxBanner> listAllByOrgIdAndStatus(Long orgId, Integer status) {
        Map condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        if (status != null) {
            condition.put("status", status);
        }
        return this.wxBannerDao.queryByCondition(condition, Order.asc((String[])new String[]{"sortNum"}), null, new String[0]);
    }

    @Override
    public void deleteBanner(Long orgId, Long bannerId) {
        Map condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("id", bannerId);
        this.wxBannerDao.delByCondition(condition);
    }

    @Override
    public void batchSort(Long orgId, List<Long> sortIds) {
        Map condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        List list = this.wxBannerDao.queryByCondition(condition, null, new String[0]);
        Map map = Maps.newHashMap();
        for (WxBanner banner : list) {
            map.put(banner.getId(), banner);
        }
        int sortNo = 0;
        for (Long id : sortIds) {
            WxBanner banner = (WxBanner)map.get(id);
            if (banner == null) continue;
            banner.setSortNum(Integer.valueOf(++sortNo));
            this.wxBannerDao.update((Object)banner, new String[]{"sortNum"});
        }
    }
}

