/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.commons.cache.CacheUtil;
import com.baijia.tianxiao.sal.wx.api.ValidateCodeService;
import com.baijia.tianxiao.sal.wx.model.ValidateCodeSend;
import com.baijia.tianxiao.sal.wx.result.ValidateCodeSendResult;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="validateCodeSendService")
public class ValidateCodeServiceImpl
implements ValidateCodeService {
    private static final Logger log = LoggerFactory.getLogger(ValidateCodeServiceImpl.class);
    private static final String INNER_CHECKCODE = "wx8888";
    String ValidateCodePrefix = "tx_wx_ValidateCode_";

    @Override
    public ValidateCodeSendResult createAndSendCheckCode(ValidateCodeSend validateCodeSend, boolean needSendSms) {
        ValidateCodeSendResult result = new ValidateCodeSendResult();
        try {
            String checkCode = this.getCheckCode(validateCodeSend);
            log.debug("\u751f\u6210\u7684\u6821\u9a8c\u7801\uff1a" + checkCode);
            if (needSendSms) {
                String content = validateCodeSend.getContentTemplate();
                content = content.replaceFirst("\\$\\{checkCode\\}", checkCode);
                String subject = validateCodeSend.getBizType().getSubject();
                this.doSend(validateCodeSend.getSendType(), validateCodeSend.getSendIdentity(), content, subject);
            }
            String bizName = this.getBizName(validateCodeSend);
            this.saveCache(validateCodeSend.getSendIdentity(), bizName, checkCode, validateCodeSend.getEffectMinute());
            result.setSuccess(true);
            result.setCheckCode(checkCode);
            return result;
        }
        catch (Exception e) {
            result.setMsg(ValidateCodeSendResult.ResultCodeEnum.System_exception.getDesc());
            log.error("ValidateCodeSendService.createAndSendCheckCode  excute exception", (Throwable)e);
            return result;
        }
    }

    @Override
    public ValidateCodeSendResult check(ValidateCodeSend validateCodeSend, String code) {
        ValidateCodeSendResult result = new ValidateCodeSendResult();
        String bizName = this.getBizName(validateCodeSend);
        if (StringUtils.equals((CharSequence)code, (CharSequence)INNER_CHECKCODE)) {
            this.removeCache(validateCodeSend.getSendIdentity(), bizName);
            result.setSuccess(true);
            return result;
        }
        Object o = this.getCache(validateCodeSend.getSendIdentity(), bizName);
        if (o == null) {
            result.setMsg(ValidateCodeSendResult.ResultCodeEnum.ExpiredOrNoExist.getDesc());
            return result;
        }
        String cacheCode = (String)o;
        if (!StringUtils.equals((CharSequence)cacheCode, (CharSequence)code)) {
            result.setMsg(ValidateCodeSendResult.ResultCodeEnum.Code_match_error.getDesc());
            return result;
        }
        result.setSuccess(true);
        this.removeCache(validateCodeSend.getSendIdentity(), bizName);
        return result;
    }

    private String getBizName(ValidateCodeSend validateCodeSend) {
        ValidateCodeSend.BizTypeEnum bizType = validateCodeSend.getBizType();
        if (bizType == null) {
            bizType = ValidateCodeSend.BizTypeEnum.Default;
        }
        String bizName = bizType == ValidateCodeSend.BizTypeEnum.Other ? validateCodeSend.getOtherBizName() : bizType.name();
        return bizName;
    }

    private String getCheckCode(ValidateCodeSend validateCodeSend) {
        ValidateCodeSend.SendTypeEnum sendTypeEnum = validateCodeSend.getSendType();
        String code = sendTypeEnum == ValidateCodeSend.SendTypeEnum.SMS ? this.createMobileCode() : (sendTypeEnum == ValidateCodeSend.SendTypeEnum.EMAIL ? this.createEmailCode() : this.createMobileCode());
        return code;
    }

    private void saveCache(String identity, String bizTypeName, String checkCode, int effectMinute) {
        CacheUtil.set((String)(this.ValidateCodePrefix + bizTypeName + "_" + identity), (Object)checkCode, (long)(effectMinute * 60));
    }

    private Object getCache(String identity, String bizTypeName) {
        return CacheUtil.getValue((String)(this.ValidateCodePrefix + bizTypeName + "_" + identity));
    }

    private void removeCache(String identity, String bizTypeName) {
        CacheUtil.delete((String)(this.ValidateCodePrefix + bizTypeName + "_" + identity));
    }

    private void doSend(ValidateCodeSend.SendTypeEnum sendTypeEnum, String identity, String content, String subject) {
        if (sendTypeEnum == ValidateCodeSend.SendTypeEnum.SMS) {
            this.sendSMS(identity, content);
        } else {
            this.sendEmail(identity, content, subject);
        }
    }

    private void sendSMS(String mobile, String content) {
        log.info("sms send,mobile=" + mobile + "content=" + content);
    }

    private void sendEmail(String email, String content, String subject) {
    }

    private String createMobileCode() {
        int number = new Random().nextInt(1000000);
        String str1 = String.format("%06d", number);
        return str1;
    }

    private String createEmailCode() {
        int number = new Random().nextInt(1000000);
        String str1 = String.format("%06d", number);
        return str1;
    }

    public static void main(String[] args) {
    }

    @Override
    public String createExtralCacheCode(String identity) {
        String randomNumber = this.createRandomNumber();
        CacheUtil.set((String)identity, (Object)randomNumber, (long)120L);
        return randomNumber;
    }

    @Override
    public boolean checkExtralCacheCode(String identity, String code) {
        Object o = CacheUtil.getValue((String)identity);
        if (o != null) {
            CacheUtil.delete((String)identity);
            return true;
        }
        return false;
    }

    private String createRandomNumber() {
        int number = new Random().nextInt(1000000);
        String str1 = String.format("%06d", number);
        return str1;
    }
}

