/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.commons.cache.CacheUtil;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.msg.service.CommonSmsService;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.student.util.OrgStudentUtil;
import com.baijia.tianxiao.sal.wx.api.RegisterService;
import com.baijia.tianxiao.sal.wx.api.ValidateCodeService;
import com.baijia.tianxiao.sal.wx.api.WxOrgStudentService;
import com.baijia.tianxiao.sal.wx.model.CodeSendTimesForCache;
import com.baijia.tianxiao.sal.wx.model.ValidateCodeSend;
import com.baijia.tianxiao.sal.wx.result.CommonDataResult;
import com.baijia.tianxiao.sal.wx.result.ValidateCodeSendResult;
import com.baijia.tianxiao.sal.wx.util.ValidateUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.google.common.base.Preconditions;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="registerService")
public class RegisterServiceImpl
implements RegisterService {
    private static final Logger log = LoggerFactory.getLogger(RegisterServiceImpl.class);
    @Resource
    private CommonSmsService smsService;
    @Resource
    private ValidateCodeService validateCodeSendService;
    @Resource
    private WxOrgStudentService wxOrgStudentService;
    @Resource
    private OrgAccountService orgAccountService;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgInfoDao orgInfoDao;

    @Override
    public CommonDataResult<?> sendSMSCode(Long orgId, String mobileNum, String key, ValidateCodeSend.BizTypeEnum type, int codeType) {
        CommonDataResult result = new CommonDataResult(true);
        if (!ValidateUtil.isMobileAllowed(mobileNum)) {
            result.setSuccess(false);
            result.setMsg("\u624b\u673a\u53f7\u4e0d\u5408\u6cd5");
            return result;
        }
        OrgAccount account = this.orgAccountService.getOrgAccountById(Integer.valueOf(orgId.intValue()));
        if (account == null) {
            result.setSuccess(false);
            result.setMsg("\u65e0\u6548\u673a\u6784");
            return result;
        }
        CommonDataResult<?> checkResult = this.wxOrgStudentService.checkMobileExist(orgId, mobileNum, "", codeType);
        if (!checkResult.isSuccess()) {
            result.setSuccess(false);
            result.setMsg(checkResult.getMsg());
            return result;
        }
        Date now = new Date();
        CodeSendTimesForCache codeSendTimes = (CodeSendTimesForCache)CacheUtil.getValue((String)(key = key + orgId + "_" + mobileNum));
        if (codeSendTimes == null || !DateUtil.isSameDay((Date)codeSendTimes.getLastSendTime(), (Date)now)) {
            codeSendTimes = new CodeSendTimesForCache();
            codeSendTimes.setIdentifyingCode(mobileNum);
            codeSendTimes.setSendTimes(0);
            codeSendTimes.setLastSendTime(now);
            codeSendTimes.setCreateTime(now);
        } else if (10 > codeSendTimes.getSendTimes()) {
            codeSendTimes.setSendTimes(codeSendTimes.getSendTimes() + 1);
            codeSendTimes.setLastSendTime(Calendar.getInstance().getTime());
        } else {
            result.setSuccess(false);
            result.setMsg("\u6bcf\u5929\u53ea\u80fd\u53d1\u900110\u6b21");
            return result;
        }
        ValidateCodeSend validateCodeSend = new ValidateCodeSend();
        validateCodeSend.setSendIdentity(mobileNum);
        validateCodeSend.setSendType(ValidateCodeSend.SendTypeEnum.SMS);
        validateCodeSend.setBizType(type);
        validateCodeSend.setEffectMinute(15);
        ValidateCodeSendResult checkCodeResult = this.validateCodeSendService.createAndSendCheckCode(validateCodeSend, false);
        if (checkCodeResult.isSuccess()) {
            String checkCode = checkCodeResult.getCheckCode();
            String smsContent = String.format(type.getContent(), account.getUserName());
            smsContent = smsContent.replaceFirst("\\$\\{checkCode\\}", checkCode);
            this.smsService.sendSms(orgId, Integer.valueOf(UserRoleEnum.ORG.getCode()), Long.valueOf(mobileNum), Integer.valueOf(UserRoleEnum.STUDENT.getCode()), mobileNum, SmsMessageType.CODE, smsContent);
            Date todayEndTime = DateUtil.getEndOfDay((Date)now);
            Long expire = (todayEndTime.getTime() - now.getTime()) / 1000L;
            if (expire < 60L) {
                expire = 60L;
            }
            CacheUtil.set((String)key, (Object)codeSendTimes, (long)expire);
            return result;
        }
        result.setSuccess(false);
        return result;
    }

    @Override
    public CommonDataResult<?> checkSMSCode(Long orgId, String mobilephone, String code, ValidateCodeSend.BizTypeEnum bizType) {
        CommonDataResult result = new CommonDataResult(true);
        ValidateCodeSend validateCodeSend = new ValidateCodeSend();
        validateCodeSend.setSendIdentity(mobilephone);
        validateCodeSend.setBizType(bizType);
        ValidateCodeSendResult valResult = this.validateCodeSendService.check(validateCodeSend, code);
        if (!valResult.isSuccess()) {
            result.setSuccess(false);
            result.setMsg(valResult.getMsg());
        } else {
            result.setSuccess(true);
        }
        return result;
    }

    @Override
    public CommonDataResult<OrgStudent> createStudentForWxRegiester(Long orgId, String mobile, String nickName, String inputPwd) {
        CommonDataResult<OrgStudent> result = new CommonDataResult<OrgStudent>(false);
        if (!ValidateUtil.isPwAllowed(inputPwd)) {
            result.setMsg("\u5bc6\u7801\u4e0d\u5408\u6cd5\uff0c\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\uff0c6\uff5e18\u4f4d\u5bc6\u7801\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u6570\u5b57\u548c\u4e0b\u5212\u7ebf");
            return result;
        }
        int codeType = ValidateCodeSend.SendSMSTypeEnum.REGISTER.getIndex();
        CommonDataResult<?> checkMobileResult = this.wxOrgStudentService.checkMobileExist(orgId, mobile, "", codeType);
        if (!checkMobileResult.isSuccess()) {
            result.setMsg(checkMobileResult.getMsg());
            return result;
        }
        Map userInfoMap = OrgStudentUtil.getUserIdAndNumber((String)nickName);
        Long userId = (Long)userInfoMap.get("id");
        OrgStudent orgStudent = new OrgStudent();
        orgStudent.setOrgId(orgId);
        orgStudent.setUserId(userId);
        orgStudent.setMobile(mobile);
        orgStudent.setName(nickName);
        orgStudent.setNickName(nickName);
        orgStudent.setDelStatus(Integer.valueOf(0));
        orgStudent.setPwd(PasswordUtil.createHash((String)inputPwd));
        this.orgStudentDao.save((Object)orgStudent, new String[0]);
        result.setSuccess(true);
        result.setData(orgStudent);
        return result;
    }

    @Override
    public CommonDataResult<OrgStudent> checkAndResetStudentPwd(Long orgId, String mobile, String inputPwd, String inputPwd2) {
        CommonDataResult<OrgStudent> result = new CommonDataResult<OrgStudent>(false);
        if (!ValidateUtil.isPwAllowed(inputPwd)) {
            result.setMsg("\u5bc6\u7801\u4e0d\u5408\u6cd5\uff0c\u5fc5\u987b\u4ee5\u5b57\u6bcd\u548c\u6570\u5b57\u7684\u7ec4\u5408\uff0c\u957f\u5ea68\u523016\u4f4d");
            return result;
        }
        if (!StringUtils.equals((CharSequence)inputPwd, (CharSequence)inputPwd2)) {
            result.setMsg("\u4e24\u6b21\u5bc6\u7801\u4e0d\u4e00\u6837");
            return result;
        }
        int codeType = ValidateCodeSend.SendSMSTypeEnum.FIND_PASSWORD.getIndex();
        OrgStudent orgStudent = this.orgStudentDao.getLastStudentByMobileOrParentMobile(orgId, mobile, new String[0]);
        orgStudent.setPwd(PasswordUtil.createHash((String)inputPwd));
        this.orgStudentDao.update((Object)orgStudent, new String[]{"pwd"});
        result.setSuccess(true);
        result.setData(orgStudent);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sendStudentPwd(Long orgId, Long userId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((userId != null && userId > 0L ? 1 : 0) != 0, (Object)"userId is illegal");
        String orgName = this.orgInfoDao.getOrgShortNameByOrgId(Integer.valueOf(orgId.intValue()));
        OrgStudent orgStudent = this.orgStudentDao.getStudent(orgId, userId, Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[0]);
        if (orgStudent == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751f\u672a\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        String password = ValidateUtil.getRandom(8, false, true);
        orgStudent.setPwd(PasswordUtil.createHash((String)password));
        orgStudent.setUpdateTime(new Date());
        this.orgStudentDao.updateWithDefaultVal((Object)orgStudent, new String[]{"pwd", "updateTime"});
        String smsContent = String.format(ValidateCodeSend.BizTypeEnum.SmsRandomPassword.getContent(), orgName, orgStudent.getMobile(), password);
        boolean isSuccess = this.smsService.sendSms(orgId, Integer.valueOf(UserRoleEnum.ORG.getCode()), Long.valueOf(orgStudent.getMobile()), Integer.valueOf(UserRoleEnum.STUDENT.getCode()), orgStudent.getMobile(), SmsMessageType.CODE, smsContent);
        return isSuccess;
    }
}

