/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.cloud.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baijia.tianxiao.sal.cloud.api.BaseCloudApi;
import com.baijia.tianxiao.sal.cloud.model.request.VideoUploadUrlCreate;
import com.baijia.tianxiao.sal.cloud.model.response.DefaultApiResult;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="videoApi")
public class VideoApi
extends BaseCloudApi {
    private static final Logger log = LoggerFactory.getLogger(VideoApi.class);
    private String videoApiBaseUrl = null;
    private String videoDataApiBaseUrl = null;

    @PostConstruct
    public void init() {
        try {
            String baseDomain = PropertiesReader.getValue((String)"cloud", (String)"baijiacloud.domain");
            this.videoApiBaseUrl = baseDomain + "/openapi/video/";
            this.videoDataApiBaseUrl = baseDomain + "/openapi/video_data/";
        }
        catch (MissingResourceException e) {
            log.info("can not init VideoApi cause by :{} ", (Throwable)e);
        }
    }

    public DefaultApiResult getUploadUrl(VideoUploadUrlCreate videoUpload) {
        HashMap params = Maps.newHashMap();
        this.init(params);
        params.put("file_name", videoUpload.getFile_name());
        params.put("type", videoUpload.getType());
        params.put("definition", videoUpload.getDefinition());
        params.put("priority", videoUpload.getPriority().toString());
        this.buidlSign(params);
        String str = HttpClientUtils.doPost((String)(this.videoApiBaseUrl + "getUploadUrl"), (Map)params);
        return (DefaultApiResult)JSON.parseObject((String)str, DefaultApiResult.class);
    }

    public DefaultApiResult getResumeUploadUrl(Long videoId) {
        HashMap params = Maps.newHashMap();
        this.init(params);
        params.put("video_id", videoId.toString());
        this.buidlSign(params);
        String str = HttpClientUtils.doPost((String)(this.videoApiBaseUrl + "getResumeUploadUrl"), (Map)params);
        return (DefaultApiResult)JSON.parseObject((String)str, DefaultApiResult.class);
    }

    public DefaultApiResult getInfo(Long videoId) {
        HashMap params = Maps.newHashMap();
        this.initPartnerId(params);
        params.put("video_id", videoId.toString());
        this.buidlSign(params);
        String str = HttpClientUtils.doPost((String)(this.videoApiBaseUrl + "getInfo"), (Map)params);
        return (DefaultApiResult)JSON.parseObject((String)str, DefaultApiResult.class);
    }

    public DefaultApiResult update(Long videoId, String name) {
        HashMap params = Maps.newHashMap();
        this.initPartnerId(params);
        params.put("video_id", videoId.toString());
        params.put("name", name);
        this.buidlSign(params);
        String str = HttpClientUtils.doPost((String)(this.videoApiBaseUrl + "update"), (Map)params);
        return (DefaultApiResult)JSON.parseObject((String)str, DefaultApiResult.class);
    }

    public DefaultApiResult delete(Long videoId) {
        HashMap params = Maps.newHashMap();
        this.initPartnerId(params);
        params.put("video_id", videoId.toString());
        params.put("timestamp", String.valueOf(DateUtil.currentUnixTimestamp()));
        this.buidlSign(params);
        String str = HttpClientUtils.doPost((String)(this.videoApiBaseUrl + "delete"), (Map)params);
        return (DefaultApiResult)JSON.parseObject((String)str, DefaultApiResult.class);
    }

    public DefaultApiResult videoPlaySign(Long videoId, Long expires_in) {
        HashMap params = Maps.newHashMap();
        this.initPartnerId(params);
        params.put("video_id", videoId.toString());
        params.put("expires_in", expires_in.toString());
        params.put("timestamp", String.valueOf(DateUtil.currentUnixTimestamp()));
        this.buidlSign(params);
        String str = HttpClientUtils.doPost((String)(this.videoApiBaseUrl + "getPlayerToken"), (Map)params);
        return (DefaultApiResult)JSON.parseObject((String)str, DefaultApiResult.class);
    }

    public JSONObject batchQueryVideoInfo(int page, int pageSize, String dateStr) {
        HashMap params = Maps.newHashMap();
        this.initPartnerId(params);
        params.put("page", String.valueOf(page));
        params.put("page_size", String.valueOf(pageSize));
        params.put("date", dateStr);
        params.put("timestamp", String.valueOf(DateUtil.currentUnixTimestamp()));
        this.buidlSign(params);
        String str = HttpClientUtils.doPost((String)(this.videoDataApiBaseUrl + "exportPartnerVideoStatDay"), (Map)params);
        return JSON.parseObject((String)str);
    }
}

