/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.cloud.api;

import com.alibaba.fastjson.JSON;
import com.baijia.tianxiao.sal.cloud.api.BaseCloudApi;
import com.baijia.tianxiao.sal.cloud.model.request.LiveRoomCreate;
import com.baijia.tianxiao.sal.cloud.model.request.LiveRoomDelete;
import com.baijia.tianxiao.sal.cloud.model.request.LiveRoomUpdate;
import com.baijia.tianxiao.sal.cloud.model.response.DefaultApiResult;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.beust.jcommander.internal.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="liveRoomApi")
public class LiveRoomApi
extends BaseCloudApi {
    private static final Logger log = LoggerFactory.getLogger(LiveRoomApi.class);
    private String baseUrl = null;
    private String playbackUrl = null;
    public static String baijiaCloudDomain = null;
    private String video_sinker_domain = null;

    @PostConstruct
    public void init() {
        try {
            baijiaCloudDomain = PropertiesReader.getValue((String)"cloud", (String)"baijiacloud.domain");
            this.video_sinker_domain = PropertiesReader.getValue((String)"cloud", (String)"video.sinker.domain");
            this.baseUrl = baijiaCloudDomain + "/openapi/room/";
            this.playbackUrl = baijiaCloudDomain + "/openapi/playback/getStatus";
        }
        catch (Exception e) {
            log.error("can not read properties! error:{}", (Throwable)e);
        }
    }

    public DefaultApiResult create(LiveRoomCreate liveRoom) {
        HashMap params = Maps.newHashMap();
        this.init(params);
        params.put("title", liveRoom.getTitle());
        params.put("start_time", liveRoom.getStart_time().toString());
        params.put("end_time", liveRoom.getEnd_time().toString());
        params.put("type", liveRoom.getType().toString());
        params.put("media_type", liveRoom.getMedia_type().toString());
        params.put("max_users", liveRoom.getMax_users().toString());
        params.put("pre_enter_time", liveRoom.getPre_enter_time().toString());
        this.buidlSign(params);
        String str = HttpClientUtils.doPost((String)(this.baseUrl + "create"), (Map)params);
        return (DefaultApiResult)JSON.parseObject((String)str, DefaultApiResult.class);
    }

    public DefaultApiResult update(LiveRoomUpdate liveRoom) {
        HashMap params = Maps.newHashMap();
        this.init(params);
        params.put("room_id", liveRoom.getRoom_id());
        params.put("title", liveRoom.getTitle());
        params.put("start_time", liveRoom.getStart_time().toString());
        params.put("end_time", liveRoom.getEnd_time().toString());
        params.put("type", liveRoom.getType().toString());
        params.put("media_type", liveRoom.getMedia_type().toString());
        params.put("max_users", liveRoom.getMax_users().toString());
        params.put("pre_enter_time", liveRoom.getPre_enter_time().toString());
        this.buidlSign(params);
        String str = HttpClientUtils.doPost((String)(this.baseUrl + "update"), (Map)params);
        return (DefaultApiResult)JSON.parseObject((String)str, DefaultApiResult.class);
    }

    public DefaultApiResult delete(LiveRoomDelete liveRoom) {
        HashMap params = Maps.newHashMap();
        this.init(params);
        params.put("room_id", liveRoom.getRoom_id());
        this.buidlSign(params);
        String str = HttpClientUtils.doPost((String)(this.baseUrl + "delete"), (Map)params);
        return (DefaultApiResult)JSON.parseObject((String)str, DefaultApiResult.class);
    }

    public String list(Integer page, Integer limit) {
        HashMap params = Maps.newHashMap();
        this.init(params);
        params.put("page", page.toString());
        params.put("limit", limit.toString());
        this.buidlSign(params);
        String str = HttpClientUtils.doPost((String)(this.baseUrl + "list"), (Map)params);
        return str;
    }

    public DefaultApiResult playbackStatus(String room_id) {
        HashMap params = Maps.newHashMap();
        this.init(params);
        params.put("room_id", room_id);
        this.buidlSign(params);
        String str = HttpClientUtils.doPost((String)this.playbackUrl, (Map)params);
        return (DefaultApiResult)JSON.parseObject((String)str, DefaultApiResult.class);
    }

    public Map<String, Integer> getRoomsUserCount(Collection<Long> roomIds) {
        HashMap params = Maps.newHashMap();
        List roomIdStrs = Lists.newArrayList();
        for (Long roomId : roomIds) {
            String roomIdStr = String.valueOf(roomId);
            roomIdStrs.add(roomIdStr);
        }
        params.put("class_list", roomIdStrs);
        String str = null;
        try {
            str = HttpClientUtils.doJsonPostNew((String)(this.video_sinker_domain + "/user_counts"), (Map)params, (String)"UTF-8");
            return (Map)JSON.parseObject((String)str, Map.class);
        }
        catch (Exception e) {
            log.warn("getRoomsUserCount", (Throwable)e);
            return Maps.newHashMap();
        }
    }

    public static void main(String[] args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        LiveRoomCreate liveRoom = new LiveRoomCreate();
        liveRoom.setTitle("abcc");
        Date now = new Date();
        liveRoom.setStart_time(DateUtil.date2UnixTimestamp((Date)now));
        liveRoom.setEnd_time(DateUtil.date2UnixTimestamp((Date)DateUtil.addHour((Date)now, (int)1)));
        liveRoom.setMax_users(5);
        LiveRoomApi api = new LiveRoomApi();
        api.create(liveRoom);
    }
}

