package com.baijia.tianxiao.sal.wx.model;

import com.baijia.tianxiao.constant.PublishStatus;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dal.org.po.WxCategory;
import com.baijia.tianxiao.dal.org.po.WxNews;
import com.baijia.tianxiao.util.HtmlUtils;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import java.util.Date;
import java.util.Map;

/**
 * 网校新闻
 * Created by wangsixia on 2017/1/13.
 */
@Data
public class WxNewsDto extends WxNewsBaseDto{
    // 新闻截取长度
    private static final int CUT_LENGTH = 100;
    // 截取拼接符
    private static final String CUT_STRING = "...";

    // 新闻内容富文本
    private String richContent;
    // 新闻内容纯文字
    private String textContent;

    public void toPo(WxNews po, Integer operatorId, Long orgId) {
        if (this.getId() == null) {
            po.setCreateTime(new Date());
            po.setOrgId(orgId);
            po.setOperatorId(operatorId);
        }
        po.setCategoryId(this.getCategoryId());
        po.setTitle(this.getTitle());
        if (StringUtils.isNotBlank(this.getRichContent())) {
            po.setRichContent(this.getRichContent());
            po.setTextContent(HtmlUtils.html2Text(this.getRichContent()));
        }
        po.setCoverId(this.getCoverId());
        if (this.getStatus() != null && this.getStatus().intValue() == PublishStatus.PUBLISH.getCode()) {
            po.setPublishTime(new Date());
            po.setStatus(PublishStatus.PUBLISH.getCode());
        } else {
            po.setPublishTime(null);
            po.setStatus(PublishStatus.UN_PUBLISH.getCode());
        }
        po.setStatus(this.getStatus() == null ? PublishStatus.UN_PUBLISH.getCode() : this.getStatus());
        po.setUpdateTime(new Date());
    }

    public static WxNewsDto getFromPo(WxNews po, Map<Long, WxCategory> categoryMap, Map<Long, String> coverMap, Map<Integer, String> operatorMap) {
        WxNewsDto dto = new WxNewsDto();
        dto.setId(po.getId());
        dto.setTitle(po.getTitle());
        dto.setCategoryId(po.getCategoryId());
        dto.setCategoryName(categoryMap != null && categoryMap.containsKey(po.getCategoryId()) ? categoryMap.get(po.getCategoryId()).getName() : "");
        dto.setStatus(po.getStatus());
        dto.setStatusStr(PublishStatus.getByCode(po.getStatus()));
        dto.setCoverId(po.getCoverId());
        dto.setCoverUrl(coverMap != null && coverMap.containsKey(po.getCoverId()) ? coverMap.get(po.getCoverId()) : TianXiaoConstant.DEFAULT_NEWS_COVER);
        dto.setCreateTime(po.getCreateTime());
        dto.setPublishTime(po.getPublishTime());
        if (po.getTextContent().length() > CUT_LENGTH) {
            dto.setShortContent(StringUtils.substring(po.getTextContent(), 0, CUT_LENGTH) + CUT_STRING);
        } else {
            dto.setShortContent(po.getTextContent());
        }
        dto.setOperatorId(po.getOperatorId());
        dto.setOperatorName(operatorMap != null && operatorMap.containsKey(po.getOperatorId()) ? operatorMap.get(po.getOperatorId()) : "");
        dto.setRichContent(po.getRichContent());
        dto.setTextContent(po.getTextContent());
        return dto;
    }
}
