
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.model;


/**
 * @title ValidateCodeSend
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年12月22日
 * @version 1.0
 */
    
public class ValidateCodeSend {

	public enum SendTypeEnum {
		SMS, EMAIL, ;
	}

	public enum SendEmailTypeEnum {
		TYPE_NEWEMAIL(0), // 修改邮箱时给新邮箱发送邮件
		TYPE_GETPWD(1), // 找回密码时发送
		TYPE_AUTH(2),//邮箱认证时发送邮件
		TYPE_OLDEMAIL(3), // 修改邮箱时给旧邮箱发送邮件
		TYPE_MODIFYMOBILE(4), // 修改手机时发送邮件
		;
		private int index;

		private SendEmailTypeEnum(int index) {
			this.index = index;
		}

		public int getIndex() {
			return index;
		}
	}

	// 1开头，需要登录；2开头，不需要登录
	public enum SendSMSTypeEnum {
		REGISTER(101), // 注册时发送短信验证码
		FIND_PASSWORD(102), // 找回密码时发送短信验证码
		VALIDATA_OLD_PHONE(103), // 旧手机验证
		MODIFY_EMAIL(201), // 修改邮箱时发送短信验证码
		MODIFY_PHONE(202), // 修改手机时发送短信验证码
		ADD_BANK_CARD(203), // 新增银行卡
		;
		private int index;

		private SendSMSTypeEnum(int index) {
			this.index = index;
		}

		public int getIndex() {
			return index;
		}
	}

	public static void main(String[] args) {
		//System.out.println(BizTypeEnum.Common.getSubject());
	}

	//现在从数据库取content和subject
	public enum BizTypeEnum {
		Other("自定义内容模板"),
		
		SmsBindRegister("您正在申请注册%s,验证码是${checkCode}"),
		
		SmsFindPassword("您发送了在%s手机找回密码的请求，验证码是${checkCode}"),
		SmsModifyMobile("您发送了在%s修改手机的请求，验证码是${checkCode}"),
        SmsRandomPassword("机构 [%s] 给您报名并注册了账号。账号是 [%s] ,密码是 [%s] ,请妥善保存密码,并尽快登录机构网站修改密码"),//机构名、手机号、密码
		
		Default("验证码是${checkCode}","邮箱验证");
		private String content;
		private String subject;

		private BizTypeEnum(){
			
		}
		private BizTypeEnum(String content) {
			this.content = content;
			this.subject = null;
		}

		private BizTypeEnum(String content, String subject) {
			this.content = content;
			this.subject = subject;
		}

		public String getContent() {
			return content;
		}

		public String getSubject() {
			return subject;
		}

	}

	/**
	 * 发送标识，手机号码或者邮箱全名
	 */
	private String sendIdentity;

	/**
	 * 发送类型，目前只有手机和email
	 */
	private SendTypeEnum sendType;

	/**
	 * 业务类型
	 */
	private BizTypeEnum bizType;

	/**
	 * 内容模板，直接传模板内容,会替换其中的${checkCode}部分
	 */
	private String contentTemplate;

	/**
	 * 其他业务的业务名字标识
	 */
	private String otherBizName;

	/**
	 * 有效时间
	 */
	private int effectMinute;

	public String getSendIdentity() {
		return sendIdentity;
	}

	public void setSendIdentity(String sendIdentity) {
		this.sendIdentity = sendIdentity;
	}

	public SendTypeEnum getSendType() {
		return sendType;
	}

	public void setSendType(SendTypeEnum sendType) {
		this.sendType = sendType;
	}

	public BizTypeEnum getBizType() {
		return bizType;
	}

	public void setBizType(BizTypeEnum bizType) {
		this.bizType = bizType;
	}

	public String getContentTemplate() {
		return contentTemplate;
	}

	public void setContentTemplate(String contentTemplate) {
		this.contentTemplate = contentTemplate;
	}

	public int getEffectMinute() {
		return effectMinute;
	}

	public void setEffectMinute(int effectMinute) {
		this.effectMinute = effectMinute;
	}

	public String getOtherBizName() {
		return otherBizName;
	}

	public void setOtherBizName(String otherBizName) {
		this.otherBizName = otherBizName;
	}

}
