
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.WxVideoLessonDao;
import com.baijia.tianxiao.dal.org.po.WxVideoLesson;
import com.baijia.tianxiao.sal.wx.api.WxVideoLessonService;
import com.baijia.tianxiao.sal.wx.model.WxCourseLessonDto;

import com.google.common.collect.Maps;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

/**
 * @title WxVideoLessonServiceImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年1月7日
 * @version 1.0
 */

@Service("wxVideoLessonService")
public class WxVideoLessonServiceImpl implements WxVideoLessonService {

    @Resource
    private WxVideoLessonDao wxVideoLessonDao;

    @Override
    public void create(WxVideoLesson wxVideoLesson) {
        
        wxVideoLessonDao.save(wxVideoLesson);
            
    }

    @Override
    public boolean updateByLessonId(WxVideoLesson wxVideoLesson) {
        
        Map<String,Object> updateCondtion = Maps.newHashMap();
        if(wxVideoLesson.getOrgId()!=null){
            updateCondtion.put("orgId", wxVideoLesson.getOrgId());
        }
        updateCondtion.put("lessonId",wxVideoLesson.getLessonId());
        
        updateCondtion.put("sourceId",wxVideoLesson.getSourceId());
        updateCondtion.put("isFree",wxVideoLesson.getIsFree());
        
        return 1==wxVideoLessonDao.update(updateCondtion, "sourceId","isFree");
            
    }

    @Override
    public boolean delByLessonId(Long orgId, Long lessonId) {
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId",lessonId);
        condition.put("delStatus", 1);
        return 1==wxVideoLessonDao.delByCondition(condition);
    }

    @Override
    public void saveByWxCourseLessonDto(WxCourseLessonDto wxCourseLessonDto) {
        
        WxVideoLesson wxVideoLesson = new WxVideoLesson();
        wxVideoLesson.setOrgId(wxCourseLessonDto.getOrgId());
        wxVideoLesson.setCourseId(wxCourseLessonDto.getCourseId());
        wxVideoLesson.setLessonId(wxCourseLessonDto.getLessonId());
        wxVideoLesson.setIsFree(wxCourseLessonDto.getIsFree());
        wxVideoLesson.setSourceId(wxCourseLessonDto.getSourceId());
        wxVideoLesson.setDelStatus(0);
        this.create(wxVideoLesson);
            
    }

    @Override
    public boolean updateByWxCourseLessonDto(WxCourseLessonDto wxCourseLessonDto) {
        
        WxVideoLesson wxVideoLesson = new WxVideoLesson();
        wxVideoLesson.setOrgId(wxCourseLessonDto.getOrgId());
        wxVideoLesson.setCourseId(wxCourseLessonDto.getCourseId());
        wxVideoLesson.setLessonId(wxCourseLessonDto.getLessonId());
        wxVideoLesson.setIsFree(wxCourseLessonDto.getIsFree());
        wxVideoLesson.setSourceId(wxCourseLessonDto.getSourceId());
        
        return this.updateByLessonId(wxVideoLesson);
    }

    @Override
    public Map<Long, WxVideoLesson> queryMapByOrgLessonId(Long orgId, Collection<Long> lessonIds) {
        Map<Long,WxVideoLesson> map = Maps.newHashMap();
        if(CollectionUtils.isEmpty(lessonIds)){
            return map;
        }
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId",lessonIds);
        List<WxVideoLesson> list = wxVideoLessonDao.queryByCondition(condition,null);
        
        for(WxVideoLesson wxVideoLesson:list){
            map.put(wxVideoLesson.getLessonId(), wxVideoLesson);
        }
        return map;
            
    }

    @Override
    public WxVideoLesson getByLessonId(Long orgId, Long lessonId) {
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId",lessonId);
        List<WxVideoLesson> list = wxVideoLessonDao.queryByCondition(condition,null);
        if(list.size()==0){
            return null;
        }
        return list.get(0);
    }
        
    
}

    