
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.WxTemplateConfigDao;
import com.baijia.tianxiao.dal.org.dao.WxTemplateDao;
import com.baijia.tianxiao.dal.org.po.WxTemplateConfig;
import com.baijia.tianxiao.dal.org.po.WxTemplate;
import com.baijia.tianxiao.sal.wx.api.WxTemplateConfigService;
import com.baijia.tianxiao.sal.wx.enums.ConfigKeyEnum;
import com.baijia.tianxiao.sqlbuilder.bean.Order;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

/**
 * @title OrgWxTemplateConfigServiceImpl
 * @desc 网校装修模版区块配置 
 * @author leiruiqi
 * @date 2016年12月29日
 * @version 1.0
 */

@Service("wxTemplateConfigService")
public class WxTemplateConfigServiceImpl implements WxTemplateConfigService {

    @Resource
    private WxTemplateDao wxTemplateDao;
    
    @Resource
    private WxTemplateConfigDao orgWxTemplateConfigDao;
    
    
   
    @Override
    public WxTemplateConfig getTemplateConfigByTemplateCode(Long orgId, String templateCode) {

        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("templateCode",templateCode);
        
        List<WxTemplateConfig> list = orgWxTemplateConfigDao.queryByCondition(condition, null);
        if(list.size()==1){
            return list.get(0);
        }else{
            return null;
        }

    }

   
    @Override
    public boolean updateTemplateConfig(WxTemplateConfig templateConfig) {

        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", templateConfig.getOrgId());
        condition.put("templateCode",templateConfig.getTemplateCode());
        condition.put("value",templateConfig.getValue());
        return 1==orgWxTemplateConfigDao.update(condition, "value");

    }

    

    @Override
    public void createTemplateConfig(WxTemplateConfig templateConfig) {

        orgWxTemplateConfigDao.save(templateConfig);

    }


    @Override
    public void saveTemplateConfig(WxTemplateConfig templateConfig) {
        if(getTemplateConfigByTemplateCode(templateConfig.getOrgId(),templateConfig.getTemplateCode())!=null){
            updateTemplateConfig(templateConfig);
        }else{
            createTemplateConfig(templateConfig);
        }
            
    }


    @Override
    public List<WxTemplate> listTemplateConfig(Long orgId) {
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
       
        List<WxTemplate> wxTemplateList = wxTemplateDao.queryByCondition(condition, null);
        if(CollectionUtils.isEmpty(wxTemplateList)){
            WxTemplate defaultTemplate = new WxTemplate();
            defaultTemplate.setCode(ConfigKeyEnum.wx_template.getDefaultValue());
            defaultTemplate.setType(WxTemplate.Type.home.getCode());
            defaultTemplate.setUrl("//imgs.genshuixue.com/0baijiatools/33b5dc5d592df5bf5d2e979f17b7ada6/basicTemplate.png");
            wxTemplateList.add(defaultTemplate);
        }
        return wxTemplateList;
            
    }

}

    