
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.WxRoomUserCountDao;
import com.baijia.tianxiao.dal.org.po.WxRoomUserCount;
import com.baijia.tianxiao.sal.wx.api.WxRoomUserCountService;

import com.google.common.collect.Maps;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

/**
 * @title WxRoomUserCountServiceImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年1月18日
 * @version 1.0
 */

@Service("wxRoomUserCountService")
public class WxRoomUserCountServiceImpl implements WxRoomUserCountService {

    @Resource
    private WxRoomUserCountDao wxRoomUserCountDao;

    @Override
    public void saveCurrentUserCount(WxRoomUserCount userCount) {

        // TODO Auto-generated method stub

    }

    

    @Override
    public void updateCurrentUserCount(Long orgId, Long roomId, Long count) {

        Map<String,Object> condition = Maps.newHashMap();
        
        condition.put("orgId", orgId);
        condition.put("roomId", roomId);
        condition.put("count", count);
        
        int result = wxRoomUserCountDao.update(condition, "count");

        if(result==0){
            WxRoomUserCount newRoomUserCount = new WxRoomUserCount();
            newRoomUserCount.setOrgId(orgId);
            newRoomUserCount.setRoomId(roomId);
            newRoomUserCount.setCount(count);
            wxRoomUserCountDao.save(newRoomUserCount);
        }
    }

    
    @Transactional
    @Override
    public boolean addOneCurrentUserCount(Long orgId,Long roomId, Long maxCount) {
        
        
        List<WxRoomUserCount> list = this.wxRoomUserCountDao.queryByOrgIdForUpdate(orgId,true);
        Long orgCount =0L;
        for(WxRoomUserCount tempCount:list){
            orgCount += tempCount.getCount();
        }
        if(orgCount>=maxCount){
            return false;
        }
        wxRoomUserCountDao.addOneByOrgIdAndRoomId(orgId, roomId);
        return true;

    }

}

    