
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.wx.api.WxOrgStudentService;
import com.baijia.tianxiao.sal.wx.model.ValidateCodeSend.SendSMSTypeEnum;
import com.baijia.tianxiao.sal.wx.result.CommonDataResult;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @title WxOrgStudentServiceImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年12月22日
 * @version 1.0
 */
@Service("wxOrgStudentService")
@Slf4j
public class WxOrgStudentServiceImpl implements WxOrgStudentService {

   @Resource
   private OrgStudentDao orgStudentDao;
   
   @Resource
   private OrgStudentService orgStudentService;

    
    @Override
    public CommonDataResult<?> checkMobileExist(Long orgId,String mobile,
            String email, int codeType) {
        CommonDataResult<?> result = new CommonDataResult<String>(true);
        
        List<OrgStudent> list = orgStudentDao.getStudentByMobileAndOrgId(orgId, mobile,0);
        
        
        if (CollectionUtils.isNotEmpty(list)
                && (codeType == SendSMSTypeEnum.REGISTER.getIndex()
                ||codeType == SendSMSTypeEnum.MODIFY_PHONE
                        .getIndex())) {
            result.setSuccess(false);
            if (StringUtils.isNotEmpty(mobile)) {
                if (log.isDebugEnabled()) {
                    log.debug("手机号 " + mobile + " 已注册，请修改手机号");
                }
                result.setMsg("手机已存在");
            } 
        } else if (CollectionUtils.isEmpty(list)
                && codeType == SendSMSTypeEnum.FIND_PASSWORD.getIndex()) {
            result.setSuccess(false);
            if (StringUtils.isNotEmpty(mobile)) {
                if (log.isDebugEnabled()) {
                    log.debug("手机号 " + mobile + " 不存在，请修改手机号");
                }
                result.setMsg("手机号码不存在");
            } 
        }
        return result;
    }


    @Override
    public CommonDataResult<?> createStudentForWxRegiester(Long orgId, String mobile, String pwd) {
        
        // TODO Auto-generated method stub
        return null;
            
    }
    
    

}

    