
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.WxLessonAccessRecordDao;
import com.baijia.tianxiao.dal.org.dto.WxLessonAccessRecordVo;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.WxLessonAccessRecord;
import com.baijia.tianxiao.sal.wx.api.WxLessonAccessRecordService;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

/**
 * @title WxLessonAccessRecordServiceImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年1月12日
 * @version 1.0
 */

@Service("wxLessonAccessRecordService")
public class WxLessonAccessRecordServiceImpl implements WxLessonAccessRecordService{

    @Resource
    private WxLessonAccessRecordDao wxLessonAccessRecordDao;
    
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    
    @Resource
    private OrgCourseDao orgCourseDao;
    
    @Resource
    private OrgStudentDao orgStudentDao;
    
    
    @Override
    public void create(WxLessonAccessRecord record) {
        
        wxLessonAccessRecordDao.save(record);
            
    }

    @Override
    public void create(Long orgId, Long courseId, Long lessonId, Long studentId) {
        
        WxLessonAccessRecord record = new WxLessonAccessRecord();
        record.setOrgId(orgId);
        record.setCourseId(courseId);
        record.setLessonId(lessonId);
        record.setStudentId(studentId);
        
        this.create(record);
            
    }

    @Async
    @Override
    public void asyncCreate(Long orgId, Long courseId, Long lessonId, Long studentId) {
        
        this.create(orgId, courseId, lessonId, studentId);
            
    }

    @Override
    public List<WxLessonAccessRecord> queryByOrgCondition(WxLessonAccessRecord record) {
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", record.getOrgId());
        if(record.getLessonId() != null){
            condition.put("lessonId", record.getLessonId());
        }
        if(record.getStudentId() != null){
            condition.put("studentId", record.getStudentId());
        }
        
        return wxLessonAccessRecordDao.queryByCondition(condition, null);
            
    }

    @Override
    public Map<Long, Integer> queryCountByConditon(WxLessonAccessRecord record, String groupField, String countField) {
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", record.getOrgId());
        if(record.getLessonId() != null){
            condition.put("lessonId", record.getLessonId());
        }
        if(record.getStudentId() != null){
            condition.put("studentId", record.getStudentId());
        }
        
        return wxLessonAccessRecordDao.groupCount(condition, countField, groupField, true, Long.class);
            
    }

    public List<WxLessonAccessRecord> queryStudentLastAccessLesson(Long orgId,Long studentId,Long courseId){
        
        return wxLessonAccessRecordDao.queryStudentLastAccessLesson(orgId, studentId,courseId);
        
    }
    
    public List<WxLessonAccessRecord> queryLessonLastAccess(Long orgId,Long lessonId){
        
        return wxLessonAccessRecordDao.queryLessonLastAccess(orgId, lessonId);
        
    }
    
    public List<WxLessonAccessRecord> queryStudentLesson(Long orgId,Long studentId,Long lessonId){
        
        return wxLessonAccessRecordDao.queryStudentLesson(orgId, studentId,lessonId);
        
    }
    
    public List<WxLessonAccessRecordVo> converPoList2VoList(Long orgId,List<WxLessonAccessRecord> list){
        
        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> lessonIds = Sets.newHashSet();
        Set<Long> studentIds = Sets.newHashSet();
        
        for(WxLessonAccessRecord record:list){
            courseIds.add(record.getCourseId());
            lessonIds.add(record.getLessonId());
            studentIds.add(record.getStudentId());
        }
        
        Map<Long, OrgClassLesson> lessonMap = orgClassLessonDao.getClassLessonMap(orgId, lessonIds, 0);
        
        //Map<Long,String> courseNameMap = orgCourseDao.getCourseNameMap(courseIds);
        Map<Long,OrgCourse> courseMap = orgCourseDao.getOrgCourseMap(courseIds);
        Map<Long,String> studentNameMap = orgStudentDao.getStudentNameMap(studentIds);
        List<WxLessonAccessRecordVo> voList = Lists.newArrayList();
        for(WxLessonAccessRecord record:list){
            OrgCourse orgCourse = courseMap.get(record.getCourseId());
            OrgClassLesson lesson = lessonMap.get(record.getLessonId());
            String studentName = studentNameMap.get(record.getStudentId());
            voList.add(converPo2Vo(record,orgCourse,lesson,studentName));
        }
        
        return voList;
        
    }
    
    private WxLessonAccessRecordVo converPo2Vo(WxLessonAccessRecord po,OrgCourse course,OrgClassLesson lesson,String studentName){
        WxLessonAccessRecordVo vo = new WxLessonAccessRecordVo();
        vo.setCourseId(po.getCourseId());
        if(course!=null){
            vo.setCourseName(course.getName());
            vo.setCourseType(course.getCourseType());
        }
        
        vo.setLessonId(po.getLessonId());
        if(lesson!=null){
            vo.setLessonName(lesson.getName());
        }
        
        vo.setStudentId(po.getStudentId());
        vo.setStudentName(studentName);
        
        vo.setOrgId(po.getOrgId());
        vo.setCreateTime(po.getCreateTime());
        return vo;
    }
    
    

}

    