
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.WxCoursewareDao;
import com.baijia.tianxiao.dal.org.po.WxCourseware;
import com.baijia.tianxiao.sal.wx.api.WxCoursewareService;
import com.baijia.tianxiao.sqlbuilder.bean.Order;

import com.google.common.collect.Maps;

import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

/**
 * @title WxCoursewareServiceImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年1月7日
 * @version 1.0
 */

@Service("wxCoursewareService")
public class WxCoursewareServiceImpl implements WxCoursewareService{

    @Resource
    private WxCoursewareDao wxCoursewareDao;
    
    @Override
    public void save(WxCourseware wxCourseware) {
        wxCoursewareDao.save(wxCourseware);
    }

    @Override
    public void delete(WxCourseware wxCourseware) {
        
        Map<String,Object> condition = Maps.newHashMap();
        
        condition.put("orgId", wxCourseware.getOrgId());
        condition.put("id", wxCourseware.getId());
        
        wxCoursewareDao.delByCondition(condition);
            
    }

    @Override
    public List<WxCourseware> listAllByCourseId(Long orgId, Long courseId) {
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("courseId",courseId);
        Order order = Order.desc("id");
        List<WxCourseware> list =  wxCoursewareDao.queryByCondition(condition, order, null);
        return list;
            
    }
    
    
    

    
}

    