
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.impl;

import com.baijia.tianxiao.dal.org.dao.WxBannerDao;
import com.baijia.tianxiao.dal.org.po.WxBanner;
import com.baijia.tianxiao.sal.wx.api.WxBannerService;
import com.baijia.tianxiao.sqlbuilder.bean.Order;

import com.beust.jcommander.internal.Maps;
import com.google.common.base.Preconditions;

import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

/**
 * @title OrgBannerServiceImpl
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年12月21日
 * @version 1.0
 */
@Service("wxBannerService")
public class WxBannerServiceImpl implements WxBannerService{

    @Resource
    private WxBannerDao wxBannerDao;
    
    @Override
    public void save(WxBanner orgBanner) {
        Preconditions.checkArgument(orgBanner.getPic()!=null && orgBanner.getUrl()!=null, "banner信息不全");
        
        orgBanner.setSortNum(0);
        orgBanner.setStatus(0);
        wxBannerDao.save(orgBanner);
        
    }

    @Override
    public void updateBannerInfo(WxBanner orgBanner) {
        
        wxBannerDao.update(orgBanner);
            
    }

    @Override
    public void updateStatusAndSort(WxBanner orgBanner) {
        
        wxBannerDao.update(orgBanner, "status","sort");
            
    }

    @Override
    public List<WxBanner> listAllByOrgIdAndStatus(Long orgId, Integer status) {
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        if(status!=null){
            condition.put("status", status);
        }
        
        return wxBannerDao.queryByCondition(condition,Order.asc("sortNum"),null);
            
    }

    @Override
    public void deleteBanner(Long orgId, Long bannerId) {
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("id", bannerId);
        wxBannerDao.delByCondition(condition);
            
    }

    @Override
    public void batchSort(Long orgId, List<Long> sortIds) {
        
        Map<String,Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        
        List<WxBanner> list =  wxBannerDao.queryByCondition(condition, null);
        Map<Long,WxBanner> map = Maps.newHashMap();
        for(WxBanner banner:list){
            map.put(banner.getId(), banner);
        }
        
        int sortNo = 0;
        for(Long id:sortIds){
            WxBanner banner = map.get(id);
            if(banner!=null){
                sortNo++;
                banner.setSortNum(sortNo);
                wxBannerDao.update(banner, "sortNum");
            }
        }
            
    }

}

    