package com.baijia.tianxiao.sal.wx.api;

import com.baijia.tianxiao.sal.wx.model.WxNewsBaseDto;
import com.baijia.tianxiao.sal.wx.model.WxNewsDto;
import com.baijia.tianxiao.sal.wx.model.WxNewsReqDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 网校新闻&关于我们
 * Created by wangsixia on 2017/1/13.
 */
public interface WxNewsService {

    /**
     * 新增/修改新闻
     * @param orgId
     * @param param
     * @param cascadeId 新闻创建人
     * @return
     */
    Long save(Long orgId, WxNewsDto param, Integer cascadeId);

    /**
     * 获取新闻详情
     * @param orgId
     * @param id
     * @return
     */
    WxNewsDto getDetail(Long orgId, Long id);

    /**
     * 删除新闻
     * @param orgId
     * @param id
     */
    void delete(Long orgId, Long id);

    /**
     * 新闻列表
     * @param orgId
     * @param param
     * @param pageDto
     * @return
     */
    List<WxNewsBaseDto> getBaseList(Long orgId, WxNewsReqDto param, Boolean descByPublish, PageDto pageDto);
    
    List<WxNewsBaseDto> getBaseListByIds(Long orgId, Collection<Long> newsIds);
    
    public Map<Long,WxNewsBaseDto> getBaseMapByIds(Long orgId, Collection<Long> newsIds);
    
    public List<WxNewsBaseDto> getBaseListOrderByIds(Long orgId, Collection<Long> newsIds);

    /**
     * 发布/取消发布新闻
     * @param orgId
     * @param ids
     * @param status: PublishStatus 0取消发布;1发布
     */
    void switchStatus(Long orgId, Collection<Long> ids, Integer status);

    /**
     * 保存联系我们信息
     * @param orgId
     * @param richContent
     * @param coverId
     * @return
     */
    Long saveContact(Long orgId, String richContent, Long coverId);

    /**
     * 获取联系我们信息
     * @param orgId
     * @return
     */
    Map<String, Object> getContact(Long orgId);
}
