
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.api;

import com.baijia.tianxiao.dal.org.dto.WxLiveRoomQueryDto;
import com.baijia.tianxiao.dal.org.po.WxLiveRoom;
import com.baijia.tianxiao.sal.wx.model.WxLiveLessonView;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @title WxLiveRoomService
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年1月6日
 * @version 1.0
 */

public interface WxLiveRoomService {
    
    public WxLiveRoom getByRoomId(Long roomId);

    public Long  getLessonRoomId(Long orgId,Long lesson);
    
    WxLiveRoom getLessonRoom(Long orgId, Long lessonId);
    
    Map<Long,WxLiveRoom> queryMapByOrgLessonIds(Long orgId,Collection<Long> lessonIds);
    
    List<WxLiveRoom> queryListByOrgLessonIds(Long orgId,Collection<Long> lessonIds);
    

    public void save(WxLiveRoom wxLiveRoom);
    
    public void update(WxLiveRoom wxLiveRoom);
    
    public void updateByLessonId(WxLiveRoom wxLiveRoom);
    
    public void delete(Long orgId,Long lessonId);
    
    public List<WxLiveRoom> queryByConditon(WxLiveRoomQueryDto dto,PageDto pageDto);
    
    List<WxLiveLessonView> buildLessonLiveView(Long orgId,List<WxLiveRoom> list);
    
    public List<WxLiveRoom> queryActiveLiveRoomList();
    
    public void refreshRoomUser();
    
    
    public void updatePlaybackStatus(WxLiveRoom wxLiveRoom);
    

}

    