
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.api;

import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.sal.course.dto.OrgCourseInfoDto;
import com.baijia.tianxiao.sal.course.dto.OrgCourseQueryResponseDto;
import com.baijia.tianxiao.sal.wx.model.WxCourseInfoDto;
import com.baijia.tianxiao.sal.wx.model.WxCourseQueryDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;

/**
 * @title WxCourseService
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年12月21日
 * @version 1.0
 */

public interface WxCourseService {

    public List<OrgCourseQueryResponseDto> queryOrgCourses(WxCourseQueryDto courseQueryDto, PageDto pageDto);

    public List<OrgCourseQueryResponseDto> buildOrgCourseByCourseIds(Long orgId,List<Long> courseIds);
    
    public List<OrgCourseQueryResponseDto> buildOrgCourseByCourseList(Long orgId,List<OrgCourse> courseList);
    
    public Map<Long,OrgCourseQueryResponseDto> buildOrgCourseMapByCourseIds(Long orgId,List<Long> courseIds);
    
    public List<OrgCourseQueryResponseDto> buildOrgCourseListMapByCourseIds(Long orgId,List<Long> courseIds);

    /**
     * 班级信息
     * @param orgId
     * @param courseId
     * @param pageDto
     * @return
     */
    WxCourseInfoDto getCourseInfo(Long orgId, Long courseId);
    
    Long updateCourseWxOthers(Long orgId, OrgCourseInfoDto course);
    
    OrgCourse saveOrUpdateCourseWxBase(Long orgId, OrgCourseInfoDto course);
    
    OrgCourseInfoDto getOrgCourseInfo(Long orgId, Long courseId);
    
    public void editEffectDays(Long orgId,Long courseId,Integer days);
}

    