
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2017 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wx.api;

import com.baijia.tianxiao.dal.org.po.WxCommonCounter;
import com.baijia.tianxiao.sal.wx.model.WxCommonCounterKey;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @title WxCommonCounterService
 * @desc TODO 
 * @author leiruiqi
 * @date 2017年2月3日
 * @version 1.0
 */

public interface WxCommonCounterService {

    boolean create(WxCommonCounter record);
    
    /**
     * 加1
     * @param commonCounterKey
     * @return
     */
    boolean addOne(WxCommonCounterKey commonCounterKey);
    
    /**
     * 减1
     * @param commonCounterKey
     * @return
     */
    boolean subOne(WxCommonCounterKey commonCounterKey);
    
        
    /**
     * 控制最大上限的加1
     * 
     * @param commonCounterKey
     * @param maxValue
     * @return
     */
    boolean addOneForMaxValue(WxCommonCounterKey commonCounterKey,Long maxValue);
    
    /**
     * 判断计数的key是否存在
     * @param commonCounterKey
     * @return
     */
    boolean exist(WxCommonCounterKey commonCounterKey);
    
    /**
     * 获取计数器的统计的数值
     * @param commonCounterKey
     * @return
     */
    Long getCurrentCountByKey(WxCommonCounterKey commonCounterKey);
    
    /**
     * 批量获取计数器的当前值
     * @param mainKey
     * @param secondaryKeys
     * @return
     */
    List<WxCommonCounter> getListByKeys(String mainKey,Collection<String> secondaryKeys);
    
    /**
     * 批量获取计数器的当前值
     * @param mainKey
     * @param secondaryKeys
     * @return
     */
    Map<String,Long> getMapByKeys(String mainKey,Collection<String> secondaryKeys);
    
    /**
     * 这个方法可以得到整个业务的计数统计，而不是单个业务计数统计，比如所有的课程总共加起来被收藏的多少次
     * @param mainKey
     * @return
     */
    Map<String,Long> getListByMainKey(String mainKey);
}

    