/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.cloud.api;
import com.baijia.tianxiao.sal.cloud.model.request.LiveRoomCreate;
import com.baijia.tianxiao.sal.cloud.model.request.LiveRoomDelete;
import com.baijia.tianxiao.sal.cloud.model.request.LiveRoomUpdate;
import com.baijia.tianxiao.sal.cloud.model.response.DefaultApiResult;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.alibaba.fastjson.JSON;
import com.beust.jcommander.internal.Lists;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import lombok.extern.slf4j.Slf4j;
/**
 * @title LiveRoomApi
 * @desc 直播室相关api 
 * @author leiruiqi
 * @date 2016年12月24日
 * @version 1.0
 */
@Slf4j
@Service("liveRoomApi")
public class LiveRoomApi extends BaseCloudApi{
    
    private String baseUrl = null;//"http://test-api.baijiacloud.com/openapi/room/";
    
    private String playbackUrl = null;//"http://test-api.baijiacloud.com/openapi/playback/getStatus";
    
    public static String baijiaCloudDomain = null;
    
    private String video_sinker_domain = null;//"http://test-video-sinker.genshuixue.com/";
    
    @PostConstruct
    public void init(){
        try {
            baijiaCloudDomain = PropertiesReader.getValue("cloud", "baijiacloud.domain");
            video_sinker_domain = PropertiesReader.getValue("cloud", "video.sinker.domain");
            baseUrl = baijiaCloudDomain + "/openapi/room/";
            playbackUrl = baijiaCloudDomain + "/openapi/playback/getStatus";
        }catch (Exception e){
            log.error("can not read properties! error:{}", e);
        }
    }
    
    public DefaultApiResult create(LiveRoomCreate liveRoom){
        
        Map<String, String> params = Maps.newHashMap();
        
        init(params);
        params.put("title", liveRoom.getTitle());
        params.put("start_time", liveRoom.getStart_time().toString());
        params.put("end_time", liveRoom.getEnd_time().toString());
        params.put("type", liveRoom.getType().toString());
        params.put("media_type", liveRoom.getMedia_type().toString());
        params.put("max_users", liveRoom.getMax_users().toString());
        params.put("pre_enter_time", liveRoom.getPre_enter_time().toString());
        
        buidlSign(params);
        
        String str = HttpClientUtils.doPost(baseUrl+"create", params);
        
        return JSON.parseObject(str, DefaultApiResult.class);
    }
    
    public DefaultApiResult update(LiveRoomUpdate liveRoom){
        
        Map<String, String> params = Maps.newHashMap();
        
        init(params);
        
        params.put("room_id", liveRoom.getRoom_id());
        params.put("title", liveRoom.getTitle());
        params.put("start_time", liveRoom.getStart_time().toString());
        params.put("end_time", liveRoom.getEnd_time().toString());
        params.put("type", liveRoom.getType().toString());
        params.put("media_type", liveRoom.getMedia_type().toString());
        params.put("max_users", liveRoom.getMax_users().toString());
        params.put("pre_enter_time", liveRoom.getPre_enter_time().toString());
        
        buidlSign(params);
        
        String str = HttpClientUtils.doPost(baseUrl+"update", params);
        return JSON.parseObject(str, DefaultApiResult.class);
    }
    
    public DefaultApiResult delete(LiveRoomDelete liveRoom){
        
        Map<String, String> params = Maps.newHashMap();
        
        init(params);
        
        params.put("room_id", liveRoom.getRoom_id());
        
        buidlSign(params);
        
        String str = HttpClientUtils.doPost(baseUrl+"delete", params);
        return JSON.parseObject(str, DefaultApiResult.class);
    }
    
    /**
     * 分页获取视频列表直播室信息
     * 
     * @param page
     * @param limit
     * @return
     */
        
    public String list(Integer page, Integer limit){
        
        Map<String, String> params = Maps.newHashMap();
        
        init(params);
        
        params.put("page", page.toString());
        params.put("limit", limit.toString());
        
        buidlSign(params);
        
        String str = HttpClientUtils.doPost(baseUrl+"list", params);
        
        return str;
    }
    
    /**
     * 获取云端录制状态
     * @param room_id
     * @return
     */
        
    public DefaultApiResult playbackStatus(String room_id){
        
        Map<String, String> params = Maps.newHashMap();
        
        init(params);
        
        params.put("room_id", room_id);
        
        buidlSign(params);
        
        String str = HttpClientUtils.doPost(playbackUrl, params);
        
        return JSON.parseObject(str, DefaultApiResult.class);
    }
    
    /**
     * 获取直播室在线人数
     * @param room_id
     * @return
     */
        
    public Map<String,Integer> getRoomsUserCount(Collection<Long> roomIds){
        
        Map<String, Object> params = Maps.newHashMap();
        
        List<Object> roomIdStrs = Lists.newArrayList();
        for(Long roomId:roomIds){
            String roomIdStr = String.valueOf(roomId);
            roomIdStrs.add(roomIdStr);
        }
        
        
        params.put("class_list", roomIdStrs);
       
        
        String str = null;
        try {
            str = HttpClientUtils.doJsonPostNew(video_sinker_domain+"/user_counts", params, "UTF-8");
            return (Map<String,Integer>)JSON.parseObject(str,Map.class);
        } catch (Exception e) {
            log.warn("getRoomsUserCount", e);
            return Maps.newHashMap();
        }
    }
    
    
    
    
    
    
    public static void main(String[] args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        LiveRoomCreate liveRoom = new LiveRoomCreate();
        liveRoom.setTitle("abcc");
        Date now = new Date();
        liveRoom.setStart_time(DateUtil.date2UnixTimestamp(now));
        liveRoom.setEnd_time(DateUtil.date2UnixTimestamp(DateUtil.addHour(now,1)));
        liveRoom.setMax_users(5);
        
        LiveRoomApi api = new LiveRoomApi();
        api.create(liveRoom);
        
    }
}