/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomMenuDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomMenu;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.CustomMenuService;
import com.baijia.tianxiao.sal.wechat.api.WechatFreeVersionService;
import com.baijia.tianxiao.sal.wechat.constant.custommenu.FreeVersionMenuClick;
import com.baijia.tianxiao.sal.wechat.constant.custommenu.MenuCustomJsonKey;
import com.baijia.tianxiao.sal.wechat.constant.custommenu.WechatMenuJsonKey;
import com.baijia.tianxiao.sal.wechat.dto.custommenu.CustomMenuBtn;
import com.baijia.tianxiao.sal.wechat.dto.custommenu.CustomMenuDto;
import com.baijia.tianxiao.sal.wechat.dto.custommenu.MenuConvertResult;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuBtnBuilder;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuJsonConverter;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;

/**   
 * @title       : CustomMenuServiceImpl 
 * @description : 微信自定义菜单
 * @author      : zhenyujian
 * @date        : 2016年1月8日 下午3:07:37 
 */
@Slf4j
@Service
public class CustomMenuServiceImpl implements CustomMenuService{

    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private WechatFreeVersionService freeVersionService;
    
	@Autowired
	private OrgWechatCustomMenuDao orgWechatCustomMenuDao;
	@Autowired
	private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
	
	
    
	
	@Override
	public boolean syncCustomMenu(int orgId) {
		return false;
	}
	
	
	
	@Transactional(rollbackFor = Exception.class)
	@Override
	public void saveAndBuildCustomMenu(int orgId, String menuJson) {
		AuthorizationInfo authorizationInfo = authorizationInfoService.refreshAccessToken(orgId);
		AuthorizerInfo authorizerInfo = authorizerInfoDao.getByOrgId(orgId);
		
		//权限判断
		WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MENU);
		
		OrgWechatCustomMenu menu = orgWechatCustomMenuDao.getByAuthorizerAppId(authorizationInfo.getAuthorizerAppId());
		OrgAccount orgAccount = orgAccountDao.getAccountById(authorizationInfo.getOrgId());
		OrgWechatDto orgWechatDto = new OrgWechatDto(orgAccount.getId(), orgAccount.getNumber(), authorizationInfo.getAuthorizerAppId());
		
		//json格式转换 
		MenuConvertResult result = null;
		try{
			result = WechatMenuJsonConverter.customJsonToWechatMenuJson(orgWechatDto, menuJson);
		}catch(ParameterException e){
			log.warn("saveAndBuildCustomMenu- orgWechatDto:{},menuJson:{}", orgWechatDto, menuJson);
			log.warn("saveAndBuildCustomMenu- exception",e);
			throw e;
		}catch(Exception e){
			log.warn("saveAndBuildCustomMenu- orgWechatDto:{},menuJson:{}", orgWechatDto, menuJson);
			log.error("saveAndBuildCustomMenu- exception",e);
			return;
		}
		
		Date now = new Date();
		if(result.getWechatJson()!=null){
			if(menu==null){
				menu = new OrgWechatCustomMenu();
				menu.setAuthorizerAppId(authorizationInfo.getAuthorizerAppId());
				menu.setCreateTime(now);
				menu.setUpdateTime(now);
				menu.setJson(result.getCustomJson());
				orgWechatCustomMenuDao.save(menu, true);
			}else{
				menu.setUpdateTime(now);
				menu.setJson(result.getCustomJson());
				orgWechatCustomMenuDao.update(menu, true);
			}
			
			//生成自定义菜单
			WechatMenuApiHelper.createMenu(authorizationInfo.getAuthorizerAccessToken(), result.getWechatJson());
		}else{
			if(menu!=null){
				orgWechatCustomMenuDao.delById(menu.getId());
				WechatMenuApiHelper.deleteMenu(authorizationInfo.getAuthorizerAccessToken());
			}
		}
	}

	
	
	@Transactional(rollbackFor = Exception.class)
	@Override
	public CustomMenuDto getCustomMenu(int orgId) {
		CustomMenuDto dto = null;
		AuthorizerInfo authorizerInfo = authorizerInfoDao.getByOrgId(orgId);
		AuthorizationInfo authorizationInfo = authorizationInfoService.refreshAccessToken(orgId);
		
		//权限判断
		WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MENU);
		
		OrgWechatCustomMenu menu = orgWechatCustomMenuDao.getByAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
		
		
		if(menu ==null){
			try{
				//同步微信menu数据
				WechatApiResponse result = WechatMenuApiHelper.getMenu(authorizationInfo.getAuthorizerAccessToken());
				String wechatJson = result.getJsonStr();
				MenuConvertResult mcResult = WechatMenuJsonConverter.wechatMenuJsonToCustomJson(wechatJson);
				if(mcResult.getCustomJson()!=null){
					Date now = new Date();
					menu = new OrgWechatCustomMenu();
					menu.setAuthorizerAppId(authorizationInfo.getAuthorizerAppId());
					menu.setCreateTime(now);
					menu.setUpdateTime(now);
					menu.setJson(mcResult.getCustomJson());
					orgWechatCustomMenuDao.save(menu, true);
				}
			}catch(Exception e){
			}
		}
		
		if( menu!=null ){
			dto = new CustomMenuDto();
			dto.setAuthorizerAppId( menu.getAuthorizerAppId() );
			dto.setCreateTime( menu.getCreateTime() );
			dto.setId( menu.getId() );
			dto.setJson( menu.getJson() );
		}
		
		return dto;
	}



	@Transactional(rollbackFor = Exception.class)
	@Override
	public String getQuickMenuJson(int orgId) {
		AuthorizerInfo authorizerInfo = authorizerInfoDao.getByOrgId(orgId);
		OrgAccount orgAccount = orgAccountDao.getAccountById(authorizerInfo.getOrgId());
		OrgInfo orgInfo = orgInfoDao.getOrgInfo(authorizerInfo.getOrgId());
		OrgWechatDto orgWechatDto = new OrgWechatDto(orgAccount.getId(), orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());
		
		JSONObject json = new JSONObject();
		JSONArray btnArray = new JSONArray();
		CustomMenuBtn btn;
		List<CustomMenuBtn> subButton;
		
		//菜单1
		subButton = new ArrayList<CustomMenuBtn>();
		subButton.add( CustomMenuBtn.buildViewBtn(MediaType.WANGXIAOZHUYE, orgWechatDto) );
		subButton.add( CustomMenuBtn.buildViewBtn(MediaType.KECHENGLIEBIAO, orgWechatDto) );
		subButton.add( CustomMenuBtn.buildViewBtn(MediaType.XIAOQUDIZHI, orgWechatDto) );
		if(StringUtils.isNotBlank(orgInfo.getExtension())){
			subButton.add( CustomMenuBtn.buildTextBtn(MediaType.DIANHUA, WechatProperties.getMobileNumber400Main()+"转"+orgInfo.getExtension(), orgWechatDto));
		}else{
			subButton.add( CustomMenuBtn.buildTextBtn(MediaType.DIANHUA, "该机构尚未配置400电话.", orgWechatDto));
		}
		subButton.add( CustomMenuBtn.buildTextBtn(MediaType.ZAIXIANZIXUN, "请点击页面左下方的键盘按钮，切换到在线交谈模式。", orgWechatDto));
		btn = CustomMenuBtn.buildHierarchyBtn(MediaType.WEIGUANWANG, orgWechatDto, subButton);
		btnArray.add( btn.toJson() );
		
		//菜单2
		btnArray.add( CustomMenuBtn.buildViewBtn(MediaType.YUYUESHITING, orgWechatDto).toJson() );
		
		//菜单3
		if(authorizerInfo.hasWebAuthPermission()){
			subButton = new ArrayList<CustomMenuBtn>();
			subButton.add( CustomMenuBtn.buildViewBtn(MediaType.XUESHENGZHONGXIN, orgWechatDto) );
			subButton.add( CustomMenuBtn.buildViewBtn(MediaType.LAOSHIZHONGXIN, orgWechatDto) );
			btn = CustomMenuBtn.buildHierarchyBtn(MediaType.GERENZHONGXIN, orgWechatDto, subButton);
			btnArray.add(btn.toJson());
		}
		json.put(MenuCustomJsonKey.BUTTON, btnArray);
		
		return json.toString();
	}


	@Transactional(rollbackFor = Exception.class)
	@Override
	public void mediaTypeConvert() {
		List<OrgWechatCustomMenu> list= orgWechatCustomMenuDao.getAll();
		log.info("mediaTypeConvert list size:{}",list);
		for(OrgWechatCustomMenu menu:list){
			String json = menu.getJson();
			json = json.replace("\"mediaType\":\"15\",\"name\":\"预约试听\"", "\"mediaType\":\"23\",\"name\":\"预约试听\"");
			json = json.replace("\"mediaType\":\"15\",\"name\":\"校区地址\"", "\"mediaType\":\"20\",\"name\":\"预约试听\"");
			json = json.replace("\"mediaType\":\"15\",\"name\":\"学生中心\"", "\"mediaType\":\"25\",\"name\":\"预约试听\"");
			json = json.replace("\"mediaType\":\"15\",\"name\":\"老师中心\"", "\"mediaType\":\"26\",\"name\":\"预约试听\"");
			json = json.replace("\"mediaType\":\"6\",\"name\":\"400电话\"", "\"mediaType\":\"21\",\"name\":\"预约试听\"");
			json = json.replace("\"mediaType\":\"6\",\"name\":\"在线咨询\"", "\"mediaType\":\"22\",\"name\":\"预约试听\"");
			menu.setJson(json);
			orgWechatCustomMenuDao.update(menu);
		}
	}



	@Override
	public String createMenuForFreeVersion() {
		AuthorizerInfo authorizerInfo = freeVersionService.getFAAuthorizerInfo();
		AuthorizationInfo authorizationInfo = authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
		
		JSONObject json = new JSONObject();
		JSONArray btnArray = new JSONArray();
		
		btnArray.add( WechatMenuBtnBuilder.clickBtn(FreeVersionMenuClick.STUDNET_CENTER.getName(), FreeVersionMenuClick.STUDNET_CENTER.getKey()) );
		btnArray.add( WechatMenuBtnBuilder.clickBtn(FreeVersionMenuClick.TEACHER_CENTER.getName(), FreeVersionMenuClick.TEACHER_CENTER.getKey()) );
		
		json.put(WechatMenuJsonKey.BUTTON, btnArray);
		
		WechatMenuApiHelper.createMenu(authorizationInfo.getAuthorizerAccessToken(), json.toString());
		return json.toString();
	}
	
}

