/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.industry;

import java.util.HashMap;
import java.util.Map;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatRemoteCallHelper;

/**   
 * @Title       : WechatTemplateMsgCaller
 * @Description : 公众号所属行业
 * 				  http://mp.weixin.qq.com/wiki/5/6dde9eaa909f83354e0094dc3ad99e05.html
 * @Author      : zhenyujian
 * @Date        : 2015年7月8日 下午3:58:48 
 * @Version     : v1.0   
 */
public class WechatIndustryCaller {
	
	
	/**
	 * @Description  : 查询公众号所属行业
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午1:38:43 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse getIndustry(String accessToken){
		String url = "https://api.weixin.qq.com/cgi-bin/template/get_industry?access_token="+accessToken;
		return WechatRemoteCallHelper.get(url);
	}
	
	
	/**
	 * @Description  : 设置公众号所属行业
	 * @Author       : zhenyujian
	 * @CreationDate : 2015年7月8日 下午5:08:48 
	 *
	 * @Return       : void
	 */
	public static WechatApiResponse setIndustry(String accessToken, Integer industryId1,Integer industryId2){
		String url = "https://api.weixin.qq.com/cgi-bin/template/api_set_industry?access_token="+accessToken;
		
		Map<String,Object> params = new HashMap<String,Object>();
		params.put("industry_id1", industryId1);
		params.put("industry_id2", industryId2);
		return WechatRemoteCallHelper.postJson(url, params);
	}
	
}

