/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.templatemsg.coursesignin;

import java.text.SimpleDateFormat;

import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.WechatTemplateMsg;

import net.sf.json.JSONObject;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**   
 * @title       : CourseStartNoticeMsg 
 * @description : 签到成功提醒 - 学生
 * @author      : zhenyujian
 * @date        : 2016年1月5日 下午9:05:03 
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class CourseSigninSuccMsgToStu extends WechatTemplateMsg{
	
	private Integer orgId;
	private String openId;
	
	private String orgName;
	private String courseName;
	private String studentName;
	private String teacherName;
	private Integer lessonNo;//第几节课
	private Long signinTime;//签到时间 
	private String orgMobile;
	
	
	public CourseSigninSuccMsgToStu(){
		this.msgType = WechateTemplateMsgType.COURSE_SIGNIN_TO_STU;
	}
	
	
	
	/**
	 * @Description  : 创建微信模板消息 用于调用微信api
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午12:50:29 
	 *
	 * @Return       : String
	 */
	public String buildTemplateMsg(String templateId){
		SimpleDateFormat datetTimeSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
		this.first = String.format("【%s】,您好:\n\n您已在【%s】的【%s】【第%s次课】中签到。\n",
									studentName, orgName, courseName, lessonNo);
		
		this.remark = String.format("\n如对签到情况有疑问，请致电【%s】", orgMobile);
		
		JSONObject data = new JSONObject();
		data.put("keyword1", getTemplateMsgNode( studentName ) );
		data.put("keyword2", getTemplateMsgNode( datetTimeSdf.format(signinTime) ) );
		data.put("keyword3", getTemplateMsgNode( courseName ) );
		data.put("keyword4", getTemplateMsgNode( teacherName ) );
		
		return super.buildBaseTemplateMsg(openId, templateId, data).toString();
	}
	
	
	
	/**
	 * @Description  : json转换成对象
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午12:29:30 
	 *
	 * @Return       : CourseStartNoticeMsg
	 */
	public static CourseSigninSuccMsgToStu fromJsonStr(String jsonStr){
		CourseSigninSuccMsgToStu msg = new CourseSigninSuccMsgToStu();
		
		JSONObject json = JSONObject.fromObject(jsonStr);
		msg.fillBaseInfo(jsonStr);
		msg.setOrgId( json.optInt("orgId") );
		msg.setOpenId( json.getString("openId"));

		msg.setOrgName( json.optString("orgName") );
		msg.setCourseName( json.optString("courseName") );
		msg.setStudentName( json.optString("studentName") );
		msg.setTeacherName( json.optString("teacherName") );
		msg.setLessonNo( json.optInt("lessonNo") );
		msg.setSigninTime( json.optLong("signinTime") );
		msg.setOrgMobile( json.optString("orgMobile") );

		return msg;
	}
	
	
	
	/**
	 * @Description  : 对象转换成json
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午12:29:38 
	 *
	 * @Return       : String
	 */
	public String toJsonStr(){
		JSONObject json = super.getBaseJson();
		json.put("orgId", checkNull(this.orgId) );
		json.put("openId", checkNull(this.openId));

		json.put("orgName", checkNull(this.orgName));
		json.put("courseName", checkNull(this.courseName));
		json.put("studentName", checkNull(this.studentName));
		json.put("teacherName", checkNull(this.teacherName));
		json.put("lessonNo", checkNull(this.lessonNo));
		json.put("signinTime", checkNull(this.signinTime));
		json.put("orgMobile", checkNull(this.orgMobile));
		
		return json.toString();
	}
	
	
	public void setOrgId(Integer orgId){
		this.orgId = orgId;
	}
	public void setOrgId(Long orgId){
		this.orgId = Integer.parseInt(orgId.toString());
	}
}

