/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.fans;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.baijia.tianxiao.dal.wechat.po.Fans;

import lombok.Data;

/**   
 * @title       : FansListRecordDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2015年12月8日 下午9:16:13 
 */
@Data
public class FansListRecordDto {
    private Integer id;
    private Long consultUserId;
	private String openId;
	private String showName;//展示名称
	private Integer subscribe;//是否关注
	private Long subscribeTime;//关注时间 秒级时间戳
	private String headImgUrl;//头像
	private Integer chat;//是否可以聊天
	private Integer userRole;//用户角色
	
	
	public static FansListRecordDto build(Fans fans){
		FansListRecordDto dto = new FansListRecordDto();
		dto.setId( fans.getId() );
		dto.setOpenId( fans.getOpenId() );
		dto.setShowName( fans.getShowName() );
		dto.setSubscribe( fans.getSubscribe() );
		dto.setSubscribeTime( fans.getSubscribeTime().getTime() );
		dto.setHeadImgUrl( fans.getHeadImgUrl() );
		dto.setChat( fans.isAllowToChat() ? 1:0 );
		return dto;
	}
	
	
	public static List<FansListRecordDto> buildList(List<Fans> fansList){
		List<FansListRecordDto> list = new ArrayList<FansListRecordDto>();
		FansListRecordDto dto;
		if(fansList!=null && !fansList.isEmpty()){
			for(Fans fans:fansList){
				dto = new FansListRecordDto();
				dto.setId( fans.getId() );
				dto.setOpenId( fans.getOpenId() );
				dto.setShowName( fans.getShowName() );
				dto.setSubscribe( fans.getSubscribe() );
				dto.setSubscribeTime( fans.getSubscribeTime().getTime() );
				dto.setHeadImgUrl( fans.getHeadImgUrl() );
				dto.setChat( fans.isAllowToChat() ? 1:0 );
				list.add(dto);
			}
		}
		return list;
	}
	
	
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
}

