/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.callservice.dao.TX400PhoneDao;
import com.baijia.tianxiao.dal.callservice.po.TX400Phone;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.SubscribeQRCodeDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.SubscribeQRCode;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.image.OrgQrImageUtils;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.WechatFreeVersionService;
import com.baijia.tianxiao.sal.wechat.api.WechatQRCodeService;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.HeadQRCodeInfoDto;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeDto;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.qrcode.WechatQRCodeLinkHelper;
import com.baijia.tianxiao.sal.wechat.util.FileUploadUtils;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Date;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WechatQRCodeServiceImpl
implements WechatQRCodeService {
    private static final Logger log = LoggerFactory.getLogger(WechatQRCodeServiceImpl.class);
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private SubscribeQRCodeDao subscribeQRCodeDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private TX400PhoneDao tx400PhoneDao;
    @Autowired
    private WechatFreeVersionService freeVersionService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String getQRCodeHeadImgUrl(Integer orgId) {
        SubscribeQRCode code = this.getQRCode(orgId);
        return code != null ? code.getHeadQrCode() : null;
    }

    @Override
    public SubscribeQRCode getQRCode(Integer orgId) {
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(orgId);
        boolean isFreeAccount = false;
        if (authorizerInfo == null) {
            if (this.freeVersionService.isFreeAccount(orgId)) {
                authorizerInfo = this.freeVersionService.getFAAuthorizerInfo();
                isFreeAccount = true;
            } else {
                log.warn("wechat - SubscribeQRCodeServiceImpl - getQRCodeUrl - authorizationInfo is null");
                return null;
            }
        }
        SubscribeQRCode qrCode = this.subscribeQRCodeDao.getQRCode(orgId, authorizerInfo.getAuthorizerAppId());
        String qrCodeImgUrl = null;
        String headQRCodeImgUrl = null;
        if (qrCode == null) {
            block10: {
                try {
                    if (isFreeAccount) {
                        String accessToken = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId()).getAuthorizerAccessToken();
                        QRCodeDto qrCodeDto = WechatQRCodeLinkHelper.getQRCodeDtoForSubscribeWithOrgId(accessToken, orgId);
                        qrCodeImgUrl = WechatQRCodeLinkHelper.getGsxImgUrl(qrCodeDto);
                        break block10;
                    }
                    if (authorizerInfo.getQrcodeStorageId() != null) {
                        OrgStorage orgStorage = this.orgStorageDao.getById(authorizerInfo.getQrcodeStorageId().intValue());
                        qrCodeImgUrl = orgStorage == null ? authorizerInfo.getQrcodeUrl() : StorageUtil.constructUrl(orgStorage.getFid(), orgStorage.getSn(), orgStorage.getMimeType());
                        break block10;
                    }
                    log.error("wechat - SubscribeQRCodeServiceImpl - getQRCodeUrl - QrcodeStorageId is null");
                    return null;
                }
                catch (Exception e) {
                    log.error("wechat - SubscribeQRCodeServiceImpl - getQRCodeUrl - exception", (Throwable)e);
                    return null;
                }
            }
            headQRCodeImgUrl = this.makeHeadQRCodeImgUrl(orgId, qrCodeImgUrl, authorizerInfo.getNickName(), authorizerInfo.getHeadImg());
            qrCode = new SubscribeQRCode();
            qrCode.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
            qrCode.setHeadQrCode(headQRCodeImgUrl);
            qrCode.setQrCode(qrCodeImgUrl);
            qrCode.setCreateTime(new Date());
            qrCode.setOrgId(Integer.valueOf(orgId));
            qrCode.setHeadQrCode(this.makeHeadQRCodeInfo(orgId, authorizerInfo).toJsonStr());
            this.subscribeQRCodeDao.save((Object)qrCode, new String[0]);
        }
        String newHeadQrCodeInfo = this.makeHeadQRCodeInfo(orgId, authorizerInfo).toJsonStr();
        if (!qrCode.getHeadQrCodeInfo().equals(newHeadQrCodeInfo)) {
            headQRCodeImgUrl = this.makeHeadQRCodeImgUrl(orgId, qrCode.getQrCode(), authorizerInfo.getNickName(), authorizerInfo.getHeadImg());
            qrCode.setHeadQrCode(headQRCodeImgUrl);
            qrCode.setHeadQrCodeInfo(newHeadQrCodeInfo);
            this.subscribeQRCodeDao.update((Object)qrCode, new String[0]);
        }
        return qrCode;
    }

    String makeHeadQRCodeImgUrl(Integer orgId, String qrCodeImgUrl, String wxNick, String wxHeadImgUrl) {
        String headQRCodeImgUrl;
        block8: {
            headQRCodeImgUrl = null;
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
            File localFile = null;
            UploadResult result = null;
            String name = StringUtils.isNotBlank((CharSequence)orgInfo.getName()) ? orgInfo.getName() : orgInfo.getShortName();
            try {
                try {
                    BufferedImage image = OrgQrImageUtils.generateOrgQrFingerPrintImg((String)name, (String)qrCodeImgUrl, (String)this.getOrg400Tel(orgInfo), (String)wxNick, (String)wxHeadImgUrl);
                    localFile = new File(LocalFileHelper.getTmpFileName(MIMEType.JPG.getExtension()));
                    ImageIO.write((RenderedImage)image, MIMEType.JPG.getExtension(), localFile);
                    result = FileUploadUtils.uploadToRemote(Long.parseLong("" + orgId), localFile, false);
                    headQRCodeImgUrl = ((UploadResult.UploadFile)result.getFiles().get(0)).getUrl();
                }
                catch (Exception e) {
                    log.error("makeHeadQRCodeImgUrl - exception", (Throwable)e);
                    if (localFile != null) {
                        LocalFileHelper.deleteFile(localFile);
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (localFile != null) {
                    LocalFileHelper.deleteFile(localFile);
                }
                throw throwable;
            }
            if (localFile != null) {
                LocalFileHelper.deleteFile(localFile);
            }
        }
        return headQRCodeImgUrl;
    }

    HeadQRCodeInfoDto makeHeadQRCodeInfo(Integer orgId, AuthorizerInfo authorizerInfo) {
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
        String name = StringUtils.isNotBlank((CharSequence)orgInfo.getName()) ? orgInfo.getName() : orgInfo.getShortName();
        HeadQRCodeInfoDto dto = new HeadQRCodeInfoDto();
        dto.setOrgShowName(name);
        dto.setWechatAppNick(authorizerInfo.getNickName());
        dto.setWechatAppHeadImg(authorizerInfo.getHeadImg());
        dto.set_400Str(this.getOrg400Tel(orgInfo));
        return dto;
    }

    String getOrg400Tel(OrgInfo orgInfo) {
        String content = "";
        TX400Phone tx400Phone = this.tx400PhoneDao.getByOrgId(orgInfo.getOrgId());
        content = tx400Phone != null && !Flag.getBoolean((Integer)tx400Phone.getIsdel()) ? tx400Phone.getPhone400() : String.valueOf(WechatProperties.getMobileNumber400Main()) + "\u8f6c" + orgInfo.getExtension();
        return content;
    }
}

