/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.util;

import com.baijia.tianxiao.sal.wechat.util.WeixinUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeixinTemplateContext {
    private static final Logger log = LoggerFactory.getLogger(WeixinTemplateContext.class);
    public static final String FIRST = "first";
    public static final String REMARK = "remark";
    public static final String TOP_COLOR = "topcolor";
    public static final String TO_USER = "touser";
    public static final String TEMPLATE_ID = "template_id";
    public static final String URL = "url";
    public static final String DATA = "data";
    private JSONObject json = new JSONObject();
    private JSONObject data = new JSONObject();
    private String topcolor = "#333333";
    private String touser = "";
    private String templateId = "";
    private String url = "";

    public WeixinTemplateContext setTopcolor(String color) {
        if (GenericsUtils.isNullOrEmpty((Object)color)) {
            color = "#333333";
        }
        this.topcolor = color;
        return this;
    }

    public WeixinTemplateContext setToUser(String toUser) {
        this.touser = toUser;
        return this;
    }

    public WeixinTemplateContext setTemplateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    public WeixinTemplateContext setUrl(String url) {
        this.url = url;
        return this;
    }

    public WeixinTemplateContext setFirst(String value, String color) {
        this.data.put((Object)FIRST, (Object)WeixinUtils.getTemplateMsgNode(value, color));
        return this;
    }

    public WeixinTemplateContext setFirst(String value) {
        return this.setFirst(value, "");
    }

    public WeixinTemplateContext setRemark(String value, String ... color) {
        String colorTmp = this.getColor(color);
        WeixinUtils.getTemplateMsgNode(value, colorTmp);
        return this;
    }

    public WeixinTemplateContext addNode(String key, String value, String ... color) {
        if (GenericsUtils.isNullOrEmpty((Object)key)) {
            log.debug("key is null or empty for value:{} ", (Object)value);
            return this;
        }
        String colorTmp = this.getColor(color);
        this.data.put((Object)key, (Object)WeixinUtils.getTemplateMsgNode(value, colorTmp));
        return this;
    }

    private String getColor(String ... color) {
        String colorTmp = GenericsUtils.isNullOrEmpty((Object)color) ? "" : color[0];
        return colorTmp;
    }

    public static WeixinTemplateContext instance() {
        return new WeixinTemplateContext();
    }

    public JSONObject createData() {
        this.json.put((Object)TO_USER, (Object)this.touser);
        this.json.put((Object)TEMPLATE_ID, (Object)this.templateId);
        this.json.put((Object)URL, (Object)this.url);
        this.json.put((Object)TOP_COLOR, (Object)this.topcolor);
        this.json.put((Object)DATA, (Object)this.data);
        return this.json;
    }
}

