/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.sendmsg.customer;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.SalWechatErrorCode;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.sendmsg.customer.CustomerServiceApiCaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerServiceApiHelper {
    private static final Logger log = LoggerFactory.getLogger(CustomerServiceApiHelper.class);

    public static WechatApiResponse sendTextMsg(String accessToken, String toOpenId, String content) throws WechatException, WebServiceException {
        log.info("wechat - CustomerServiceApiHelper - sendTextMsg");
        try {
            return CustomerServiceApiCaller.sendTextMsg(accessToken, toOpenId, content);
        }
        catch (WechatException e) {
            if (e.getErrorCode() == SalWechatErrorCode.WECHAT_ILLEGAL_OPENID) {
                throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_SEND_MESSAGE_FAIL);
            }
            throw e;
        }
    }

    public static WechatApiResponse sendImageMsg(String accessToken, String toOpenId, String mediaId) throws WechatException, WebServiceException {
        log.info("wechat - CustomerServiceApiHelper - sendImageMsg");
        try {
            return CustomerServiceApiCaller.sendImageMsg(accessToken, toOpenId, mediaId);
        }
        catch (WechatException e) {
            if (e.getErrorCode() == SalWechatErrorCode.WECHAT_ILLEGAL_OPENID) {
                throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_SEND_MESSAGE_FAIL);
            }
            throw e;
        }
    }

    public static WechatApiResponse sendVoiceMsg(String accessToken, String toOpenId, String mediaId) throws WechatException, WebServiceException {
        log.info("wechat - CustomerServiceApiHelper - sendVoiceMsg");
        try {
            return CustomerServiceApiCaller.sendVoiceMsg(accessToken, toOpenId, mediaId);
        }
        catch (WechatException e) {
            if (e.getErrorCode() == SalWechatErrorCode.WECHAT_ILLEGAL_OPENID) {
                throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_SEND_MESSAGE_FAIL);
            }
            throw e;
        }
    }
}

