/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.qrcode;

import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.constant.qrcode.WechatQRCodeAction;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatRemoteCallHelper;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import java.net.URLEncoder;
import lombok.NonNull;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatQRCodeCaller {
    private static final Logger log = LoggerFactory.getLogger(WechatQRCodeCaller.class);

    public static WechatApiResponse createPermanentQRCode(String accessToken, String sceneStr) {
        if (StringUtils.isBlank((CharSequence)sceneStr)) {
            sceneStr = "unknown";
        }
        String json = "{\"action_name\": \"%s\", \"action_info\": {\"scene\": {\"scene_str\": \"%s\"}}}";
        json = String.format(json, WechatQRCodeAction.QR_LIMIT_STR_SCENE.getValue(), sceneStr);
        StringBuilder builder = new StringBuilder("https://api.weixin.qq.com/cgi-bin/qrcode/create?");
        builder.append("&access_token=").append(accessToken);
        return WechatRemoteCallHelper.postJsonObj(builder.toString(), JSONObject.fromObject((Object)json));
    }

    public static WechatApiResponse createPermanentQRCode(String accessToken, @NonNull Integer sceneId) {
        if (sceneId == null) {
            throw new NullPointerException("sceneId");
        }
        String json = "{\"action_name\": \"%s\", \"action_info\": {\"scene\": {\"scene_id\": %s}}}";
        json = String.format(json, WechatQRCodeAction.QR_LIMIT_SCENE.getValue(), sceneId);
        StringBuilder builder = new StringBuilder("https://api.weixin.qq.com/cgi-bin/qrcode/create?");
        builder.append("&access_token=").append(accessToken);
        return WechatRemoteCallHelper.postJsonObj(builder.toString(), JSONObject.fromObject((Object)json));
    }

    public static WechatApiResponse createTemporaryQRCode(@NonNull String accessToken, @NonNull Integer sceneId) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken");
        }
        if (sceneId == null) {
            throw new NullPointerException("sceneId");
        }
        String json = "{\"expire_seconds\": 2592000, \"action_name\": \"%s\", \"action_info\": {\"scene\": {\"scene_id\": %s}}}";
        json = String.format(json, WechatQRCodeAction.QR_SCENE.getValue(), sceneId);
        StringBuilder builder = new StringBuilder("https://api.weixin.qq.com/cgi-bin/qrcode/create?");
        builder.append("&access_token=").append(accessToken);
        return WechatRemoteCallHelper.postJsonObj(builder.toString(), JSONObject.fromObject((Object)json));
    }

    public static WechatApiResponse createTemporaryQRCode(String accessToken, String sceneStr) {
        String json = "{\"expire_seconds\": 2592000, \"action_name\": \"%s\", \"action_info\": {\"scene\": {\"scene_str\": \"%s\"}}}";
        json = String.format(json, WechatQRCodeAction.QR_STR_SCENE.getValue(), sceneStr);
        StringBuilder builder = new StringBuilder("https://api.weixin.qq.com/cgi-bin/qrcode/create?");
        builder.append("&access_token=").append(accessToken);
        return WechatRemoteCallHelper.postJsonObj(builder.toString(), JSONObject.fromObject((Object)json));
    }

    public static byte[] downloadQRCodeImage(String ticket) throws WechatException, WebServiceException, Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("https://mp.weixin.qq.com/cgi-bin/showqrcode?").append("ticket=").append(URLEncoder.encode(ticket, "utf8"));
        log.info("wechat - downloadQRCodeImage - url", (Object)builder.toString());
        return HttpClientUtils.download((String)builder.toString());
    }
}

