/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.dto.qrcode;

import com.baijia.tianxiao.sal.wechat.constant.qrcode.QRCodeType;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeSceneStr;
import org.apache.commons.lang3.StringUtils;

public class QRCodeSceneStrSceneId
extends QRCodeSceneStr {
    private static final String JSON_KEY_SCENE_ID = "sceneId";
    private static final String JSON_KEY_ORG_ID = "orgId";
    private Long sceneId;
    private Long orgId;

    public QRCodeSceneStrSceneId() {
        this.qrCodeType = QRCodeType.QR_SCENE;
    }

    public QRCodeSceneStrSceneId(Long orgId, Long sceneId) {
        this();
        this.orgId = orgId;
        this.sceneId = sceneId;
    }

    @Override
    public String getSceneStr() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.getSceneStr());
        builder.append(QRCodeSceneStr.createSceneStrParam(JSON_KEY_ORG_ID, this.orgId));
        builder.append(QRCodeSceneStr.createSceneStrParam(JSON_KEY_SCENE_ID, this.sceneId));
        return builder.toString();
    }

    public static QRCodeSceneStrSceneId fromSceneStr(String str) {
        Long sceneId = null;
        Long orgId = null;
        if (StringUtils.isNumeric((CharSequence)str)) {
            sceneId = Long.valueOf(str);
        } else if (str.startsWith("qrscene_") && StringUtils.isNumeric((CharSequence)str.replace("qrscene_", ""))) {
            str = str.replace("qrscene_", "");
            sceneId = Long.valueOf(str);
        } else {
            String sceneIdStr = QRCodeSceneStr.parseSceneStrParam(str, JSON_KEY_SCENE_ID);
            String orgIdStr = QRCodeSceneStr.parseSceneStrParam(str, JSON_KEY_ORG_ID);
            sceneId = StringUtils.isNumeric((CharSequence)sceneIdStr) ? Long.valueOf(Long.parseLong(sceneIdStr)) : null;
            orgId = StringUtils.isNumeric((CharSequence)orgIdStr) ? Long.valueOf(Long.parseLong(orgIdStr)) : null;
        }
        return new QRCodeSceneStrSceneId(orgId, sceneId);
    }

    public Long getSceneId() {
        return this.sceneId;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setSceneId(Long sceneId) {
        this.sceneId = sceneId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    @Override
    public String toString() {
        return "QRCodeSceneStrSceneId(sceneId=" + this.getSceneId() + ", orgId=" + this.getOrgId() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QRCodeSceneStrSceneId)) {
            return false;
        }
        QRCodeSceneStrSceneId other = (QRCodeSceneStrSceneId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$sceneId = this.getSceneId();
        Long other$sceneId = other.getSceneId();
        if (this$sceneId == null ? other$sceneId != null : !((Object)this$sceneId).equals(other$sceneId)) {
            return false;
        }
        Long this$orgId = this.getOrgId();
        Long other$orgId = other.getOrgId();
        return !(this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof QRCodeSceneStrSceneId;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $sceneId = this.getSceneId();
        result = result * 59 + ($sceneId == null ? 43 : ((Object)$sceneId).hashCode());
        Long $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        return result;
    }
}

