/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.validator;

import com.baijia.tianxiao.exception.ParameterException;

/**   
 * @title       : CustomMenuValidator 
 * @description : 自定义菜单参数验证
 * @author      : zhenyujian
 * @date        : 2016年1月14日 下午7:51:14 
 */
public class CustomMenuValidator {

	/**
	 * @Description  : 一级按钮名称
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月14日 下午8:20:02 
	 *
	 * @Return       : void
	 */
	public static void _4ButtonName(String name) throws ParameterException{
		if(name==null){
			throw new ParameterException("一级按钮名称不能为空");
		}
		
		if( !(name.length()>=0 && name.length()<=8) ){
			throw new ParameterException("一级按钮最多允许输入8个字符");
    	}
	}
	
	
	
	/**
	 * @Description  : 二级按钮名称
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月14日 下午8:21:52 
	 *
	 * @Return       : void
	 */
	public static void _4SubButtonName(String name) throws ParameterException{
		if(name==null){
			throw new ParameterException("二级按钮名称不能为空");
		}
		
		if( !(name.length()>=0 && name.length()<=7) ){
			throw new ParameterException("二级按钮最多允许输入7个字符");
    	}
	}
}

