/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.task;

import lombok.extern.slf4j.Slf4j;

import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncStatus;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.MediaService;

/**   
 * @title       : FansSyncJob 
 * @description : 更新微信图文素材列表
 * @author      : zhenyujian
 * @date        : 2015年12月9日 上午12:51:54 
 */
@Slf4j
public class MediaNewsSyncJob implements Runnable{
	
	private MediaService mediaService;
	private AuthorizerInfoService authorizerInfoService;
	private String authorizerAppId;
	
	public MediaNewsSyncJob(MediaService mediaService, String authorizerAppId, AuthorizerInfoService authorizerInfoService){
		this.mediaService = mediaService;
		this.authorizerInfoService = authorizerInfoService;
		this.authorizerAppId = authorizerAppId;
	}

	
	@Override
	public void run() {
		log.info("Wechat - MediaNewsSyncJob - run - start - authorizerAppId:{}",authorizerAppId);
		AuthorizerInfo authorizerInfo = authorizerInfoService.getByAuthorizerAppId(authorizerAppId);
		
		if(authorizerInfo.getMediaNewsSyncStatus().intValue() == WechatDataSyncStatus.ONGOING.getValue()){
			return;
		}
		
		authorizerInfo.setMediaNewsSyncStatus( WechatDataSyncStatus.ONGOING.getValue() );
		authorizerInfoService.update(authorizerInfo);
		
		try{
			Thread.currentThread().sleep(5000);//避免主从延迟
			mediaService.syncMediaNews(authorizerAppId);
		}catch(WechatException e){
			log.error("Wechat - MediaNewsSyncJob - WechatException - e:{}",e);
		}catch(Exception e){
			log.error("Wechat - MediaNewsSyncJob - Exception - e:{}",e);
		}finally{
			authorizerInfo.setMediaNewsSyncStatus( WechatDataSyncStatus.END_SUCCESS.getValue() );
			authorizerInfoService.update(authorizerInfo);
		}
		log.info("Wechat - MediaNewsSyncJob - run - end authorizerAppId:{}",authorizerAppId);
	}

}

