/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.webauth;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;

import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sal.wechat.dto.webauth.WebAuthorizationDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;

/**
 * @author : zhenyujian
 * @title : WechatWebAuthHelper
 * @description : 微信网页授权
 * @date : 2016年1月6日 下午10:53:56
 */
@Slf4j
public class WechatWebAuthHelper {


    /**
     * @Description : 通过微信 '网页授权' 的code换取 '用户网页授权token'
     * @Author : zhenyujian
     * @CreationDate : 2016年1月6日 下午4:14:33
     * @Return : String
     */
    public static WebAuthorizationDto getWebAuthorization(String appId, String code, String compAppId, String compAccessToken) {
        WebAuthorizationDto dto = null;

        WechatApiResponse result = WechatWebAuthCaller.getWebAuthorization(appId, code, compAppId, compAccessToken);
        if (result != null && !result.isError()) {
            dto = WebAuthorizationDto.fromJson(result.getJsonStr());
        } else {
            log.warn("wechat - getWebAuthorizationDtoByWebAuthCode - fail - json:{}", result);
        }
        return dto;
    }


    /**
     * @Description : 查询通过 '网页授权' 用户的基本信息   这里的accessToken是网页授权获得的 '用户网页授权token', 不是'服务号的accessToken'
     * 见 http://mp.weixin.qq.com/wiki/17/c0f37d5704f0b64713d5d2c37b468d75.html
     * @Author : zhenyujian
     * @CreationDate : 2016年1月6日 下午2:05:49
     * @Return : String
     */
    public static Fans getUserInfoByWebAuth(String webAuthAccessToken, String openId) {
        Fans fans = null;
        WechatApiResponse result = WechatWebAuthCaller.getUserInfoByWebAuth(webAuthAccessToken, openId);
        if (!result.isError()) {
            fans = new Fans();

            JSONObject rootNode = result.getRootJSONObj();
            fans.setOpenId(rootNode.getString("openid"));
            fans.setNick(rootNode.optString("nickname", ""));
            fans.setHeadImgUrl(rootNode.optString("headimgurl", ""));
            fans.setSex(rootNode.optInt("sex", 0));
            fans.setCity(rootNode.optString("city", ""));
            fans.setProvince(rootNode.optString("province", ""));
            fans.setCountry(rootNode.optString("country", ""));
        } else {
            log.warn("wechat - getWechatUserByWebAuthCode - fail - json:{}", result);
        }
        return fans;
    }
}

