/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.media;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import net.sf.json.JSONObject;

import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatRemoteCallHelper;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.common.collect.Maps;

/**   
 * @Title       : WechatMenuApiCaller 
 * @Description : 微信 素材管理 相关接口
 * @Author      : zhenyujian
 * @Date        : 2015年12月3日 下午4:09:56 
 */
public class WechatMediaApiCaller {
	
	/**
	 * @Description  : 新增临时素材
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月5日 下午6:27:31 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse uploadTempMedia(String accessToken, MediaType type, File file) throws WechatException, WebServiceException {
		StringBuilder builder = new StringBuilder();
		builder.append("https://api.weixin.qq.com/cgi-bin/media/upload?");
		builder.append("&access_token=").append(accessToken);
		builder.append("&type=").append(type.getStr());

        return WechatRemoteCallHelper.postFile(builder.toString(), null, file);
    }
	
	
	/**
	 * @Description  : 下载临时素材
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月5日 下午6:30:04 
	 *
	 * @Return       : byte[]
	 */
	public static byte[] downloadTempMedia(String accessToken, String mediaId) throws WechatException, WebServiceException, Exception{
		StringBuilder builder = new StringBuilder();
		builder.append("https://api.weixin.qq.com/cgi-bin/media/get?");
		builder.append("&access_token=").append(accessToken);
		builder.append("&media_id=").append(mediaId);

        return HttpClientUtils.download( builder.toString() );
    }
	
	
	/**
	 * @Description  : 上传永久素材
	 * 				   http://mp.weixin.qq.com/wiki/14/7e6c03263063f4813141c3e17dd4350a.html
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月23日 上午11:45:54 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse uploadPermanentMedia(String accessToken, MediaType mediaType, File file){
		StringBuilder builder = new StringBuilder();
		builder.append("https://api.weixin.qq.com/cgi-bin/material/add_material?");
		builder.append("&access_token=").append(accessToken);
		builder.append("&type=").append(mediaType.getStr());

		return WechatRemoteCallHelper.postWechatPermanentMedia(builder.toString(), null, file, mediaType);
	}
	
	
	
	/**
	 * @Description  : 上传永久图文素材 
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月23日 上午11:59:03 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse uploadPermanentNews(String accessToken, String json){
		StringBuilder builder = new StringBuilder();
		builder.append("https://api.weixin.qq.com/cgi-bin/material/add_news?");
		builder.append("&access_token=").append(accessToken);
        return WechatRemoteCallHelper.postJsonObj(builder.toString(), JSONObject.fromObject(json));
	}
	
	
	
	
	/**
	 * @Description  : 获取素材总数
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月28日 下午2:56:57 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse countPermanentMedia(String accessToken){
		StringBuilder builder = new StringBuilder();
		builder.append("https://api.weixin.qq.com/cgi-bin/material/get_materialcount?");
		builder.append("&access_token=").append(accessToken);
		return WechatRemoteCallHelper.get(builder.toString());
	}
	

	
	
	/**
	 * @Description  : 获取素材列表
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月28日 下午3:57:43 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse batchGetPermanentMedia(String accessToken, MediaType type, int offset, int count){
		StringBuilder builder = new StringBuilder();
		builder.append("https://api.weixin.qq.com/cgi-bin/material/batchget_material?");
		builder.append("&access_token=").append(accessToken);
		
		JSONObject json = new JSONObject();
		json.put("type", type.getStr());
		json.put("offset", offset);
		json.put("count", count);
		
		return WechatRemoteCallHelper.postJsonObj(builder.toString(), json, false);
	}
	
	
	/**
	 * @throws Exception 
	 * @Description  : 下载永久素材
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月4日 下午8:27:07 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static byte[] downloadPermanentMedia(String accessToken,String mediaId) throws Exception{
		StringBuilder builder = new StringBuilder();
		builder.append("https://api.weixin.qq.com/cgi-bin/material/get_material?");
		builder.append("&access_token=").append(accessToken);
		builder.append("&media_id=").append(mediaId);

		Map<String, String> params = Maps.newHashMap();
		params.put("media_id", mediaId );

        return HttpClientUtils.downloadByPost( builder.toString() , params);
	}
	
	
	
	/**
	 * @Description  : 查询永久图文素材
	 * @Author       : zhenyujian
	 * @Date         : 2016年3月21日 下午4:27:05 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse getPermanentMediaNews(String accessToken,String mediaId){
		StringBuilder builder = new StringBuilder();
		builder.append("https://api.weixin.qq.com/cgi-bin/material/get_material?");
		builder.append("&access_token=").append(accessToken);
		builder.append("&media_id=").append(mediaId);

		Map<String, Object> params = Maps.newHashMap();
		params.put("media_id", mediaId );

		return WechatRemoteCallHelper.postJson(builder.toString(), params, false);
	}
	
	
	
	/**
	 * @Description  : 删除永久素材
	 * @Author       : zhenyujian
	 * @Date         : 2016年3月21日 下午5:27:35 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse delPermanentMediaNews(String accessToken,String mediaId){
		StringBuilder builder = new StringBuilder();
		builder.append("https://api.weixin.qq.com/cgi-bin/material/del_material?");
		builder.append("&access_token=").append(accessToken);
		builder.append("&media_id=").append(mediaId);

		Map<String, Object> params = Maps.newHashMap();
		params.put("media_id", mediaId );

		return WechatRemoteCallHelper.postJson(builder.toString(), params);
	}
	
	
	/**
	 * @Description  : 上传图文素材中的图片
	 * @Author       : zhenyujian
	 * @Date         : 2016年3月30日 下午1:16:53 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse uploadPermanentMediaNewsImg(String accessToken, File file){
		StringBuilder builder = new StringBuilder();
		builder.append("https://api.weixin.qq.com/cgi-bin/media/uploadimg?");
		builder.append("&access_token=").append(accessToken);

		return WechatRemoteCallHelper.postWechatPermanentMedia(builder.toString(), null, file, MediaType.IMAGE);
	}
	
	
   public static void main(String args[]){
    	String url = "https://api.weixin.qq.com/cgi-bin/material/batchget_material?access_token=Po2w3Y4PaZRnkuky46WnxSTqBBOBlWEOJW54oMp5FBn5MK3c3iX6A7qCqp4o_mQ__RSeikZOsO8T5Z74wvnQAunaMgw7FAQm4xhBGF4aHxwHTIbAJAWIX";
    	Map<String,Object> params = new HashMap<String,Object>();
    	params.put("type", "image");
    	params.put("offset", "0");
    	params.put("count", "10");
    	WechatApiResponse response = WechatRemoteCallHelper.postJson(url, params);
    	System.out.println(response);
    }

}

