/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.templatemsg.evaluation;

import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.WechatTemplateMsg;

import net.sf.json.JSONObject;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**   
 * @title       : CourseStartNoticeMsg 
 * @description : 评价提醒 - 学生
 * @author      : zhenyujian
 * @date        : 2016年1月5日 下午9:05:03 
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class CourseEvaluationMsgToStu extends WechatTemplateMsg{
	
	private Integer orgId;
	private String openId;
	
	private String orgName;
	private String courseName;
	private String studentName;
	private Integer lessonNo;
	private String teacherName;
	
	
	public CourseEvaluationMsgToStu(){
		this.msgType = WechateTemplateMsgType.COURSE_EVALUATION_TO_STU;
	}
	
	
	
	/**
	 * @Description  : 创建微信模板消息 用于调用微信api
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午12:50:29 
	 *
	 * @Return       : String
	 */
	public String buildTemplateMsg(String templateId){
		this.first = String.format("【%s】,您好:\n\n您已在【%s】完成一次课。是否对本次课满意呢? 快去给老师打分吧。\n",
									studentName, courseName);
		this.remark = "\n点击这里去给老师评价吧!";
		
		JSONObject data = new JSONObject();
		data.put("keyword1", getTemplateMsgNode( studentName ) );
		data.put("keyword2", getTemplateMsgNode( courseName ) );
		data.put("keyword3", getTemplateMsgNode( teacherName ) );
		
		return super.buildBaseTemplateMsg(openId, templateId, data).toString();
	}
	
	
	
	/**
	 * @Description  : json转换成对象
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午12:29:30 
	 *
	 * @Return       : CourseStartNoticeMsg
	 */
	public static CourseEvaluationMsgToStu fromJsonStr(String jsonStr){
		CourseEvaluationMsgToStu msg = new CourseEvaluationMsgToStu();
		
		JSONObject json = JSONObject.fromObject(jsonStr);
		msg.fillBaseInfo(jsonStr);
		msg.setOrgId( json.optInt("orgId") );
		msg.setOpenId( json.getString("openId"));
		
		msg.setOrgName( json.optString("orgName") );
		msg.setCourseName( json.optString("courseName") );
		msg.setStudentName( json.optString("studentName") );
		msg.setLessonNo( json.optInt("lessonNo") );
		msg.setTeacherName( json.optString("teacherName") );

		return msg;
	}
	
	
	
	/**
	 * @Description  : 对象转换成json
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午12:29:38 
	 *
	 * @Return       : String
	 */
	public String toJsonStr(){
		JSONObject json = super.getBaseJson();
		json.put("orgId", checkNull(this.orgId) );
		json.put("openId", checkNull(this.openId));

		json.put("orgName", checkNull(this.orgName));
		json.put("courseName", checkNull(this.courseName));
		json.put("studentName", checkNull(this.studentName));
		json.put("lessonNo", checkNull(this.lessonNo));
		json.put("teacherName", checkNull(this.teacherName));
		
		return json.toString();
	}
	
	
	public void setOrgId(Integer orgId){
		this.orgId = orgId;
	}
	public void setOrgId(Long orgId){
		this.orgId = Integer.parseInt(orgId.toString());
	}
}

