/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.qrcode;

import org.apache.commons.lang.builder.ToStringBuilder;

import com.baijia.tianxiao.sal.wechat.constant.qrcode.QRCodeType;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @title : QRCodeSceneStrAcitivity
 * @description : 活动(抽奖、砸金蛋) - 关注二维码
 * @author : zhenyujian
 * @date : 2016年1月28日 下午2:20:50
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class QRCodeSceneStrActivity extends QRCodeSceneStr {

    private static final String JSON_KEY_ACTIVITY_ID = "aid";
    private static final String JSON_KEY_ACTIVITY_TYPE = "at";
    private static final String JSON_KEY_ORIGIN_ORG_ID = "originOrgId";

    private Integer activityId;
    private Integer activityType;

    private Integer originOrgId;

    public QRCodeSceneStrActivity() {
        super.qrCodeType = QRCodeType.CUSTOM_ACTIVITY;
    }

    public QRCodeSceneStrActivity(Integer activityId, Integer activityType) {
        this(activityId, activityType, null);
    }

    public QRCodeSceneStrActivity(Integer activityId, Integer activityType, Integer originOrgId) {
        super.qrCodeType = QRCodeType.CUSTOM_ACTIVITY;
        this.activityId = activityId;
        this.activityType = activityType;
        this.originOrgId = originOrgId;
    }

    public String getSceneStr() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.getSceneStr());
        builder.append(QRCodeSceneStr.createSceneStrParam(JSON_KEY_ACTIVITY_ID, this.activityId));
        builder.append(QRCodeSceneStr.createSceneStrParam(JSON_KEY_ACTIVITY_TYPE, this.activityType));
        if (originOrgId != null) {
            builder.append(QRCodeSceneStr.createSceneStrParam(JSON_KEY_ORIGIN_ORG_ID, this.originOrgId));
        }
        return builder.toString();
    }

    public static QRCodeSceneStrActivity fromSceneStr(String str) {
        QRCodeSceneStrActivity dto = new QRCodeSceneStrActivity();
        dto.setActivityId(Integer.parseInt(QRCodeSceneStr.parseSceneStrParam(str, JSON_KEY_ACTIVITY_ID)));
        dto.setActivityType(Integer.parseInt(QRCodeSceneStr.parseSceneStrParam(str, JSON_KEY_ACTIVITY_TYPE)));
        return dto;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
