/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.org;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.wechat.constant.WechatOpenIdEntityType;
import com.baijia.tianxiao.dto.smstoken.WechatSmsTokenDto;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.util.CourseSmsTokenUtil;
import com.google.common.collect.Maps;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;


/**   
 * @title       : OrgCenterLink 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年8月29日 上午10:45:41 
 */
@Data
@Slf4j
public class OrgCenterInfo {

	private WechatOpenIdEntityType type;
	private String orgName;
	private String orgShortName;
	private Integer orgId;
	private Integer orgNumber;
	private String appId;
	private String url;
	
	
	public String getUrl(){
		if(this.type!=null){
			switch (this.type) {
				case STUDENT:
					this.url = WechatWebAuthLinkBuilder.studentCenter(WebAuthScope.BASE, appId, orgId.longValue());
					break;
					
				case TEACHER:
					this.url = WechatWebAuthLinkBuilder.teacherCenter(WebAuthScope.BASE, appId, orgId.longValue());
					break;
					
				default:
					break;
			}
		}
		return this.url;
	}
	

	
	
	public static List<OrgCenterInfo> convertBy(String appId,List<OrgInfo> orgInfos, WechatOpenIdEntityType type){
		List<OrgCenterInfo> list = new ArrayList<OrgCenterInfo>();
		OrgCenterInfo ocInfo = null;
		if(CollectionUtils.isNotEmpty(orgInfos)){
			for(OrgInfo info:orgInfos){
				ocInfo = new OrgCenterInfo();
				ocInfo.setAppId(appId);
				ocInfo.setOrgId(info.getOrgId());
				ocInfo.setOrgName(info.getName());
				ocInfo.setOrgShortName(info.getShortName());
				ocInfo.setType(type);
				list.add(ocInfo);
			}
		}
		return list;
	}
	
	
	public static String getCenterSelectUrl(Long orgId, String wechatAppId){
		String fmt = "%swechat/webauth/centerSelect.do?sms_token=%s";
		WechatSmsTokenDto dto = new WechatSmsTokenDto(orgId, wechatAppId); 
		try {
			fmt = String.format(fmt, WechatProperties.getWebCRMUrlPrefix(), dto.toTokenStr());
		} catch (Exception e) {
			log.error("",e);
		}
		return fmt;
	}
	
	
	@Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}

